/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

public class HtmlScanner {
    private String m_doc;
    private int m_len;
    private int m_ix;
    private int m_start_ix;
    private String m_lasttag;
    private boolean m_unquote;

    public HtmlScanner() {
    }

    public HtmlScanner(boolean unquote) {
        this.m_unquote = unquote;
    }

    public static String unquote(String s) {
        char c2;
        int l = s.length();
        if (l < 2) {
            return s;
        }
        char c1 = s.charAt(0);
        if (c1 != (c2 = s.charAt(l - 1))) {
            return s;
        }
        if (c1 == '\'' || c1 == '\"') {
            return s.substring(1, l - 1);
        }
        return s;
    }

    public HtmlScanner duplicate() {
        HtmlScanner hs = new HtmlScanner();
        this.assignTo(this);
        return hs;
    }

    public void assignTo(HtmlScanner hs) {
        hs.m_doc = this.m_doc;
        hs.m_len = this.m_len;
        hs.m_ix = this.m_ix;
        hs.m_lasttag = this.m_lasttag;
        hs.m_start_ix = this.m_start_ix;
    }

    public void setDocument(String s) {
        this.m_doc = s;
        this.m_ix = 0;
        this.m_len = s.length();
        this.m_start_ix = 0;
    }

    public String getDocument() {
        return this.m_doc;
    }

    public void moveTo(int ix) {
        this.m_ix = ix;
    }

    public void reset() {
        this.m_ix = 0;
        this.m_start_ix = 0;
    }

    public int getPos() {
        return this.m_ix;
    }

    public int getStartPos() {
        return this.m_start_ix;
    }

    public int inc() {
        if (this.m_ix < this.m_len) {
            ++this.m_ix;
        }
        return this.m_ix;
    }

    public String getCurrentTag() {
        return this.m_lasttag;
    }

    public boolean findTag(String name) {
        this.m_lasttag = null;
        int nl = name.length();
        int ix = this.m_ix;
        while (ix < this.m_len) {
            int tp = this.m_doc.indexOf(60, ix);
            if (tp == -1) {
                return false;
            }
            this.m_start_ix = tp++;
            int te = this.scanTagName(tp);
            if (nl == te - tp && this.m_doc.regionMatches(true, tp, name, 0, nl)) {
                this.m_ix = tp - 1;
                return true;
            }
            ix = tp;
        }
        return false;
    }

    public String nextTag() {
        this.m_lasttag = null;
        int ix = this.m_ix;
        while (ix < this.m_len) {
            int te;
            int tp = this.m_doc.indexOf(60, ix);
            if (tp == -1) {
                return null;
            }
            if ((te = this.scanTagName(++tp)) > tp) {
                String s = this.m_doc.substring(tp, te);
                this.m_ix = tp - 1;
                this.m_lasttag = s;
                return this.m_lasttag;
            }
            ix = tp;
        }
        return null;
    }

    public String tagParseInit() {
        int ep;
        int ix = this.m_ix;
        if (ix >= this.m_len) {
            throw new IllegalStateException("Current pos is eof.");
        }
        if (this.m_doc.charAt(ix) != '<') {
            throw new IllegalStateException("Current pos is not at tag start.");
        }
        if ((ep = this.scanTagName(++ix)) <= ix) {
            throw new IllegalStateException("Current pos is not at tag start.");
        }
        String name = this.m_doc.substring(ix, ep);
        this.m_ix = ep;
        return name;
    }

    public String tagParseParamName() {
        int ix = this.skipWS(this.m_ix);
        int ep = this.scanAttributeName(ix);
        if (ep <= ix) {
            return null;
        }
        this.m_start_ix = this.m_ix;
        this.m_ix = ep;
        return this.m_doc.substring(ix, ep);
    }

    public String tagParseValue() {
        int ix = this.skipWS(this.m_ix);
        if (ix >= this.m_len) {
            return null;
        }
        if (this.m_doc.charAt(ix) != '=') {
            return null;
        }
        if ((ix = this.skipWS(ix + 1)) >= this.m_len) {
            return "";
        }
        int vsix = ix;
        char qc = this.m_doc.charAt(ix);
        if (qc != '\'' && qc != '\"') {
            while (ix < this.m_len && HtmlScanner.isAttrValueChar(qc = this.m_doc.charAt(ix))) {
                ++ix;
            }
            this.m_ix = ix;
            String v = this.m_doc.substring(vsix, ix);
            return this.m_unquote ? HtmlScanner.unquote(v) : v;
        }
        ++ix;
        while (ix < this.m_len) {
            char c = this.m_doc.charAt(ix);
            if (c == qc) {
                ++ix;
                break;
            }
            ++ix;
        }
        this.m_ix = ix;
        String v = this.m_doc.substring(vsix, ix);
        return this.m_unquote ? HtmlScanner.unquote(v) : v;
    }

    public boolean tagIsTagEnd() {
        int ix = this.skipWS(this.m_ix);
        if (ix >= this.m_len) {
            return true;
        }
        if (this.m_doc.charAt(ix) == '>') {
            this.m_ix = ix + 1;
            return true;
        }
        if (this.m_doc.charAt(ix) == '/' && ix + 1 < this.m_len && this.m_doc.charAt(ix + 1) == '>') {
            this.m_ix = ix + 2;
            return true;
        }
        return false;
    }

    public boolean atEof() {
        return this.skipWS(this.m_ix) >= this.m_len;
    }

    public boolean atEof(int pos) {
        return pos >= this.m_len;
    }

    private int scanEndString(int six, char qc) {
        for (int ix = six; ix < this.m_len; ++ix) {
            char c = this.m_doc.charAt(ix);
            if (c != qc) continue;
            return ix + 1;
        }
        return six;
    }

    public boolean tagToEnd() {
        int ix = this.m_ix;
        while (ix < this.m_len) {
            char c = this.m_doc.charAt(ix);
            if (c == '\'' || c == '\"') {
                ix = this.scanEndString(ix + 1, c);
                continue;
            }
            if (c == '>') {
                this.m_ix = ix + 1;
                return true;
            }
            ++ix;
        }
        return false;
    }

    public boolean findMatchingEndTag(String tag) {
        String ts;
        int stix = this.m_ix;
        int nl = 0;
        String etag = "/" + tag;
        while ((ts = this.nextTag()) != null) {
            if (ts.equalsIgnoreCase(etag)) {
                if (nl == 0) {
                    return true;
                }
                --nl;
            } else if (ts.equalsIgnoreCase(tag)) {
                ++nl;
            }
            this.tagParseInit();
            this.tagToEnd();
        }
        this.m_ix = stix;
        return false;
    }

    public void skipTag() {
        if (this.m_ix >= this.m_len) {
            return;
        }
        if (this.m_doc.charAt(this.m_ix) != '<') {
            return;
        }
        this.tagParseInit();
        this.tagToEnd();
    }

    private int scanTagName(int six) {
        char c;
        int ix;
        for (ix = six; ix < this.m_len && HtmlScanner.isTagChar(c = this.m_doc.charAt(ix)); ++ix) {
        }
        return ix;
    }

    private int scanAttributeName(int six) {
        char c;
        int ix;
        for (ix = six; ix < this.m_len && HtmlScanner.isAttrNameChar(c = this.m_doc.charAt(ix)); ++ix) {
        }
        return ix;
    }

    private static boolean isTagChar(char c) {
        return Character.isLetterOrDigit(c) || c == ':' || c == '.' || c == '_' || c == '/' || c == '!';
    }

    private static boolean isAttrValueChar(char c) {
        return Character.isLetterOrDigit(c) || c == ':' || c == '.' || c == '_';
    }

    private static boolean isAttrNameChar(char c) {
        return Character.isLetterOrDigit(c) || c == ':' || c == '.' || c == '_';
    }

    private int skipWS(int ix) {
        while (ix < this.m_len) {
            char c = this.m_doc.charAt(ix);
            if (!Character.isWhitespace(c)) {
                return ix;
            }
            ++ix;
        }
        return ix;
    }
}

