/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class IndentWriter
extends Writer {
    private Writer m_pw;
    private int m_spacesPerLevel = 2;
    private int m_ind_level = 0;
    private int m_ind_x = 0;
    private boolean m_dontclose;
    private boolean m_indentEnabled = true;
    private static final char[] SPACES = "                                                                                                                                                                 ".toCharArray();

    public IndentWriter() {
    }

    public IndentWriter(Writer w) {
        this.m_pw = w;
    }

    public IndentWriter(Writer w, boolean dontclose) {
        this.m_pw = w;
        this.m_dontclose = dontclose;
    }

    public void init(Writer w, int indentlevel) {
        this.m_pw = w;
        this.m_ind_x = 0;
        this.m_ind_level = indentlevel;
    }

    public boolean isIndentEnabled() {
        return this.m_indentEnabled;
    }

    public void setIndentEnabled(boolean indentEnabled) {
        this.m_indentEnabled = indentEnabled;
    }

    @Override
    public void close() throws IOException {
        if (this.m_dontclose) {
            this.m_pw.flush();
        } else {
            this.m_pw.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.m_pw.flush();
    }

    public void setInd(int i) {
        this.m_ind_level = i;
    }

    public void setSpacesPerIndent(int spi) {
        this.m_spacesPerLevel = spi;
    }

    public void writeRaw(String s) throws IOException {
        this.m_pw.write(s);
        this.m_ind_x += s.length();
    }

    public void writeRaw(char[] buf, int off, int len) throws IOException {
        this.m_pw.write(buf, off, len);
        this.m_ind_x += len;
    }

    public void writeRaw(String buf, int off, int len) throws IOException {
        this.m_pw.write(buf, off, len);
        this.m_ind_x += len;
    }

    public void indent() throws IOException {
        if (!this.m_indentEnabled) {
            return;
        }
        int ex = this.m_ind_level * this.m_spacesPerLevel;
        if (ex > SPACES.length) {
            ex = SPACES.length;
        }
        if (this.m_ind_x >= ex) {
            return;
        }
        this.m_pw.write(SPACES, 0, ex - this.m_ind_x);
        this.m_ind_x = ex;
    }

    @Override
    public void write(char[] buf, int off, int len) throws IOException {
        int ix;
        int eoff = off + len;
        int spos = ix = off;
        while (ix < eoff) {
            char c = buf[ix];
            if (c == '\n') {
                if (ix > spos) {
                    this.indent();
                    this.m_pw.write(buf, spos, ix - spos);
                }
                spos = ++ix;
                this.m_pw.write(10);
                this.m_ind_x = 0;
                continue;
            }
            ++ix;
        }
        if (spos < eoff) {
            this.indent();
            this.m_pw.write(buf, spos, eoff - spos);
            this.m_ind_x += eoff - spos;
        }
    }

    @Override
    public void write(String str) throws IOException {
        int ix = 0;
        int len = str.length();
        while (ix < len) {
            int epos = str.indexOf(10, ix);
            if (epos == -1) {
                this.indent();
                this.m_pw.write(str, ix, len - ix);
                this.m_ind_x += len - ix;
                return;
            }
            this.indent();
            this.m_pw.write(str, ix, ++epos - ix);
            this.m_ind_x = 0;
            ix = epos;
        }
    }

    public void inc() {
        ++this.m_ind_level;
    }

    public void dec() {
        if (this.m_ind_level > 0) {
            --this.m_ind_level;
        }
    }

    public void forceNewline() throws IOException {
        if (this.m_ind_x > 0) {
            this.m_pw.write(10);
            this.m_ind_x = 0;
        }
    }

    public void println() throws IOException {
        this.m_pw.write(10);
        this.m_ind_x = 0;
    }

    public void print(String s) throws IOException {
        this.write(s);
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.m_pw.write(10);
        this.m_ind_x = 0;
    }

    public Writer getWriter() {
        return this.m_pw;
    }

    public static IndentWriter getStdoutWriter() {
        OutputStreamWriter osw = new OutputStreamWriter(System.out);
        return new IndentWriter(osw, true);
    }
}

