/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class LRUHashMap<K, V>
implements Map<K, V> {
    static final Object NULL = new Object();
    private static final float LOAD = 0.75f;
    transient Entry<K, V>[] m_buckets;
    private Entry<K, V> m_lruFirst;
    private Entry<K, V> m_lruLast;
    transient int m_currentSize;
    private transient int m_maxSize;
    private int m_threshold;
    volatile transient int m_updateCounter;
    private transient Set<Map.Entry<K, V>> m_entrySet = null;
    private transient Set<K> m_keySet = null;
    private transient Collection<V> m_values = null;

    public LRUHashMap(int maxsize) {
        this(maxsize, 16);
    }

    public LRUHashMap(int maxsize, int initial) {
        int capacity;
        this.m_maxSize = maxsize;
        for (capacity = 1; capacity <= initial; capacity <<= 1) {
        }
        this.m_threshold = (int)((float)(--capacity) * 0.75f);
        this.m_buckets = new Entry[capacity];
    }

    private static <K> Object encodeKey(K key) {
        return key == null ? NULL : key;
    }

    static <K> K decodeKey(Object key) {
        return (K)(key == NULL ? null : key);
    }

    private static int hash(Object x) {
        int h = x.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h & Integer.MAX_VALUE;
    }

    @Override
    public int size() {
        return this.m_currentSize;
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }

    @Override
    public boolean isEmpty() {
        return this.m_currentSize == 0;
    }

    @Override
    public void clear() {
        ++this.m_updateCounter;
        Entry<K, V>[] tab = this.m_buckets;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.m_currentSize = 0;
    }

    private void link(Entry<K, V> e) {
        this.unlink(e);
        if (this.m_lruFirst == null) {
            this.m_lruFirst = e;
            this.m_lruLast = e;
            e.m_lruNext = e;
            e.m_lruPrev = e;
            return;
        }
        e.m_lruPrev = this.m_lruFirst;
        e.m_lruNext = this.m_lruLast;
        this.m_lruLast.m_lruPrev = e;
        this.m_lruFirst.m_lruNext = e;
        this.m_lruFirst = e;
    }

    private void unlink(Entry<K, V> e) {
        if (e.m_lruNext == null) {
            return;
        }
        if (e.m_lruNext == e.m_lruPrev) {
            this.m_lruFirst = null;
            this.m_lruLast = null;
            e.m_lruNext = null;
            e.m_lruPrev = null;
            return;
        }
        if (this.m_lruFirst == e) {
            this.m_lruFirst = e.m_lruPrev;
        }
        if (this.m_lruLast == e) {
            this.m_lruLast = e.m_lruNext;
        }
        e.m_lruPrev.m_lruNext = e.m_lruNext;
        e.m_lruNext.m_lruPrev = e.m_lruPrev;
        e.m_lruPrev = null;
        e.m_lruNext = null;
    }

    Entry<K, V> getEntry(Object key) {
        Object k = LRUHashMap.encodeKey(key);
        int hash = LRUHashMap.hash(k);
        Entry<K, V> e = this.m_buckets[hash % this.m_buckets.length];
        while (e != null && (e.m_hashCode != hash || k != e.m_key && !k.equals(e.m_key))) {
            e = e.m_bucketNext;
        }
        return e;
    }

    @Override
    public V get(Object key) {
        Entry<K, V> e = this.getEntry(key);
        if (e == null) {
            return null;
        }
        this.unlink(e);
        this.link(e);
        return e.getValue();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public V put(K key, V value) {
        Object k = LRUHashMap.encodeKey(key);
        int hash = LRUHashMap.hash(k);
        int index = hash % this.m_buckets.length;
        Entry<K, V> e = this.m_buckets[index];
        while (e != null) {
            if (e.m_hashCode == hash && (k == e.m_key || k.equals(e.m_key))) {
                Object old = e.m_value;
                e.m_value = value;
                this.link(e);
                return old;
            }
            e = e.m_bucketNext;
        }
        ++this.m_updateCounter;
        ++this.m_currentSize;
        if (this.m_currentSize >= this.m_threshold) {
            this.resize(2 * this.m_buckets.length - 1);
            index = hash % this.m_buckets.length;
        }
        e = new Entry(hash, k, value);
        e.m_bucketNext = this.m_buckets[index];
        this.m_buckets[index] = e;
        this.link(e);
        while (this.m_currentSize > this.m_maxSize) {
            e = this.m_lruLast;
            int ocs = this.m_currentSize;
            this.removeEntry(e);
            if (this.m_currentSize != ocs) continue;
            throw new IllegalStateException("Fail to remove entry: " + e);
        }
        return null;
    }

    private void resize(int newsize) {
        this.m_threshold = (int)((float)newsize * 0.75f);
        Entry<K, V>[] oldt = this.m_buckets;
        this.m_buckets = new Entry[newsize];
        int i = oldt.length;
        while (--i >= 0) {
            Entry<K, V> curr = oldt[i];
            while (curr != null) {
                Entry<K, V> e = curr;
                curr = e.m_bucketNext;
                int index = e.m_hashCode % newsize;
                e.m_bucketNext = this.m_buckets[index];
                this.m_buckets[index] = e;
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        int newtotal = numKeysToBeAdded + this.m_currentSize;
        if (newtotal > this.m_maxSize) {
            newtotal = this.m_maxSize;
        }
        if (newtotal > this.m_threshold) {
            int newsize;
            for (newsize = this.m_buckets.length; newsize <= newtotal; newsize <<= 1) {
            }
            if (newsize > this.m_buckets.length) {
                this.resize(newsize);
            }
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> e = this._remove(key);
        return e == null ? null : (V)e.m_value;
    }

    Entry<K, V> _remove(Object key) {
        Object k = LRUHashMap.encodeKey(key);
        int hc = LRUHashMap.hash(k);
        int index = hc % this.m_buckets.length;
        Entry<K, V> prev = null;
        Entry<K, V> e = this.m_buckets[index];
        while (e != null) {
            if (e.m_hashCode == hc && (e.m_key == k || k.equals(e.m_key))) {
                if (prev == null) {
                    this.m_buckets[index] = e.m_bucketNext;
                } else {
                    prev.m_bucketNext = e.m_bucketNext;
                }
                this.unlink(e);
                --this.m_currentSize;
                ++this.m_updateCounter;
                return e;
            }
            prev = e;
            e = e.m_bucketNext;
        }
        return null;
    }

    Entry<K, V> removeEntry(Object o) {
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        return this._remove(((Map.Entry)o).getKey());
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int i = this.m_buckets.length;
            while (--i >= 0) {
                Entry<K, V> e = this.m_buckets[i];
                while (e != null) {
                    if (e.m_value == null) {
                        return true;
                    }
                    e = e.m_bucketNext;
                }
            }
            return false;
        }
        int i = this.m_buckets.length;
        while (--i >= 0) {
            Entry<K, V> e = this.m_buckets[i];
            while (e != null) {
                if (value == e.m_value || value.equals(e.m_value)) {
                    return true;
                }
                e = e.m_bucketNext;
            }
        }
        return false;
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<K> keySet() {
        if (this.m_keySet == null) {
            this.m_keySet = new KeySet();
        }
        return this.m_keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.m_values == null) {
            this.m_values = new ValuesCollection();
        }
        return this.m_values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.m_entrySet == null) {
            this.m_entrySet = new EntrySet();
        }
        return this.m_entrySet;
    }

    public static void main(String[] args) {
        LRUHashMap<Integer, Integer> map = new LRUHashMap<Integer, Integer>(1000);
        try {
            for (int i = 0; i < 100000; ++i) {
                Integer iv = i;
                map.put(iv, iv);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private class EntrySet
    extends AbstractSet {
        @Override
        public Iterator iterator() {
            return LRUHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Entry candidate = LRUHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return LRUHashMap.this.removeEntry(o) != null;
        }

        @Override
        public int size() {
            return LRUHashMap.this.m_currentSize;
        }

        @Override
        public void clear() {
            LRUHashMap.this.clear();
        }
    }

    private class ValuesCollection
    extends AbstractCollection<V> {
        @Override
        public Iterator<V> iterator() {
            return LRUHashMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return LRUHashMap.this.m_currentSize;
        }

        @Override
        public boolean contains(Object o) {
            return LRUHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            LRUHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        @Override
        public Iterator<K> iterator() {
            return LRUHashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return LRUHashMap.this.m_currentSize;
        }

        @Override
        public boolean contains(Object o) {
            return LRUHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return LRUHashMap.this._remove(o) != null;
        }

        @Override
        public void clear() {
            LRUHashMap.this.clear();
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator<K> {
        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        @Override
        public V next() {
            return this.nextEntry().m_value;
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        int m_bucketIndex;
        Entry<K, V> m_next;
        int m_currentUpdateCount;
        Entry<K, V> m_current;

        HashIterator() {
            this.m_currentUpdateCount = LRUHashMap.this.m_updateCounter;
            Entry e = null;
            if (LRUHashMap.this.m_currentSize > 0) {
                int bucket = LRUHashMap.this.m_buckets.length;
                while (--bucket >= 0) {
                    e = LRUHashMap.this.m_buckets[bucket];
                    if (e == null) continue;
                    this.m_bucketIndex = bucket;
                    this.m_next = e;
                    break;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.m_next != null;
        }

        Entry<K, V> nextEntry() {
            if (LRUHashMap.this.m_updateCounter != this.m_currentUpdateCount) {
                throw new ConcurrentModificationException();
            }
            if (this.m_next == null) {
                throw new NoSuchElementException();
            }
            this.m_current = this.m_next;
            this.m_next = this.m_next.m_bucketNext;
            if (this.m_next == null) {
                while (--this.m_bucketIndex >= 0) {
                    this.m_next = LRUHashMap.this.m_buckets[this.m_bucketIndex];
                    if (this.m_next == null) continue;
                    break;
                }
            }
            return this.m_current;
        }

        @Override
        public void remove() {
            if (this.m_current == null) {
                throw new IllegalStateException();
            }
            if (LRUHashMap.this.m_updateCounter != this.m_currentUpdateCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.m_current.m_key;
            this.m_current = null;
            LRUHashMap.this._remove(k);
            this.m_currentUpdateCount = LRUHashMap.this.m_updateCounter;
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        final Object m_key;
        V m_value;
        final int m_hashCode;
        Entry<K, V> m_bucketNext;
        Entry<K, V> m_lruNext;
        Entry<K, V> m_lruPrev;

        Entry(int hashCode, Object k, V v) {
            this.m_value = v;
            this.m_key = k;
            this.m_hashCode = hashCode;
        }

        @Override
        public K getKey() {
            return LRUHashMap.decodeKey(this.m_key);
        }

        @Override
        public V getValue() {
            return this.m_value;
        }

        @Override
        public V setValue(V value) {
            V old = this.m_value;
            this.m_value = value;
            return old;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            return (this.m_key == NULL ? 0 : this.m_key.hashCode()) ^ (this.m_value == null ? 0 : this.m_value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

