/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.util.WrappedException;

public class LineIterator
implements Iterable<String>,
Iterator<String> {
    private LineNumberReader m_reader;
    private boolean m_eof;
    @Nullable
    private String m_nextLine;

    public LineIterator(String s) {
        this.m_reader = new LineNumberReader(new StringReader(s));
    }

    public LineIterator(Reader r) {
        this.m_reader = r instanceof LineNumberReader ? (LineNumberReader)r : new LineNumberReader(r);
    }

    @Override
    @Nonnull
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.m_nextLine != null) {
            return true;
        }
        if (this.m_eof) {
            return false;
        }
        try {
            this.m_nextLine = this.m_reader.readLine();
            this.m_eof = this.m_nextLine == null;
            return !this.m_eof;
        }
        catch (IOException x) {
            throw WrappedException.wrap(x);
        }
    }

    @Override
    @Nullable
    public String next() {
        if (this.m_nextLine == null) {
            throw new IllegalStateException("Call hasNext 1st");
        }
        String s = this.m_nextLine;
        this.m_nextLine = null;
        return s;
    }

    @Override
    public void remove() {
    }
}

