/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

public final class PathSplitter {
    private String m_path;
    private int m_length;
    private int m_curstart;
    private int m_curend;
    private int m_nextstart;
    private boolean m_endWithSlash;
    private String m_current;
    private String m_rest;
    private String m_currest;

    public PathSplitter() {
    }

    public PathSplitter(String path) {
        this.init(path);
    }

    public void init(String path) {
        this.m_path = path;
        this.m_length = path.length();
        this.m_curstart = 0;
        this.m_nextstart = 0;
        this.m_current = null;
        this.m_rest = null;
        this.m_currest = null;
        this.next();
    }

    public String getPath() {
        return this.m_path;
    }

    public boolean next() {
        if (this.m_nextstart >= this.m_length) {
            return false;
        }
        this.m_curstart = this.m_nextstart;
        this.m_curend = this.m_nextstart;
        this.m_current = null;
        this.m_rest = null;
        this.m_currest = null;
        this.m_endWithSlash = false;
        int ix = this.m_path.indexOf(47, this.m_curstart);
        if (ix < 0) {
            this.m_nextstart = this.m_length;
            this.m_curend = this.m_length;
            return true;
        }
        this.m_curend = ix;
        this.m_nextstart = ix + 1;
        this.m_endWithSlash = true;
        return true;
    }

    public String getCurrent() {
        if (this.m_current == null) {
            this.m_current = this.m_path.substring(this.m_curstart, this.m_curend);
        }
        return this.m_current;
    }

    public String getCurrentAndRest() {
        if (this.m_currest == null) {
            this.m_currest = this.m_path.substring(this.m_curstart);
        }
        return this.m_currest;
    }

    public String getRest() {
        if (this.m_rest == null) {
            this.m_rest = this.m_path.substring(this.m_nextstart);
        }
        return this.m_rest;
    }

    public String getUptoCurrent() {
        return this.m_path.substring(0, this.m_curend);
    }

    public boolean isRestEmpty() {
        return this.m_nextstart >= this.m_length;
    }

    public boolean endsWithSlash() {
        return this.m_endWithSlash;
    }

    public boolean isEmpty() {
        return this.m_curstart >= this.m_length;
    }

    public boolean isEqual(String str) {
        int sl = str.length();
        if (this.m_curend - this.m_curstart != sl) {
            return false;
        }
        int rix = this.m_curend;
        while (--sl >= 0) {
            if (str.charAt(sl) == this.m_path.charAt(--rix)) continue;
            return false;
        }
        return true;
    }
}

