/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public final class ProcessTools {
    @Nonnull
    private final ProcessBuilder m_builder;
    private Writer m_stdout;
    private Writer m_stderr;
    private IFollow m_follow;
    private boolean m_flush;

    public ProcessTools() {
        this.m_builder = new ProcessBuilder(new String[0]);
    }

    public ProcessTools(@Nonnull ProcessBuilder pb) {
        this.m_builder = pb;
    }

    @Nonnull
    public ProcessTools stdout(@Nonnull Writer stdout) {
        this.m_stdout = stdout;
        return this;
    }

    @Nonnull
    public ProcessTools stderr(@Nonnull Writer stderr) {
        this.m_stderr = stderr;
        return this;
    }

    @Nonnull
    public ProcessTools add(@Nonnull String cmd) {
        this.m_builder.command().add(cmd);
        return this;
    }

    @Nonnull
    public ProcessTools add(@Nonnull List<String> cmd) {
        this.m_builder.command().addAll(cmd);
        return this;
    }

    @Nonnull
    public ProcessTools add(String ... args) {
        for (String s : args) {
            this.m_builder.command().add(s);
        }
        return this;
    }

    @Nonnull
    public ProcessTools setCommand(@Nonnull List<String> cmd) {
        this.m_builder.command(cmd);
        return this;
    }

    @Nonnull
    public ProcessTools directory(@Nonnull File cmd) {
        this.m_builder.directory(cmd);
        return this;
    }

    @Nonnull
    public ProcessTools follow(@Nonnull IFollow cmd) {
        this.m_follow = cmd;
        return this;
    }

    @Nonnull
    public ProcessTools flush() {
        this.m_flush = true;
        return this;
    }

    @Nonnull
    public Map<String, String> env() {
        return this.m_builder.environment();
    }

    @Nonnull
    public ProcessTools envStrip(String ... names) {
        for (String name : names) {
            this.env().remove(name);
        }
        return this;
    }

    public int run() throws Exception {
        Writer stdout = this.m_stdout;
        Writer stderr = this.m_stderr;
        if (null == stdout) {
            throw new IllegalStateException("Stdout not redirected");
        }
        if (null == stderr) {
            this.m_builder.redirectErrorStream(true);
        }
        Process pr = this.m_builder.start();
        StreamReaderThread outr = new StreamReaderThread(stdout, "stdout", pr.getInputStream(), null, this.m_follow, this.m_flush);
        outr.start();
        Thread errr = null;
        if (stderr != null) {
            errr = new StreamReaderThread(stderr, "stderr", pr.getErrorStream(), null, this.m_follow, this.m_flush);
            errr.start();
        }
        int rc = pr.waitFor();
        outr.join();
        if (null != errr) {
            errr.join();
        }
        return rc;
    }

    public static int dumpStreams(Process pr, Appendable iosb) throws Exception {
        StreamReaderThread outr = new StreamReaderThread(iosb, "stdout", pr.getInputStream());
        StreamReaderThread errr = new StreamReaderThread(iosb, "stderr", pr.getErrorStream());
        outr.start();
        errr.start();
        int rc = pr.waitFor();
        outr.join();
        errr.join();
        return rc;
    }

    public static int runProcess(ProcessBuilder pb, Appendable sb) throws Exception {
        pb.redirectErrorStream(true);
        Process pr = pb.start();
        StreamReaderThread outr = new StreamReaderThread(sb, "stdout", pr.getInputStream());
        outr.start();
        int rc = pr.waitFor();
        outr.join();
        return rc;
    }

    public static int runProcess(ProcessBuilder pb, OutputStream stdout, Appendable stderrsb) throws Exception {
        Process pr = pb.start();
        StreamReaderThread errr = new StreamReaderThread(stderrsb, "stderr", pr.getErrorStream());
        StreamCopyThread outr = new StreamCopyThread(stdout, "stdout", pr.getInputStream());
        outr.start();
        errr.start();
        int rc = pr.waitFor();
        outr.join();
        errr.join();
        return rc;
    }

    public static int runProcess(ProcessBuilder pb, Appendable outsb, Appendable errsb) throws Exception {
        Process pr = pb.start();
        StreamReaderThread outr = new StreamReaderThread(outsb, "stdout", pr.getInputStream());
        StreamReaderThread errr = new StreamReaderThread(errsb, "stderr", pr.getErrorStream());
        outr.start();
        errr.start();
        int rc = pr.waitFor();
        outr.join();
        errr.join();
        return rc;
    }

    public static int runProcess(ProcessBuilder pb, Writer out) throws Exception {
        pb.redirectErrorStream(true);
        Process pr = pb.start();
        StreamReaderThread outr = new StreamReaderThread(out, "stdout", pr.getInputStream());
        outr.start();
        int rc = pr.waitFor();
        outr.join();
        return rc;
    }

    public static class StreamCopyThread
    extends Thread {
        private InputStream m_is;
        private OutputStream m_os;
        private final byte[] m_buf;

        public StreamCopyThread(OutputStream os, String name, InputStream is) {
            this.m_os = os;
            this.m_is = is;
            this.m_buf = new byte[1024];
            this.setName("StreamReader" + name);
        }

        @Override
        public void run() {
            try {
                int szrd;
                while (0 < (szrd = this.m_is.read(this.m_buf))) {
                    this.m_os.write(this.m_buf, 0, szrd);
                }
                this.m_os.flush();
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            finally {
                try {
                    if (this.m_is != null) {
                        this.m_is.close();
                    }
                }
                catch (Exception szrd) {}
            }
        }
    }

    public static class StreamReaderThread
    extends Thread {
        private Reader m_reader;
        private final Writer m_w;
        @Nonnull
        private final char[] m_buf;
        private boolean m_flush;
        private IFollow m_follow;

        public StreamReaderThread(Appendable sb, String name, InputStream is) {
            this(sb, name, is, System.getProperty("file.encoding"));
        }

        public StreamReaderThread(final Appendable sb, String name, InputStream is, String encoding) {
            this(new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    while (len-- > 0) {
                        sb.append(cbuf[off++]);
                    }
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void close() throws IOException {
                }
            }, name, is, encoding, null, false);
        }

        public StreamReaderThread(Writer sb, String name, InputStream is) {
            this(sb, name, is, System.getProperty("file.encoding"), null, false);
        }

        public StreamReaderThread(Writer w, String name, InputStream is, String encoding, IFollow follow, boolean flush) {
            this.m_w = w;
            this.m_buf = new char[8192];
            this.m_follow = follow;
            this.m_flush = flush;
            this.setName("StreamReader" + name);
            if (null == encoding) {
                encoding = System.getProperty("file.encoding");
            }
            try {
                this.m_reader = new InputStreamReader(is, encoding);
            }
            catch (UnsupportedEncodingException x) {
                throw new IllegalStateException("Unsupported encoding " + encoding);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int szrd;
                IFollow follow = this.m_follow;
                while (0 <= (szrd = this.m_reader.read(this.m_buf))) {
                    this.m_w.write(this.m_buf, 0, szrd);
                    if (this.m_flush && (szrd > 512 || StreamReaderThread.needsFlush(this.m_buf, szrd))) {
                        this.m_w.flush();
                    }
                    if (null == follow) continue;
                    try {
                        this.m_follow.newData(false, this.m_buf, szrd);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
                this.m_w.flush();
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            finally {
                try {
                    if (this.m_reader != null) {
                        this.m_reader.close();
                    }
                }
                catch (Exception szrd) {}
            }
        }

        private static boolean needsFlush(@Nonnull char[] buf, int szrd) {
            while (--szrd >= 0) {
                if (buf[szrd] != '\n') continue;
                return true;
            }
            return false;
        }
    }

    public static interface IFollow {
        public void newData(boolean var1, @Nonnull char[] var2, int var3);
    }
}

