/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.util.CancelledException;
import to.etc.util.IProgressListener;
import to.etc.util.WrappedException;

public class Progress {
    private Progress m_root;
    private Progress m_parent;
    private final List<Progress> m_subProgress = new ArrayList<Progress>();
    private double m_parentsWorkForSub;
    private double m_totalWork;
    private double m_currentWork;
    private double m_workReportedToParent;
    private boolean m_cancelled;
    private boolean m_parallel;
    private boolean m_cancelable = true;
    @Nullable
    private String m_name;
    @Nullable
    private String m_extra;
    @Nonnull
    private List<IProgressListener> m_listeners = Collections.emptyList();

    public Progress(@Nullable String name) {
        this.m_root = this;
        this.m_name = name;
    }

    private Progress(@Nonnull Progress parent, @Nullable String name) {
        this.m_parent = parent;
        this.m_root = parent.m_root;
        this.m_name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<Info> getParallels(int level) {
        ArrayList<Info> prl = new ArrayList<Info>();
        Progress progress = this.m_root;
        synchronized (progress) {
            if (this.m_parent != null) {
                throw new IllegalStateException("Only callable on root entity");
            }
            StringBuilder sb = new StringBuilder();
            Progress split = this.findSplitPoint(sb, this, level);
            prl.add(new Info(sb.toString(), this.getPercentage()));
            if (split != null) {
                sb.setLength(0);
                this.handleSplit(sb, prl, split);
            }
        }
        return prl;
    }

    private void handleSplit(@Nonnull StringBuilder sb, @Nonnull List<Info> prl, @Nonnull Progress split) {
        int len = sb.length();
        for (Progress sub : split.m_subProgress) {
            sb.setLength(len);
            Progress nsplit = this.findSplitPoint(sb, sub, 3);
            if (nsplit == null) {
                prl.add(new Info(sb.toString(), sub.getPercentage()));
                continue;
            }
            this.handleSplit(sb, prl, nsplit);
        }
        sb.setLength(len);
    }

    private Progress findSplitPoint(@Nonnull StringBuilder sb, @Nonnull Progress progress, int level) {
        while (progress != null) {
            String name = progress.m_name;
            if (name != null) {
                if (sb.length() > 0) {
                    sb.append('>');
                }
                sb.append(name);
                name = progress.m_extra;
                if (name != null) {
                    sb.append(' ').append(name);
                }
            }
            if (--level == 0) {
                return null;
            }
            if (this.m_subProgress.size() == 0) {
                return null;
            }
            if (this.m_subProgress.size() == 1) {
                progress = this.m_subProgress.get(0);
                continue;
            }
            return progress;
        }
        return null;
    }

    @Nonnull
    public Progress getRoot() {
        return this.m_root;
    }

    @Nullable
    public Progress getParent() {
        return this.m_parent;
    }

    public boolean isCancelable() {
        return this.getRoot().m_cancelable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getName() {
        Progress progress = this.m_root;
        synchronized (progress) {
            if (this.m_extra == null) {
                return this.m_name;
            }
            return this.m_name + this.m_extra;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotalWork() {
        Progress progress = this.m_root;
        synchronized (progress) {
            return this.m_totalWork;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCompletedWork() {
        Progress progress = this.m_root;
        synchronized (progress) {
            return this.m_currentWork;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPercentage() {
        Progress progress = this.m_root;
        synchronized (progress) {
            if (this.m_totalWork <= 0.0) {
                return 0;
            }
            double pct = this.m_currentWork * 100.0 / this.m_totalWork;
            return (int)Math.round(pct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFraction() {
        Progress progress = this.m_root;
        synchronized (progress) {
            if (this.m_totalWork <= 0.0) {
                return 0.0;
            }
            return this.m_currentWork / this.m_totalWork;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String getActionPath(int levels) {
        StringBuilder sb = new StringBuilder(80);
        Progress progress = this.m_root;
        synchronized (progress) {
            Progress p = this;
            while (p != null && levels > 0) {
                if (p.m_name != null) {
                    if (sb.length() != 0) {
                        sb.append(">");
                    }
                    sb.append(p.m_name);
                    if (p.m_extra != null) {
                        sb.append(p.m_extra);
                    }
                    --levels;
                }
                if (p.m_subProgress.size() != 1) {
                    p = null;
                    continue;
                }
                p = p.m_subProgress.get(0);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Progress progress = this.m_root;
        synchronized (progress) {
            if (!this.m_cancelled && this.m_root.m_cancelable) {
                this.m_cancelled = true;
                if (this.m_parent != null) {
                    this.m_parent.cancel();
                }
                this.updateTree();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancelable(boolean yes) {
        Progress progress = this.m_root;
        synchronized (progress) {
            this.m_root.m_cancelable = yes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        Progress progress = this.m_root;
        synchronized (progress) {
            return this.m_root.m_cancelled;
        }
    }

    public void setTotalWork(double work) {
        this.setTotalWork(work, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTotalWork(double work, @Nullable String extra) {
        Progress progress = this.m_root;
        synchronized (progress) {
            this.checkCancelled();
            if (this.m_totalWork != 0.0) {
                this.m_currentWork = 0.0;
            }
            this.m_totalWork = work;
            this.m_extra = extra;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCancelled() {
        Progress progress = this.m_root;
        synchronized (progress) {
            if (this.m_root.m_cancelled && this.m_root.m_cancelable) {
                throw new CancelledException();
            }
        }
    }

    public void setCompleted(double now) {
        this.checkCancelled();
        this.setCompleted(now, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSetCompleted(double now) {
        Progress progress = this.m_root;
        synchronized (progress) {
            double parentwork;
            double toreport;
            this.checkCancelled();
            if (now <= this.m_currentWork) {
                return;
            }
            if (now >= this.m_totalWork) {
                now = this.m_totalWork;
            }
            this.m_currentWork = now;
            Progress dad = this.m_parent;
            if (null != dad && (toreport = (parentwork = this.getFraction() * this.m_parentsWorkForSub) - this.m_workReportedToParent) > 0.0) {
                double dadwork = dad.m_currentWork + toreport;
                dad.internalSetCompleted(dadwork);
                this.m_workReportedToParent = parentwork;
            }
            this.updated();
            this.updateTree();
        }
    }

    public synchronized void setCompleted(double now, @Nullable String extra) {
        this.m_extra = extra;
        this.internalSetCompleted(now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        Progress progress = this.m_root;
        synchronized (progress) {
            double toreport;
            this.clearSubProgress();
            if (this.m_totalWork == 0.0) {
                this.m_totalWork = 100.0;
                this.m_currentWork = 100.0;
            } else if (this.m_currentWork < this.m_totalWork) {
                this.m_currentWork = this.m_totalWork;
            }
            Progress dad = this.m_parent;
            if (null != dad && dad.m_subProgress.remove(this) && (toreport = this.m_parentsWorkForSub - this.m_workReportedToParent) > 0.0) {
                dad.internalSetCompleted(this.m_parent.m_currentWork + toreport);
            }
            this.updateTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(double inc) {
        this.checkCancelled();
        if (inc <= 0.0) {
            return;
        }
        Progress progress = this.m_root;
        synchronized (progress) {
            this.setCompleted(this.m_currentWork + inc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSubProgress() {
        Progress progress = this.m_root;
        synchronized (progress) {
            this.m_parallel = false;
            this.checkCancelled();
            if (this.m_subProgress.size() == 0) {
                return;
            }
            double totalWork = 0.0;
            while (this.m_subProgress.size() > 0) {
                this.m_subProgress.get(0).complete();
            }
            this.updateTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Progress createSubProgress(@Nullable String name, double work) {
        Progress progress = this.m_root;
        synchronized (progress) {
            this.clearSubProgress();
            this.checkCancelled();
            if (this.m_currentWork + work > this.m_totalWork && (work = this.m_totalWork - this.m_currentWork) < 0.0) {
                work = 0.0;
            }
            Progress sub = new Progress(this, name);
            sub.m_parentsWorkForSub = work;
            this.m_subProgress.add(sub);
            return sub;
        }
    }

    @Nonnull
    public Progress createParallelProgress(@Nullable String name, double work) {
        this.checkCancelled();
        if (!this.m_parallel) {
            this.clearSubProgress();
            this.m_parallel = true;
        }
        if (this.m_currentWork + work > this.m_totalWork && (work = this.m_totalWork - this.m_currentWork) < 0.0) {
            work = 0.0;
        }
        Progress sub = new Progress(this, name);
        sub.m_parentsWorkForSub = work;
        this.m_subProgress.add(sub);
        return sub;
    }

    private void updateTree() {
        for (IProgressListener l : this.getListeners()) {
            try {
                l.progressed(this);
            }
            catch (Exception x) {
                throw WrappedException.wrap(x);
            }
        }
    }

    protected void updated() {
    }

    public synchronized void addListener(@Nonnull IProgressListener l) {
        this.m_listeners = new ArrayList<IProgressListener>(this.m_listeners);
        this.m_listeners.add(l);
    }

    public synchronized void removeListener(@Nonnull IProgressListener l) {
        this.m_listeners = new ArrayList<IProgressListener>(this.m_listeners);
        this.m_listeners.remove(l);
    }

    @Nonnull
    private synchronized List<IProgressListener> getListeners() {
        return this.m_listeners;
    }

    public static class Info {
        private final String m_path;
        private final int m_percentage;

        public Info(String path, int percentage) {
            this.m_path = path;
            this.m_percentage = percentage;
        }

        public String getPath() {
            return this.m_path;
        }

        public int getPercentage() {
            return this.m_percentage;
        }
    }
}

