/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import to.etc.util.ClassUtil;
import to.etc.util.IPropertyAccessor;
import to.etc.util.WrappedException;

@Immutable
public final class PropertyInfo
implements IPropertyAccessor {
    private final String m_name;
    private final Method m_getter;
    private final Method m_setter;

    public PropertyInfo(String name, Method getter, Method setter) {
        if (getter == null || name == null) {
            throw new IllegalStateException("Name or getter null not allowed");
        }
        this.m_name = name;
        this.m_getter = getter;
        this.m_setter = setter;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.m_name;
    }

    @Nonnull
    public Method getGetter() {
        return this.m_getter;
    }

    @Nullable
    public Method getSetter() {
        return this.m_setter;
    }

    @Override
    @Nonnull
    public Class<?> getActualType() {
        return this.m_getter.getReturnType();
    }

    @Override
    public Type getActualGenericType() {
        return this.m_getter.getGenericReturnType();
    }

    public boolean isCollectionOrArrayType() {
        return this.getActualType().isArray() || Collection.class.isAssignableFrom(this.getActualType());
    }

    public boolean isCollectionType() {
        return Collection.class.isAssignableFrom(this.getActualType());
    }

    public boolean isArrayType() {
        return this.getActualType().isArray();
    }

    public Class<?> getCollectionValueType() {
        if (this.getActualType().isArray()) {
            return this.getActualType().getComponentType();
        }
        if (Collection.class.isAssignableFrom(this.getActualType())) {
            Type t = this.getActualGenericType();
            if (t == null) {
                return null;
            }
            return ClassUtil.findCollectionType(t);
        }
        return null;
    }

    @Override
    @Nullable
    public Object getValue(@Nullable Object instance) throws Exception {
        if (null == this.m_getter) {
            throw new IllegalAccessException("The property " + this + " does not have a getter method - it is writeonly");
        }
        try {
            return this.m_getter.invoke(instance, new Object[0]);
        }
        catch (InvocationTargetException xte) {
            throw WrappedException.unwrap(xte);
        }
    }

    @Override
    public void setValue(@Nullable Object instance, @Nullable Object value) throws Exception {
        if (null == this.m_setter) {
            throw new IllegalAccessException("The property " + this + " does not have a getter method - it is writeonly");
        }
        try {
            this.m_setter.invoke(instance, value);
        }
        catch (InvocationTargetException xte) {
            throw WrappedException.unwrap(xte);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        Class<?> clz = this.m_getter != null ? this.m_getter.getDeclaringClass() : this.m_setter.getDeclaringClass();
        sb.append("property ").append(this.m_name).append(" in class ").append(clz.getName());
        return sb.toString();
    }
}

