/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import to.etc.util.FileTool;
import to.etc.util.StandardLogfile;
import to.etc.util.StringTool;

public class RotatingLogfile
extends StandardLogfile {
    private long m_check_ts;
    private int m_log_days = 7;
    private GregorianCalendar m_currfile_cal;

    public RotatingLogfile() {
    }

    public RotatingLogfile(String name) {
        super(name);
    }

    @Override
    protected synchronized Date checkCycle() {
        Date d = new Date();
        if (d.getTime() < this.m_check_ts) {
            return this.getOutWriter() != null ? d : null;
        }
        this.m_check_ts = d.getTime() + 60000L;
        GregorianCalendar cal = new GregorianCalendar();
        File path = null;
        File f = null;
        if (this.getOutWriter() != null) {
            if (cal.get(6) == this.m_currfile_cal.get(6)) {
                return this.getOutWriter() != null ? d : null;
            }
            path = this.makeCalendarFile(cal);
            GregorianCalendar cold = (GregorianCalendar)cal.clone();
            cold.add(5, -this.m_log_days);
            f = this.makeCalendarFile(cold);
            f.delete();
            this.getOutWriter().println("\n\n********************* Log rotation ******************************");
        } else {
            path = this.makeCalendarFile(cal);
        }
        this.setFile(path);
        this.m_currfile_cal = cal;
        try {
            if (f == null) {
                this.getOutWriter().println("This logfile is NOT a start of a rotated log file.");
            } else {
                this.getOutWriter().println("This is the continuation of the rotated logfile " + f);
            }
            this.getOutWriter().println("----------");
            return d;
        }
        catch (Exception x) {
            x.printStackTrace();
            this.setOutWriter(null);
            return null;
        }
    }

    private File makeCalendarFile(Calendar c) {
        String ext;
        String base;
        int pos = FileTool.findFilenameExtension(this.getName());
        if (pos == -1) {
            base = this.getName();
            ext = ".log";
        } else {
            base = this.getName().substring(0, pos);
            ext = this.getName().substring(pos);
        }
        int dd = c.get(5);
        int mm = c.get(2) + 1;
        int yy = c.get(1);
        StringBuffer sb = new StringBuffer(128);
        sb.append(base);
        sb.append(StringTool.intToStr(yy, 10, 4));
        sb.append('-');
        sb.append(StringTool.intToStr(mm, 10, 2));
        sb.append('-');
        sb.append(StringTool.intToStr(dd, 10, 2));
        sb.append(ext);
        return new File(sb.toString());
    }

    @Override
    public void setFile(File f) {
        super.setFile(f);
        this.m_currfile_cal = new GregorianCalendar();
    }
}

