/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.annotation.Nonnull;
import to.etc.util.StringTool;
import to.etc.util.WrappedException;

public class SecurityUtils {
    public static String encodeToHex(PrivateKey privk) {
        byte[] enc = privk.getEncoded();
        return StringTool.toHex(enc);
    }

    public static String encodeToHex(PublicKey pubk) {
        byte[] enc = pubk.getEncoded();
        return StringTool.toHex(enc);
    }

    public static String encodeToBase64(PrivateKey privk) {
        byte[] enc = privk.getEncoded();
        return StringTool.encodeBase64ToString(enc);
    }

    public static String encodeToBase64(PublicKey pubk) {
        byte[] enc = pubk.getEncoded();
        return StringTool.encodeBase64ToString(enc);
    }

    public static PublicKey decodePublicKeyFromHex(String enc, String algo) throws Exception {
        byte[] ba = StringTool.fromHex(enc);
        if (!StringTool.toHex(ba).equalsIgnoreCase(enc)) {
            throw new Exception("ASSERT: Problem with hex/binary translation");
        }
        X509EncodedKeySpec pks = new X509EncodedKeySpec(ba);
        KeyFactory kf = KeyFactory.getInstance(algo);
        return kf.generatePublic(pks);
    }

    public static PrivateKey decodePrivateKeyFromHex(String enc, String algo) throws Exception {
        byte[] ba = StringTool.fromHex(enc);
        if (!StringTool.toHex(ba).equalsIgnoreCase(enc)) {
            throw new Exception("ASSERT: Problem with hex/binary translation");
        }
        PKCS8EncodedKeySpec pks = new PKCS8EncodedKeySpec(ba);
        KeyFactory kf = KeyFactory.getInstance(algo);
        return kf.generatePrivate(pks);
    }

    public static PublicKey decodePublicKeyFromHex(String enc) throws Exception {
        return SecurityUtils.decodePublicKeyFromHex(enc, "DSA");
    }

    public static PrivateKey decodePrivateKeyFromHex(String enc) throws Exception {
        return SecurityUtils.decodePrivateKeyFromHex(enc, "DSA");
    }

    public static PublicKey decodePublicKeyFromBase64(String enc) throws Exception {
        return SecurityUtils.decodePublicKeyFromBase64(enc, "DSA");
    }

    public static PrivateKey decodePrivateKeyFromBase64(String enc) throws Exception {
        return SecurityUtils.decodePrivateKeyFromBase64(enc, "DSA");
    }

    public static PublicKey decodePublicKeyFromBase64(String enc, String algo) throws Exception {
        byte[] ba = StringTool.decodeBase64(enc);
        X509EncodedKeySpec pks = new X509EncodedKeySpec(ba);
        KeyFactory kf = KeyFactory.getInstance(algo);
        return kf.generatePublic(pks);
    }

    public static PrivateKey decodePrivateKeyFromBase64(String enc, String algo) throws Exception {
        byte[] ba = StringTool.decodeBase64(enc);
        PKCS8EncodedKeySpec pks = new PKCS8EncodedKeySpec(ba);
        KeyFactory kf = KeyFactory.getInstance(algo);
        return kf.generatePrivate(pks);
    }

    public static byte[] md5Hash(byte[] data) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException x) {
            throw new RuntimeException("MISSING MANDATORY SECURITY DIGEST PROVIDER MD5: " + x.getMessage());
        }
        md.update(data);
        return md.digest();
    }

    @Nonnull
    public static String getMD5Hash(@Nonnull String in, @Nonnull String encoding) {
        try {
            byte[] hash = SecurityUtils.md5Hash(in.getBytes(encoding));
            return StringTool.toHex(hash);
        }
        catch (Exception x) {
            throw WrappedException.wrap(x);
        }
    }
}

