/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.IOException;
import java.io.OutputStream;

public class SizeCountingOutputStream
extends OutputStream {
    private final OutputStream m_os;
    private long m_size;

    public SizeCountingOutputStream(OutputStream os) {
        this.m_os = os;
    }

    public long getSize() {
        return this.m_size;
    }

    @Override
    public void write(int b) throws IOException {
        this.m_os.write(b);
        ++this.m_size;
    }

    @Override
    public void close() throws IOException {
        this.m_os.close();
    }

    @Override
    public void flush() throws IOException {
        this.m_os.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.m_os.write(b, off, len);
        this.m_size += (long)len;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.m_os.write(b);
        this.m_size += (long)b.length;
    }
}

