/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

public class Soundex {
    public static final transient int NO_MAX = -1;
    private boolean m_dropLastS = false;
    private int m_lengthInt = 4;
    private boolean m_pad = true;
    protected int[] m_soundexInts = new int[]{-1, 1, 2, 3, -1, 1, 2, -1, -1, 2, 2, 4, 5, 5, -1, 1, 2, 6, 2, 3, -1, 1, -1, 2, -1, 2};
    private static final String LowerS = "s";

    public int getCode(char c) {
        int arrayidx = -1;
        if ('a' <= c || c <= 'z') {
            arrayidx = c - 97;
        }
        if (arrayidx >= 0 && arrayidx < this.m_soundexInts.length) {
            return this.m_soundexInts[arrayidx];
        }
        return -1;
    }

    public boolean getDropLastS() {
        return this.m_dropLastS;
    }

    public int getLength() {
        return this.m_lengthInt + 1;
    }

    public boolean getPad() {
        return this.m_pad;
    }

    public String soundex(String string) {
        string = string.toLowerCase();
        if (this.m_dropLastS && string.length() > 1 && string.endsWith(LowerS)) {
            string = string.substring(0, string.length() - 1);
        }
        string = this.reduce(string);
        int lengthInt = string.length();
        int codesInt = 0;
        int maxInt = this.m_lengthInt - 1;
        if (this.m_lengthInt < 0) {
            maxInt = lengthInt;
        }
        int sndexInt = 0;
        StringBuilder buffer = new StringBuilder(maxInt);
        buffer.append(string.charAt(0));
        for (int i = 1; i < lengthInt && codesInt < maxInt; ++i) {
            char currentChar = string.charAt(i);
            sndexInt = this.getCode(currentChar);
            if (sndexInt <= 0) continue;
            buffer.append(sndexInt);
            ++codesInt;
        }
        if (this.m_pad && this.m_lengthInt > 0) {
            while (codesInt < maxInt) {
                buffer.append('0');
                ++codesInt;
            }
        }
        return buffer.toString();
    }

    public static void main(String[] strings) {
        if (strings == null || strings.length == 0) {
            throw new IllegalArgumentException("Specify some words and this will display a soundex code for each.");
        }
        Soundex s = new Soundex();
        for (int i = 0; i < strings.length; ++i) {
            System.out.println(s.soundex(strings[i]));
        }
    }

    public void setCode(char c, int i) {
        int arrayidx = -1;
        if ('a' <= c || c <= 'z') {
            arrayidx = c - 97;
        }
        if (0 <= arrayidx && arrayidx < this.m_soundexInts.length) {
            this.m_soundexInts[arrayidx] = i;
        }
    }

    public void setDropLastS(boolean bool) {
        this.m_dropLastS = bool;
    }

    public void setLength(int lengthInt) {
        this.m_lengthInt = --lengthInt;
    }

    public void setPad(boolean bool) {
        this.m_pad = bool;
    }

    protected String reduce(String string) {
        int lengthInt = string.length();
        StringBuilder buffer = new StringBuilder(lengthInt);
        char c = string.charAt(0);
        int currentCode = this.getCode(c);
        buffer.append(c);
        int lastCode = currentCode;
        for (int i = 1; i < lengthInt; ++i) {
            c = string.charAt(i);
            currentCode = this.getCode(c);
            if (currentCode == lastCode || currentCode < 0) continue;
            buffer.append(c);
            lastCode = currentCode;
        }
        return buffer.toString();
    }
}

