/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import to.etc.util.ILogSink;
import to.etc.util.StringTool;

public class StandardLogfile
implements ILogSink {
    private DateFormat m_df;
    private File m_path_f;
    private String m_logname;
    private PrintWriter m_outWriter;
    private Calendar m_cal = new GregorianCalendar();

    public StandardLogfile() {
        this.m_df = DateFormat.getDateTimeInstance(3, 3);
    }

    public StandardLogfile(String name) {
        this();
        this.setName(name);
    }

    public void setName(String name) {
        this.m_logname = name;
    }

    public String getName() {
        return this.m_logname;
    }

    public File getFile() {
        return this.m_path_f;
    }

    public void setFile(File f) {
        block6: {
            Date dt = new Date();
            if (this.getOutWriter() != null) {
                this.getOutWriter().println("This log was closed on " + this.m_df.format(dt));
                this.getOutWriter().println("The new log file is " + f);
                this.getOutWriter().println("Bye!");
                this.getOutWriter().close();
                this.setOutWriter(null);
            }
            try {
                this.setOutWriter(new PrintWriter(new FileWriter(f, true)));
                this.getOutWriter().println("************************ Log start ********************************");
                this.getOutWriter().println("This log file was started on " + this.m_df.format(dt));
                if (this.m_path_f != null) {
                    this.getOutWriter().println("It was continued from the file " + this.m_path_f);
                }
                this.m_path_f = f;
            }
            catch (IOException x) {
                x.printStackTrace();
                if (this.getOutWriter() == null) break block6;
                try {
                    this.getOutWriter().close();
                    this.setOutWriter(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected Date checkCycle() {
        if (this.m_path_f == null) {
            this.setFile(new File(this.m_logname));
        }
        return this.m_outWriter == null ? null : new Date();
    }

    protected void setOutWriter(PrintWriter outWriter) {
        this.m_outWriter = outWriter;
    }

    protected PrintWriter getOutWriter() {
        return this.m_outWriter;
    }

    private synchronized String dateStr(Date dt) {
        this.m_cal.setTime(dt);
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_cal.get(11));
        sb.append(':');
        StringTool.strAddIntFixed(sb, this.m_cal.get(12), 10, 2);
        sb.append(':');
        StringTool.strAddIntFixed(sb, this.m_cal.get(13), 10, 2);
        return sb.toString();
    }

    @Override
    public synchronized void log(String msg) {
        Date d = this.checkCycle();
        if (d == null) {
            return;
        }
        this.getOutWriter().print(this.dateStr(d));
        this.getOutWriter().print(" ");
        this.getOutWriter().println(msg);
        this.getOutWriter().flush();
    }

    @Override
    public synchronized void exception(Throwable t, String msg) {
        Date d = this.checkCycle();
        if (d == null) {
            return;
        }
        this.getOutWriter().print(this.dateStr(d));
        this.getOutWriter().print(" Exception ");
        this.getOutWriter().println(t.toString());
        this.getOutWriter().print("Message: ");
        this.getOutWriter().println(msg);
        this.getOutWriter().println("----- Stack dump ------");
        t.printStackTrace(this.getOutWriter());
        this.getOutWriter().println("----- End of stack ----");
        this.getOutWriter().flush();
    }

    public synchronized void rawlog(String s) {
        this.getOutWriter().print(s);
    }

    public void flush() {
        if (this.m_outWriter != null) {
            this.m_outWriter.flush();
        }
    }
}

