/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import to.etc.util.ByteArrayUtil;
import to.etc.util.HtmlEntityTables;
import to.etc.util.WrappedException;

public class StringTool {
    @Deprecated
    public static final int MAX_SIZE_IN_BYTES_FOR_ORACLE_VARCHAR2 = 4000;
    public static final int MAX_EMAIL_LENGTH = 255;
    private static final String m_charString = "bcdfghjklmnpqrstvwxyz";
    private static final char[] m_characters = "bcdfghjklmnpqrstvwxyz".toCharArray();
    private static final long DAYS = 86400L;
    private static final long HOURS = 3600L;
    private static final byte[] BASE64MAP = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] BASE64DECMAP = new byte[128];
    private static final long MICROS = 1000L;
    private static final long MILLIS = 1000000L;
    private static final long SECONDS = 1000000000L;
    private static final long MINUTES = 60000000000L;
    private static final long NSHOURS = 3600000000000L;
    private static final long[] TIMESET;
    private static final String[] SUFFIXES;
    private static int m_jre_version;
    private static boolean m_jre_checked;
    private static int m_guidSeed;
    private static final char[] GUIDBASE64MAP;
    private static final Pattern NORMALIZE_PATTERN;
    private static final Pattern URL_PATTERN;

    public static boolean isValidJavaIdentifier(@Nonnull String s) {
        int len = s.length();
        if (len == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public static String getRandomStringWithPrefix(int length, @Nonnull String prefix) {
        if (length <= prefix.length()) {
            throw new IllegalArgumentException("Prefix is too long");
        }
        StringBuilder randomString = new StringBuilder(length);
        randomString.append(prefix);
        Random random = new Random();
        for (int i = prefix.length(); i < length; ++i) {
            int position = random.nextInt(m_charString.length());
            randomString.append(m_characters[position]);
        }
        return randomString.toString();
    }

    public static boolean isValidDomainName(@Nonnull String s) {
        int len = s.length();
        if (len == 0) {
            return false;
        }
        int lastdot = -1;
        for (int ix = 0; ix < len; ++ix) {
            char c = s.charAt(ix);
            if (c == '.') {
                if (ix - 1 == lastdot) {
                    return false;
                }
                lastdot = ix;
                continue;
            }
            if (StringTool.isDomainChar(c)) continue;
            return false;
        }
        if (lastdot == -1 && !"LOCALHOST".equalsIgnoreCase(s)) {
            return false;
        }
        return lastdot + 1 != len;
    }

    public static boolean isNumber(@Nonnull String s) {
        int dots = 0;
        int i = s.length();
        while (--i >= 0) {
            char c = s.charAt(i);
            if (c == '.') {
                ++dots;
                continue;
            }
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return dots < 2;
    }

    public static boolean isDomainChar(char c) {
        return c == '-' || c == '.' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    public static boolean isWhiteSpaceOrNbsp(char c) {
        return c == '\u00a0' || Character.isWhitespace(c);
    }

    public static boolean isAllSpaces(@Nonnull String s) {
        int i = s.length();
        while (--i >= 0) {
            if (StringTool.isWhiteSpaceOrNbsp(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidEmail(@Nonnull String em) {
        if (em.length() > 255) {
            return false;
        }
        int ix = em.indexOf(64);
        if (ix <= 0) {
            return false;
        }
        String pre = em.substring(0, ix);
        if (pre.startsWith(".") || pre.endsWith(".") || pre.contains(" ")) {
            return false;
        }
        String dom = em.substring(ix + 1);
        return StringTool.isValidDomainName(dom);
    }

    public static boolean isValidDbFieldName(@Nonnull String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        if (s.length() > 30) {
            return false;
        }
        char c = (s = s.toLowerCase()).charAt(0);
        if (c < 'a' || c > 'z') {
            return false;
        }
        int i = s.length();
        while (--i > 0) {
            c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidDottedName(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).length() == 0) {
            return false;
        }
        int i = s.length();
        while (--i >= 0) {
            char ch = s.charAt(i);
            if (StringTool.isValidDottedChar(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidDottedChar(char c) {
        if (Character.isDigit(c)) {
            return true;
        }
        if (Character.isLetter(c)) {
            return true;
        }
        return c == '.' || c == '_';
    }

    public static boolean isEqual(@Nullable Object a, @Nullable Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static final boolean isEqualIgnoreCase(@Nullable String a, @Nullable String b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equalsIgnoreCase(b);
    }

    public static void stringize(@Nonnull StringBuffer sb, @Nonnull String s) {
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\\t");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '\u007f') {
                        sb.append("\\u" + Integer.toHexString(c));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
    }

    public static StringBuffer stringize(@Nonnull String s) {
        StringBuffer sb = new StringBuffer(s.length() + 20);
        sb.append("\"");
        StringTool.stringize(sb, s);
        sb.append("\"");
        return sb;
    }

    public static StringBuffer stringizeNQ(@Nonnull String s) {
        StringBuffer sb = new StringBuffer(s.length() + 20);
        StringTool.stringize(sb, s);
        return sb;
    }

    public static String strBackslashToSlash(@Nonnull String s) {
        StringBuffer sb = new StringBuffer(s.length());
        int six = 0;
        while (true) {
            int ix;
            if ((ix = s.indexOf(92, six)) == -1) {
                sb.append(s.substring(six));
                return sb.toString();
            }
            sb.append(s.substring(six, ix));
            sb.append('/');
            six = ix + 1;
        }
    }

    public static String strSize(long sz) {
        long kb = 1024L;
        long mb = 0x100000L;
        long gb = 0x40000000L;
        long tb = 0x10000000000L;
        long div = 1L;
        String sf = "";
        if (sz >= 0x10000000000L) {
            div = 0x10000000000L;
            sf = "TB";
        } else if (sz >= 0x40000000L) {
            div = 0x40000000L;
            sf = "GB";
        } else if (sz >= 0x100000L) {
            div = 0x100000L;
            sf = "MB";
        } else if (sz >= 1024L) {
            div = 1024L;
            sf = "KB";
        }
        StringBuffer sb = new StringBuffer(15);
        if (div == 1L) {
            return sz + " bytes";
        }
        long v = sz / div;
        long r = sz % div / (div / 10L);
        sb.append(Long.toString(v));
        if (r != 0L) {
            sb.append(".");
            sb.append(Long.toString(r));
        }
        sb.append(" ");
        sb.append(sf);
        return sb.toString();
    }

    public static void parseString(@Nonnull StringBuilder sb, @Nonnull String s) {
        int i = 0;
        block10: while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) != '\\') {
                sb.append(c);
                continue;
            }
            if (i >= s.length()) {
                sb.append(c);
                return;
            }
            c = s.charAt(i++);
            switch (c) {
                case '\"': {
                    sb.append('\"');
                    continue block10;
                }
                case '\'': {
                    sb.append('\'');
                    continue block10;
                }
                case 'b': {
                    sb.append('\b');
                    continue block10;
                }
                case 'f': {
                    sb.append('\f');
                    continue block10;
                }
                case 'n': {
                    sb.append('\n');
                    continue block10;
                }
                case 'r': {
                    sb.append('\r');
                    continue block10;
                }
                case 't': {
                    sb.append('\t');
                    continue block10;
                }
                case 'u': {
                    sb.append("\\u");
                    continue block10;
                }
            }
            sb.append("\\");
            sb.append(c);
        }
    }

    public static String truncLength(@Nullable String s, int maxlen) {
        if (s == null || s.length() < maxlen) {
            return s;
        }
        return s.substring(0, maxlen);
    }

    public static String strToFixedLength(String s, int l) {
        int dl;
        if (s == null) {
            s = "null";
        }
        String t = "                                          ";
        if (s.length() == l) {
            return s;
        }
        if (s.length() > l) {
            return s.substring(0, l);
        }
        for (dl = l - s.length(); dl > t.length(); dl -= t.length()) {
            s = s + t;
        }
        s = s + t.substring(0, dl);
        return s;
    }

    public static String strToFixedLength(@Nonnull String s, char c, int l) {
        if (s.length() == l) {
            return s;
        }
        if (s.length() > l) {
            return s.substring(0, l);
        }
        int dl = l - s.length();
        StringBuffer sb = new StringBuffer(l);
        sb.append(s);
        while (dl-- > 0) {
            sb.append(c);
        }
        return sb.toString();
    }

    @Nonnull
    public static String toXY(int x, int y) {
        return "(" + x + "," + y + ")";
    }

    public static int getLevenshteinDistance(@Nonnull String s, @Nonnull String t, boolean ignorecase) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (ignorecase) {
            s = s.trim().toLowerCase();
            t = t.trim().toLowerCase();
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (m == n && s.equals(t)) {
            return 0;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static boolean strStartsWithIgnoreCase(@Nonnull String st, @Nonnull String with) {
        if (st.length() < with.length()) {
            return false;
        }
        String p = st.substring(0, with.length());
        return with.equalsIgnoreCase(p);
    }

    public static boolean strEndsWithIgnoreCase(@Nonnull String st, @Nonnull String with) {
        if (st.length() < with.length()) {
            return false;
        }
        int l = st.length();
        String p = st.substring(l - with.length(), l);
        return with.equalsIgnoreCase(p);
    }

    public static int strIndexOfIgnoreCase(@Nonnull String txt, @Nonnull String match) {
        int sl;
        int lm = match.length();
        if (lm > (sl = txt.length()) || lm == 0) {
            return -1;
        }
        char mc = Character.toLowerCase(match.charAt(0));
        int et = sl - lm;
        block0: for (int i = 0; i <= et; ++i) {
            char c = txt.charAt(i);
            if (c != mc && Character.toLowerCase(c) != mc) continue;
            int j = 1;
            int k = i + 1;
            while (j < lm) {
                char c2;
                char c1 = txt.charAt(k);
                if (c1 != (c2 = match.charAt(j)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) continue block0;
                ++k;
                ++j;
            }
            return i;
        }
        return -1;
    }

    @Nonnull
    public static String intToStr(int val, int radix, int npos) {
        String v = "000000000000" + Integer.toString(val, radix);
        return v.substring(v.length() - npos, v.length());
    }

    public static void strAddIntFixed(@Nonnull Appendable sb, int val, int radix, int len) {
        try {
            int l;
            String iv = Integer.toString(val, radix);
            if (l > len) {
                for (int i = l - len; i < l; ++i) {
                    sb.append(iv.charAt(i));
                }
                return;
            }
            for (l = iv.length(); l < len; ++l) {
                sb.append('0');
            }
            sb.append(iv);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    @Nonnull
    public static String strCommad(long val) {
        String v = Long.toString(val);
        StringBuffer sb = new StringBuffer(30);
        int pos = v.length() % 3 + 1;
        if (pos == 0) {
            pos = 3;
        }
        for (int i = 0; i < v.length(); ++i) {
            if (--pos == 0) {
                if (i > 0) {
                    sb.append(',');
                }
                pos = 3;
            }
            sb.append(v.charAt(i));
        }
        return sb.toString();
    }

    @Nonnull
    public static String strDuration(long dlt) {
        StringBuffer sb = new StringBuffer();
        if (dlt >= 86400L) {
            sb.append(Long.toString(dlt / 86400L));
            sb.append("D ");
            dlt %= 86400L;
        }
        if (dlt >= 3600L) {
            sb.append(Long.toString(dlt / 3600L));
            sb.append("u ");
            dlt %= 3600L;
        }
        if (dlt >= 60L) {
            sb.append(Long.toString(dlt / 60L));
            sb.append("min ");
            dlt %= 60L;
        }
        sb.append(Long.toString(dlt));
        sb.append("sec");
        return sb.toString();
    }

    @Nonnull
    public static String strDurationMillis(long dlt) {
        long v;
        StringBuffer sb = new StringBuffer();
        int millis = (int)(dlt % 1000L);
        boolean sp = false;
        if ((dlt /= 1000L) >= 86400L) {
            sb.append(dlt / 86400L);
            sb.append("D");
            dlt %= 86400L;
            sp = true;
        }
        if (dlt >= 3600L) {
            v = dlt / 3600L;
            if (v != 0L) {
                if (sp) {
                    sb.append(' ');
                }
                sb.append(v);
                sb.append("u");
                sp = true;
            }
            dlt %= 3600L;
        }
        if (dlt >= 60L) {
            v = dlt / 60L;
            if (v != 0L) {
                if (sp) {
                    sb.append(' ');
                }
                sb.append(v);
                sb.append("m");
                sp = true;
            }
            dlt %= 60L;
        }
        if (dlt != 0L) {
            if (sp) {
                sb.append(' ');
            }
            sb.append(dlt);
            sb.append("s");
            sp = true;
        }
        if (millis != 0) {
            if (sp) {
                sb.append(' ');
            }
            sb.append(millis);
            sb.append("ms");
        }
        return sb.toString();
    }

    public static String strTrunc(@Nullable String s, int len) {
        if (s == null) {
            return null;
        }
        if (s.length() <= len) {
            return s;
        }
        return s.substring(0, len);
    }

    public static void arrayToHexStr(@Nonnull Appendable sb, @Nonnull byte[] ar, int bi, int nc, boolean fillout) throws IOException {
        int ei = nc + bi;
        for (int i = bi; i < ei; ++i) {
            if (i >= ar.length) {
                if (!fillout) {
                    return;
                }
                sb.append("   ");
                continue;
            }
            sb.append(StringTool.intToStr(ar[i] & 0xFF, 16, 2));
            sb.append(' ');
        }
    }

    public static void arrayToAsciiStr(@Nonnull Appendable sb, @Nonnull byte[] ar, int bi, int nc) throws IOException {
        int ei = nc + bi;
        for (int i = bi; i < ei && i < ar.length; ++i) {
            byte c = ar[i];
            if (c >= 32 && c < 255) {
                sb.append((char)c);
                continue;
            }
            sb.append('.');
        }
    }

    public static void arrayToDumpLine(@Nonnull Appendable sb, @Nonnull byte[] ar, int bi, int nc) throws IOException {
        sb.append(StringTool.intToStr(bi, 16, 4));
        sb.append(": ");
        StringTool.arrayToHexStr(sb, ar, bi, nc, true);
        sb.append("  ");
        StringTool.arrayToAsciiStr(sb, ar, bi, nc);
    }

    public static void dumpData(@Nonnull Appendable sb, @Nonnull byte[] ar, int off, int len) throws IOException {
        int ix = off;
        int left = len;
        while (left > 0) {
            StringTool.arrayToDumpLine(sb, ar, ix, left > 16 ? 16 : left);
            sb.append("\n");
            left -= 16;
            ix += 16;
        }
    }

    public static void printHex(@Nonnull PrintWriter pw, @Nonnull byte[] arr) {
        StringTool.printHex(pw, arr, 0, arr.length);
    }

    public static void printHex(@Nonnull PrintWriter pw, @Nonnull byte[] arr, int start, int end) {
        for (int i = start; i < end; ++i) {
            pw.print(StringTool.intToStr(arr[i] & 0xFF, 16, 2));
        }
        pw.println("");
    }

    public static void printHex(@Nonnull PrintStream pw, @Nonnull byte[] arr) {
        StringTool.printHex(pw, arr, 0, arr.length);
    }

    public static void printHex(@Nonnull PrintStream pw, @Nonnull byte[] arr, int start, int end) {
        for (int i = start; i < end; ++i) {
            pw.print(StringTool.intToStr(arr[i] & 0xFF, 16, 2));
        }
        pw.println("");
    }

    public static String toHex(byte[] arr, int start, int end) {
        StringBuffer sb = new StringBuffer(arr.length * 2);
        for (int i = start; i < end; ++i) {
            sb.append(StringTool.intToStr(arr[i] & 0xFF, 16, 2));
        }
        return sb.toString();
    }

    public static String toHex(byte[] arr) {
        return StringTool.toHex(arr, 0, arr.length);
    }

    public static String toHexSp(byte[] arr, int start, int end) {
        StringBuffer sb = new StringBuffer(arr.length * 2);
        for (int i = start; i < end; ++i) {
            sb.append(StringTool.intToStr(arr[i] & 0xFF, 16, 2));
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String toHexSp(byte[] arr) {
        return StringTool.toHexSp(arr, 0, arr.length);
    }

    private static int decc(char c) throws Exception {
        int rv = Character.toUpperCase(c);
        rv = rv >= 65 ? 10 + (rv - 65) : (rv -= 48);
        if (rv < 0 || rv > 15) {
            throw new Exception("invalid key string (not hex)");
        }
        return rv;
    }

    public static byte[] fromHex(String s) throws Exception {
        int l = s.length();
        if (l % 2 == 1) {
            throw new Exception("fromHex: input string has odd length");
        }
        byte[] ar = new byte[l /= 2];
        int six = 0;
        for (int i = 0; i < l; ++i) {
            int c1 = StringTool.decc(s.charAt(six++));
            int c2 = StringTool.decc(s.charAt(six++));
            c1 = (c1 << 4) + c2;
            ar[i] = (byte)c1;
        }
        return ar;
    }

    public static File findFileOnPath(String fname, String path) {
        StringBuffer sb = new StringBuffer(64);
        int six = 0;
        while (six < path.length()) {
            sb.setLength(0);
            int eix = path.indexOf(File.pathSeparatorChar, six);
            if (eix == -1) {
                eix = path.length();
            }
            String rp = path.substring(six, eix);
            sb.append(rp);
            if (!rp.endsWith(File.separator)) {
                sb.append(File.separator);
            }
            sb.append(fname);
            File f = new File(sb.toString());
            if (f.exists()) {
                return f;
            }
            six = eix + 1;
        }
        return null;
    }

    public static File findFileOnEnv(String pname, String env) {
        String ev = System.getProperty(env);
        if (ev == null) {
            return null;
        }
        return StringTool.findFileOnPath(pname, ev);
    }

    @Deprecated
    public static String getFileExtension(String fn) {
        int p;
        int s1 = fn.lastIndexOf(47);
        int s2 = fn.lastIndexOf(92);
        if (s2 > s1) {
            s1 = s2;
        }
        if (s1 == -1) {
            s1 = 0;
        }
        if ((p = fn.lastIndexOf(46)) < s1) {
            return "";
        }
        return fn.substring(p);
    }

    public static void addPathToVector(List<String> v, String p) {
        File f = new File(p = p.trim());
        if ((f.isDirectory() || f.isFile()) && f.exists()) {
            for (int i = 0; i < v.size(); ++i) {
                String e = v.get(i);
                if (!e.equals(p)) continue;
                return;
            }
            v.add(p);
            return;
        }
    }

    public static void addSearchPathToVector(List<String> v, String searchpath) {
        int six = 0;
        while (six < searchpath.length()) {
            int eix = searchpath.indexOf(File.pathSeparatorChar, six);
            if (eix == -1) {
                eix = searchpath.length();
            }
            String ss = searchpath.substring(six, eix);
            StringTool.addPathToVector(v, ss);
            six = eix + 1;
        }
    }

    public static void addSearchEnvToVector(List<String> v, String envvar) {
        String ev = System.getProperty(envvar);
        if (ev == null) {
            return;
        }
        StringTool.addSearchPathToVector(v, ev);
    }

    public static void makeSearchPath(StringBuilder sb, List<String> v) {
        for (int i = 0; i < v.size(); ++i) {
            if (i > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(v.get(i));
        }
    }

    public static String makeSearchPath(List<String> v) {
        StringBuilder sb = new StringBuilder(128);
        StringTool.makeSearchPath(sb, v);
        return sb.toString();
    }

    public static void makeSearchPath(StringBuffer sb, String[] v) {
        for (int i = 0; i < v.length; ++i) {
            if (i > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(v[i]);
        }
    }

    public static String makeSearchPath(String[] v) {
        StringBuffer sb = new StringBuffer(128);
        StringTool.makeSearchPath(sb, v);
        return sb.toString();
    }

    public static String getFinalFrom(Class<?> cl, long sval) {
        return StringTool.getFinalFrom(cl, sval, null);
    }

    public static String getFinalFrom(Class<?> cl, long sval, String part) {
        return StringTool.getFinalFrom(cl, sval, part, null);
    }

    public static String getFinalFrom(Class<?> cl, long sval, String part, String ign) {
        Field[] far = cl.getFields();
        for (int i = 0; i < far.length; ++i) {
            Field f = far[i];
            int mod = f.getModifiers();
            if ((mod & 0x10) == 0 || (mod & 8) == 0 || (mod & 1) == 0) continue;
            try {
                long val = 0L;
                boolean valid = true;
                Class<?> ty = f.getType();
                if (ty == Integer.TYPE) {
                    val = f.getInt(null);
                } else if (ty == Long.TYPE) {
                    val = f.getLong(null);
                } else if (ty == Byte.TYPE) {
                    val = f.getByte(null);
                } else if (ty == Short.TYPE) {
                    val = f.getShort(null);
                } else {
                    valid = false;
                }
                if (!valid || val != sval || ign != null && f.getName().startsWith(ign)) continue;
                if (part == null) {
                    return f.getName();
                }
                if (!f.getName().toUpperCase().startsWith(part.toUpperCase())) continue;
                return f.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "[? " + sval + "]";
    }

    public static String urlLastPart(String url) {
        int sp = url.lastIndexOf(47);
        if (sp == -1) {
            return url;
        }
        return url.substring(sp + 1);
    }

    public static String htmlStringize(String is) {
        StringBuilder sb = new StringBuilder(is.length() + 20);
        StringTool.htmlStringize(sb, is);
        return sb.toString();
    }

    public static void htmlStringize(StringBuilder sb, String is) {
        StringTool.htmlStringizeLinefeeds(sb, is, false);
    }

    public static void htmlStringizewithLF(StringBuilder sb, String is) {
        StringTool.htmlStringizeLinefeeds(sb, is, true);
    }

    private static void htmlStringizeLinefeeds(StringBuilder sb, String is, boolean linefeeds) {
        int len = is.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = is.charAt(i);
            switch (c) {
                default: {
                    sb.append(c);
                    continue block6;
                }
                case '\n': {
                    sb.append("<br>");
                    if (!linefeeds) continue block6;
                    sb.append(c);
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                }
            }
        }
    }

    public static void htmlStringize(Appendable o, String is) throws Exception {
        StringBuffer sb = new StringBuffer(256);
        int len = is.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = is.charAt(i);
            switch (c) {
                default: {
                    sb.append(c);
                    if (sb.length() < 256) continue block6;
                    o.append(sb.toString());
                    sb.setLength(0);
                    continue block6;
                }
                case '\n': {
                    if (sb.length() > 0) {
                        o.append(sb.toString());
                    }
                    sb.setLength(0);
                    o.append("<br>");
                    continue block6;
                }
                case '>': {
                    if (sb.length() > 0) {
                        o.append(sb.toString());
                    }
                    sb.setLength(0);
                    o.append("&gt;");
                    continue block6;
                }
                case '<': {
                    if (sb.length() > 0) {
                        o.append(sb.toString());
                    }
                    sb.setLength(0);
                    o.append("&lt;");
                    continue block6;
                }
                case '&': {
                    if (sb.length() > 0) {
                        o.append(sb.toString());
                    }
                    sb.setLength(0);
                    o.append("&amp;");
                }
            }
        }
        if (sb.length() > 0) {
            o.append(sb.toString());
        }
    }

    public static String xmlStringize(String is) {
        if (is == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(is.length() + 20);
        StringTool.xmlStringize(sb, is);
        return sb.toString();
    }

    public static String xmlStringizeForDomApi(String is) {
        if (is == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(is.length() + 20);
        StringTool.xmlStringizeForDomApi(sb, is);
        return sb.toString();
    }

    public static void xmlStringize(StringBuffer sb, String is) {
        if (is == null) {
            sb.append("null");
            return;
        }
        block7: for (int i = 0; i < is.length(); ++i) {
            char c = is.charAt(i);
            switch (c) {
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    public static void xmlStringizeForDomApi(StringBuffer sb, String is) {
        if (is == null) {
            sb.append("null");
            return;
        }
        block9: for (int i = 0; i < is.length(); ++i) {
            char c = is.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("&#xA;");
                    continue block9;
                }
                case '\t': {
                    sb.append("&#x9;");
                    continue block9;
                }
                case '\r': {
                    sb.append("&#xD;");
                    continue block9;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block9;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block9;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block9;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    public static void entitiesToUnicode(Appendable sb, String str, boolean ignoremarkers) throws IOException {
        int ix = 0;
        while (ix < str.length()) {
            int epos = str.indexOf(38, ix);
            if (epos == -1) {
                sb.append(str.substring(ix, str.length()));
                return;
            }
            sb.append(str.substring(ix, epos));
            ix = epos + 1;
            epos = str.indexOf(59, epos + 1);
            if (epos == -1) {
                sb.append('&');
                continue;
            }
            String es = str.substring(ix, epos);
            ix = epos + 1;
            int ec = StringTool.entityToUnicode(es);
            if (ignoremarkers && StringTool.isMarker(ec)) {
                sb.append('&');
                sb.append(es);
                sb.append(';');
                continue;
            }
            if (ec == -1) {
                sb.append("&#");
                sb.append(Integer.toString(ec));
                sb.append(';');
                continue;
            }
            sb.append((char)ec);
        }
    }

    private static boolean isMarker(int ec) {
        return ec == 60 || ec == 62 || ec == 38;
    }

    public static void unicodeToEntities(StringBuffer sb, String str) {
        int se = str.length();
        for (int i = 0; i < se; ++i) {
            char c = str.charAt(i);
            if (c < ' ' || c > '\u007f' || c == '&' || c == '<' || c == '>') {
                String en = HtmlEntityTables.findName(c);
                if (en == null) {
                    sb.append(c);
                    continue;
                }
                sb.append("&");
                sb.append(en);
                sb.append(';');
                continue;
            }
            sb.append(c);
        }
    }

    public static int entityToUnicode(String ename) {
        if (ename.startsWith("#")) {
            try {
                return Integer.parseInt(ename.substring(1));
            }
            catch (Exception x) {
                return -1;
            }
        }
        return HtmlEntityTables.findCode(ename);
    }

    public static String strToJavascriptString(String cs, boolean dblquote) {
        if (cs == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(cs.length() + 10);
        StringTool.strToJavascriptString(sb, cs, dblquote);
        return sb.toString();
    }

    public static void strToJavascriptString(Appendable w, String cs, boolean dblquote) {
        try {
            int len = cs.length();
            char quotechar = dblquote ? (char)'\"' : '\'';
            w.append(quotechar);
            block12: for (int ix = 0; ix < len; ++ix) {
                int runstart = ix;
                char c = '\u0000';
                while (ix < len && (c = cs.charAt(ix)) >= ' ' && c != '\'' && c != '\\' && c != quotechar && c != '\u2028' && c != '\u2029') {
                    ++ix;
                }
                if (ix > runstart) {
                    w.append(cs, runstart, ix);
                    if (ix >= len) break;
                }
                switch (c) {
                    default: {
                        w.append("\\u");
                        w.append(StringTool.intToStr(c & 0xFFFF, 16, 4));
                        continue block12;
                    }
                    case '\n': 
                    case '\u2028': 
                    case '\u2029': {
                        w.append("\\n");
                        continue block12;
                    }
                    case '\b': {
                        w.append("\\b");
                        continue block12;
                    }
                    case '\f': {
                        w.append("\\f");
                        continue block12;
                    }
                    case '\r': {
                        w.append("\\r");
                        continue block12;
                    }
                    case '\t': {
                        w.append("\\t");
                        continue block12;
                    }
                    case '\'': {
                        w.append("\\'");
                        continue block12;
                    }
                    case '\"': {
                        w.append("\\\"");
                        continue block12;
                    }
                    case '\\': 
                }
                w.append("\\\\");
            }
            w.append(quotechar);
        }
        catch (IOException x) {
            throw WrappedException.wrap(x);
        }
    }

    public static boolean dbGetBool(String fv) {
        if (fv == null) {
            return false;
        }
        if (fv.length() == 0) {
            return false;
        }
        char c = Character.toUpperCase(fv.charAt(0));
        if (c == 'Y' || c == 'T') {
            return true;
        }
        if (c == '0') {
            return false;
        }
        return Character.isDigit(c);
    }

    public static String dbSetBool(boolean v) {
        return v ? "T" : "F";
    }

    public static void main(String[] args) {
        try {
            String s = StringTool.strToJavascriptString("accu\\'s vervangen", false);
            System.out.println(s);
        }
        catch (Throwable x) {
            System.out.println("Fatal: " + x.toString());
            x.printStackTrace();
        }
    }

    public static List<String> getEnvironment() {
        try {
            String line;
            String opsys = System.getProperty("os.name").toLowerCase();
            Process p = null;
            if (opsys.indexOf("windows 9") > -1) {
                p = Runtime.getRuntime().exec("command.com /c set");
            } else if (opsys.indexOf("nt") > -1 || opsys.indexOf("windows 2000") > -1) {
                p = Runtime.getRuntime().exec("cmd.exe /c set");
            } else if (opsys.indexOf("unix") > -1 || opsys.indexOf("Linux") > -1 || File.separatorChar == '/') {
                p = Runtime.getRuntime().exec("env");
            } else {
                throw new IllegalStateException("No environment can be found. This should not be possible.");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            ArrayList<String> v = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                v.add(line);
            }
            p.waitFor();
            return v;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public static final byte[] getBase64Map() {
        return BASE64MAP;
    }

    public static final String encodeBase64(String str) {
        if (str == null) {
            return null;
        }
        byte[] data = str.getBytes();
        return new String(StringTool.encodeBase64(data));
    }

    public static final byte[] encodeBase64(byte[] data) {
        int sidx;
        if (data == null) {
            return null;
        }
        byte[] dest = new byte[(data.length + 2) / 3 * 4];
        int didx = 0;
        for (sidx = 0; sidx < data.length - 2; sidx += 3) {
            dest[didx++] = BASE64MAP[data[sidx] >>> 2 & 0x3F];
            dest[didx++] = BASE64MAP[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
            dest[didx++] = BASE64MAP[data[sidx + 2] >>> 6 & 3 | data[sidx + 1] << 2 & 0x3F];
            dest[didx++] = BASE64MAP[data[sidx + 2] & 0x3F];
        }
        if (sidx < data.length) {
            dest[didx++] = BASE64MAP[data[sidx] >>> 2 & 0x3F];
            if (sidx < data.length - 1) {
                dest[didx++] = BASE64MAP[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
                dest[didx++] = BASE64MAP[data[sidx + 1] << 2 & 0x3F];
            } else {
                dest[didx++] = BASE64MAP[data[sidx] << 4 & 0x3F];
            }
        }
        while (didx < dest.length) {
            dest[didx] = 61;
            ++didx;
        }
        return dest;
    }

    public static final String decodeBase64ToString(String str) {
        if (str == null) {
            return null;
        }
        byte[] data = str.getBytes();
        return new String(StringTool.decodeBase64(data));
    }

    public static final byte[] decodeBase64(String str) {
        if (str == null) {
            return null;
        }
        byte[] data = str.getBytes();
        return StringTool.decodeBase64(data);
    }

    public static final byte[] decodeBase64(byte[] data) {
        int didx;
        if (data == null || data.length == 0) {
            return null;
        }
        int tail = data.length;
        while (data[tail - 1] == 61) {
            --tail;
        }
        byte[] dest = new byte[tail - data.length / 4];
        for (int idx = 0; idx < data.length; ++idx) {
            data[idx] = BASE64DECMAP[data[idx]];
        }
        int sidx = 0;
        for (didx = 0; didx < dest.length - 2; didx += 3) {
            dest[didx] = (byte)(data[sidx] << 2 & 0xFF | data[sidx + 1] >>> 4 & 3);
            dest[didx + 1] = (byte)(data[sidx + 1] << 4 & 0xFF | data[sidx + 2] >>> 2 & 0xF);
            dest[didx + 2] = (byte)(data[sidx + 2] << 6 & 0xFF | data[sidx + 3] & 0x3F);
            sidx += 4;
        }
        if (didx < dest.length) {
            dest[didx] = (byte)(data[sidx] << 2 & 0xFF | data[sidx + 1] >>> 4 & 3);
        }
        if (++didx < dest.length) {
            dest[didx] = (byte)(data[sidx + 1] << 4 & 0xFF | data[sidx + 2] >>> 2 & 0xF);
        }
        return dest;
    }

    public static final String encodeBase64ToString(byte[] data) {
        try {
            return new String(StringTool.encodeBase64(data), "utf8");
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new RuntimeException("bad encoding!?", x);
        }
    }

    public static String strStacktrace(Throwable t) {
        StringWriter sw = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.getBuffer().toString();
    }

    public static void strStacktrace(Appendable sb, Throwable t) {
        try {
            sb.append(StringTool.strStacktrace(t));
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    private static boolean inSkipSet(String[] set, String name) {
        for (String s : set) {
            if (!name.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static void strStacktraceFiltered(Appendable sb, Throwable t, String[] skipbefore, String[] skipafter, int linelimit) {
        String m;
        String m2;
        int ix;
        StackTraceElement[] se = t.getStackTrace();
        int len = se.length;
        for (ix = 0; ix < len && StringTool.inSkipSet(skipbefore, m2 = se[ix].getClassName()); ++ix) {
        }
        int sx = ix++;
        while (ix < len && !StringTool.inSkipSet(skipafter, m = se[ix].getClassName())) {
            ++ix;
        }
        int ex = ix;
        if (linelimit > 0 && ex - sx > linelimit) {
            ex = sx + linelimit;
        }
        for (int i = sx; i < ex; ++i) {
            try {
                sb.append("    " + se[i].toString() + "\n");
                continue;
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }

    public static final String normalizeURL(String current, String tpl) throws Exception {
        return StringTool.normalizeUndot(StringTool.normalizeConcat(current, tpl));
    }

    public static final String normalizeConcat(String current, String tpl) throws Exception {
        if (tpl == null || tpl.length() == 0) {
            return tpl;
        }
        if (tpl.charAt(0) == '/') {
            return tpl;
        }
        if (tpl.length() > 5 && tpl.substring(0, 5).toLowerCase().equals("http:")) {
            int pos = tpl.indexOf(47, 7);
            if (pos == -1) {
                throw new Exception("Cannot decode URL '" + tpl + "': missing / after host part");
            }
            return tpl.substring(pos);
        }
        int lix = current.lastIndexOf(47);
        if (lix == -1) {
            return "/" + tpl;
        }
        return current.substring(0, lix + 1) + tpl;
    }

    public static final String normalizeUndot(String ins) {
        int len = ins.length();
        char[] car = new char[len];
        ins.getChars(0, ins.length(), car, 0);
        int six = 0;
        int dix = 0;
        while (six < len) {
            char c = car[six];
            if (c == '/') {
                int dotlevel = 0;
                int tix = six + 1;
                if (tix < len && car[tix] == '.') {
                    char tc;
                    dotlevel = 1;
                    if (++tix < len && (tc = car[tix]) != '/') {
                        if (tc == '.') {
                            dotlevel = 2;
                            if (++tix < len && car[tix] != '/') {
                                dotlevel = 0;
                            }
                        } else {
                            dotlevel = 0;
                        }
                    }
                }
                if (dotlevel == 0) {
                    car[dix++] = car[six++];
                    continue;
                }
                if (dotlevel == 1) {
                    six += 2;
                    continue;
                }
                if (dotlevel == 2) {
                    while (dix > 0 && car[dix - 1] != '/') {
                        --dix;
                    }
                    six += 3;
                    if (dix > 0) {
                        --dix;
                        continue;
                    }
                    ++six;
                    continue;
                }
                throw new IllegalStateException("?? Dotlevel bad!?");
            }
            car[dix++] = car[six++];
        }
        if (dix == six) {
            return ins;
        }
        return new String(car, 0, dix);
    }

    public static int strToInt(String v, int defval) {
        try {
            return Integer.parseInt(v);
        }
        catch (Exception exception) {
            return defval;
        }
    }

    public static long strToLong(String v, long defval) {
        try {
            return Long.parseLong(v);
        }
        catch (Exception exception) {
            return defval;
        }
    }

    public static long strToLong(String v, int six, int eix, int defval) {
        if (six >= eix) {
            return defval;
        }
        long val = 0L;
        while (six < eix) {
            char c;
            if ((c = v.charAt(six++)) < '0' || c > '9') {
                return defval;
            }
            val = val * 10L + (long)(c - 48);
        }
        return val;
    }

    public static String getNextPathComponent(int ix, String s, boolean includeslash) {
        int pos = s.indexOf(47, ix);
        if (pos == -1) {
            return s.substring(ix);
        }
        if (includeslash) {
            ++pos;
        }
        return s.substring(ix, pos);
    }

    public static String getNextPathComponent(String s, boolean includeslash) {
        return StringTool.getNextPathComponent(0, s, includeslash);
    }

    public static boolean equalStringList(List<String> inl, List<String> al, boolean caseindependent) {
        if (inl == al) {
            return true;
        }
        if (al == null && inl != null || inl == null && al != null) {
            return false;
        }
        if (al.size() != inl.size()) {
            return false;
        }
        int i = al.size();
        while (--i >= 0) {
            String a = al.get(i);
            String b = inl.get(i);
            if (!(caseindependent ? !a.equalsIgnoreCase(b) : !a.equals(b))) continue;
            return false;
        }
        return true;
    }

    public static String makeURL(File f) {
        String s = f.getAbsolutePath().toString();
        if (s.startsWith("/")) {
            return "file://" + s;
        }
        return "file:///" + s;
    }

    public static String fixFileURL(String fileurl) {
        int ix;
        if (fileurl.length() < 8) {
            return fileurl;
        }
        String s = fileurl.substring(0, 5);
        if (!s.equalsIgnoreCase("file:")) {
            return fileurl;
        }
        char c1 = fileurl.charAt(5);
        char c2 = fileurl.charAt(6);
        char c3 = fileurl.charAt(7);
        if (c1 == '/' && c2 == '/' && c3 == '/') {
            return fileurl;
        }
        if (c1 == '/' && c2 == '/' && fileurl.length() > 8 && fileurl.charAt(8) == ':') {
            return fileurl;
        }
        StringBuffer sb = new StringBuffer(fileurl.length() + 5);
        sb.append("file://");
        for (ix = 5; ix < fileurl.length() && fileurl.charAt(ix) == '/'; ++ix) {
        }
        if (ix + 1 < fileurl.length()) {
            if (fileurl.charAt(ix + 1) == ':') {
                sb.append(fileurl.substring(ix));
                return sb.toString();
            }
            sb.append('/');
            sb.append(fileurl.substring(ix));
            return sb.toString();
        }
        if (ix >= fileurl.length()) {
            return fileurl;
        }
        sb.append(fileurl.charAt(ix));
        return sb.toString();
    }

    public static void encodeURLEncoded(Appendable sb, String str) {
        try {
            for (byte da : str.getBytes("utf-8")) {
                if (StringTool.isSpecialUrlChar(da)) {
                    sb.append('%');
                    sb.append(Character.forDigit(da >> 4 & 0xF, 16));
                    sb.append(Character.forDigit(da & 0xF, 16));
                    continue;
                }
                sb.append((char)da);
            }
        }
        catch (Exception x) {
            throw new RuntimeException(x.toString(), x);
        }
    }

    private static boolean isSpecialUrlChar(byte da) {
        if (da <= 32) {
            return true;
        }
        switch (da) {
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 91: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public static String encodeURLEncoded(String str) {
        StringBuilder sb = new StringBuilder(str.length() + 30);
        StringTool.encodeURLEncoded(sb, str);
        return sb.toString();
    }

    public static String decodeURLEncoded(String encoded) {
        int len = encoded.length();
        int ix = 0;
        byte[] data = new byte[encoded.length()];
        int oix = 0;
        while (ix < len) {
            char c;
            if ((c = encoded.charAt(ix++)) != '%') {
                data[oix++] = (byte)c;
                continue;
            }
            if (ix + 2 > len) {
                data[oix++] = (byte)c;
                continue;
            }
            int i1 = Character.getNumericValue(encoded.charAt(ix++));
            int i2 = Character.getNumericValue(encoded.charAt(ix++));
            if (i1 < 0 || i1 >= 16 || i2 < 0 || i2 >= 16) {
                ix -= 2;
                data[oix++] = 37;
                continue;
            }
            data[oix++] = (byte)(i1 << 4 | i2);
        }
        try {
            return new String(data, 0, oix, "utf-8");
        }
        catch (Exception x) {
            return encoded;
        }
    }

    public static final String getLocation() {
        StringBuffer sb = new StringBuffer(512);
        StringTool.getLocation(sb);
        return sb.toString();
    }

    public static final void getLocation(StringBuffer sb) {
        sb.append("At ");
        sb.append(new Date().toString());
        sb.append(" in thread ");
        sb.append(Thread.currentThread().getName());
        sb.append(" (");
        sb.append(Thread.currentThread().toString());
        sb.append("), stack:\n");
        try {
            throw new Exception("Trying to get source location");
        }
        catch (Exception z) {
            StringTool.strStacktrace(sb, z);
            return;
        }
    }

    public static final void dumpLocation(String msg) {
        try {
            throw new IllegalStateException("duh");
        }
        catch (IllegalStateException x) {
            System.out.println(msg);
            x.printStackTrace(System.out);
            return;
        }
    }

    public static final void dumpDebugLocation(@Nonnull Logger log, @Nonnull String msg) {
        try {
            throw new IllegalStateException("Dump at debug level for source location...");
        }
        catch (IllegalStateException x) {
            log.debug(msg, (Throwable)x);
            return;
        }
    }

    public static final void dumpTraceLocation(@Nonnull Logger log, @Nonnull String msg) {
        try {
            throw new IllegalStateException("Dump at trace level for source location...");
        }
        catch (IllegalStateException x) {
            log.trace(msg, (Throwable)x);
            return;
        }
    }

    public static final void dumpInfoLocation(@Nonnull Logger log, @Nonnull String msg) {
        try {
            throw new IllegalStateException("Dump at info level for source location...");
        }
        catch (IllegalStateException x) {
            log.info(msg, (Throwable)x);
            return;
        }
    }

    public static final void dumpWarnLocation(@Nonnull Logger log, @Nonnull String msg) {
        try {
            throw new IllegalStateException("Dump at warn level for source location...");
        }
        catch (IllegalStateException x) {
            log.warn(msg, (Throwable)x);
            return;
        }
    }

    public static final void dumpErrorLocation(@Nonnull Logger log, @Nonnull String msg) {
        try {
            throw new IllegalStateException("Dump at error level for source location...");
        }
        catch (IllegalStateException x) {
            log.error(msg, (Throwable)x);
            return;
        }
    }

    public static String strUnquote(String s) {
        if (s.length() < 2) {
            return s;
        }
        char c1 = s.charAt(0);
        char c2 = s.charAt(s.length() - 1);
        if (c1 != '\'' && c1 != '\"') {
            return s;
        }
        if (c1 != c2) {
            return s;
        }
        return s.substring(1, s.length() - 1);
    }

    public static String strUnspace(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(s.length());
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String oldStrOracleTruncate(String in, int nchars) {
        int len;
        if (in == null) {
            return null;
        }
        if (nchars > 4000) {
            nchars = 4000;
        }
        if ((len = in.length()) > nchars) {
            in = in.substring(0, nchars);
        } else {
            nchars = len;
        }
        try {
            byte[] data = in.getBytes("UTF-8");
            if (data.length <= 4000) {
                return in;
            }
            len = nchars - (data.length - 4000);
            while (true) {
                if ((data = (in = in.substring(0, len)).getBytes("UTF-8")).length <= 4000) {
                    return in;
                }
                --len;
            }
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException(x);
        }
    }

    @Nullable
    public static String strOracleTruncate(@Nullable String in, int nchars) {
        return StringTool.strTruncateUtf8Bytes(in, nchars, 4000);
    }

    @Nullable
    public static String strTruncateUtf8Bytes(@Nullable String in, int nchars, int nbytes) {
        if (null == in) {
            return null;
        }
        int length = in.length();
        if (length <= nbytes / 3) {
            if (length > nchars) {
                in = in.substring(0, nchars);
            }
            return in;
        }
        int maxlength = StringTool.utf8Truncated(in, nchars, nbytes);
        if (maxlength == length) {
            return in;
        }
        return in.substring(0, maxlength);
    }

    public static int utf8Truncated(String in, int length, int maxbytes) {
        if (length > in.length()) {
            length = in.length();
        }
        int bytes = 0;
        for (int ix = 0; ix < length; ++ix) {
            char c = in.charAt(ix);
            bytes = c < '\u0080' ? ++bytes : (c < '\u0800' ? (bytes += 2) : (bytes += 3));
            if (bytes <= maxbytes) continue;
            return ix;
        }
        return length;
    }

    public static int utf8Length(String in) {
        int length = in.length();
        int bytes = 0;
        for (int ix = 0; ix < length; ++ix) {
            char c = in.charAt(ix);
            if (c < '\u0080') {
                ++bytes;
                continue;
            }
            if (c < '\u0800') {
                bytes += 2;
                continue;
            }
            bytes += 3;
        }
        return bytes;
    }

    public static String strOracleTruncate(String in, int nchars, String suffix) {
        return StringTool.strTruncateUtf8Bytes(in, nchars, 4000, suffix);
    }

    public static String strTruncateUtf8Bytes(String in, int nchars, int nbytes, String suffix) {
        if (null == in) {
            return null;
        }
        int length = in.length();
        int suffixLength = suffix.length();
        if (length <= nbytes / 3) {
            if (length > nchars) {
                if (nchars <= suffixLength) {
                    return in.substring(0, nchars);
                }
                StringBuilder sb = new StringBuilder(nchars);
                sb.append(in, 0, nchars - suffixLength);
                sb.append(suffix);
                return sb.toString();
            }
            return in;
        }
        int maxlength = StringTool.utf8Truncated(in, nchars, nbytes);
        if (maxlength == length) {
            return in;
        }
        int suffixBytes = StringTool.utf8Length(suffix);
        StringBuilder sb = new StringBuilder(nbytes);
        sb.append(in, 0, maxlength -= suffixBytes);
        sb.append(suffix);
        return sb.toString();
    }

    public static String oldStrOracleTruncate(String in, int nchars, String suffixForTooLong) {
        if (null == suffixForTooLong || in == null) {
            return StringTool.strOracleTruncate(in, nchars);
        }
        String strOracle = StringTool.strOracleTruncate(in, nchars);
        if (in.equals(strOracle)) {
            return in;
        }
        try {
            byte[] suffixData = suffixForTooLong.getBytes("UTF-8");
            int suffixBytesLen = suffixData.length;
            int len = strOracle.length() - suffixForTooLong.length();
            in = strOracle;
            while (true) {
                byte[] data;
                if ((data = (in = in.substring(0, len)).getBytes("UTF-8")).length + suffixBytesLen <= 4000) {
                    return in + suffixForTooLong;
                }
                --len;
            }
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException(x);
        }
    }

    public static String strNanoTime(long ns) {
        if (ns < 1000L) {
            return ns + " ns";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < TIMESET.length; ++i) {
            if (ns < TIMESET[i]) continue;
            long u = ns / TIMESET[i];
            sb.append(Long.toString(u));
            sb.append(SUFFIXES[i]);
            sb.append(' ');
            u = ns % TIMESET[i];
            sb.append(Long.toString(u /= TIMESET[++i]));
            sb.append(SUFFIXES[i]);
            return sb.toString();
        }
        return ns + "ns";
    }

    public static String strReplace(String src, String old, String nw) {
        if (src == null || old == null || nw == null || src.length() < old.length() || old.length() == 0) {
            return src;
        }
        int pos = src.indexOf(old);
        if (pos == -1) {
            return src;
        }
        int len = src.length();
        StringBuilder sb = new StringBuilder(len + 20);
        int ix = 0;
        while (ix < len) {
            if (pos > ix) {
                sb.append(src, ix, pos);
                ix = pos;
            }
            sb.append(nw);
            pos = src.indexOf(old, ix += old.length());
            if (pos != -1) continue;
            sb.append(src, ix, len);
            break;
        }
        return sb.toString();
    }

    public static String getExceptionMessage(Throwable t) {
        String s = t.getMessage();
        if (s == null || s.trim().length() == 0) {
            return t.toString();
        }
        return s;
    }

    public static int getJreVersion() {
        if (m_jre_checked) {
            return m_jre_version;
        }
        String jre = System.getProperty("java.version");
        int ver = 0;
        StringTokenizer st = new StringTokenizer(jre, ".-/_");
        for (int i = 0; i < 4; ++i) {
            int lev = 0;
            try {
                if (st.hasMoreTokens()) {
                    String v = st.nextToken();
                    lev = Integer.parseInt(v);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ver = (ver << 8) + (lev & 0xFF);
        }
        m_jre_checked = true;
        m_jre_version = ver;
        return ver;
    }

    public static String removeRepeatingCharacters(String in) {
        if (null == in || in.length() < 20) {
            return in;
        }
        int len = in.length();
        StringBuilder sb = new StringBuilder(len);
        char lc = '\u0000';
        int count = 0;
        for (int i = 0; i < len; ++i) {
            char c = in.charAt(i);
            if (Character.isDigit(c)) {
                StringTool.addRepeatingCharacterOnce(sb, lc, count);
                lc = c;
                count = 1;
                continue;
            }
            if (c == lc) {
                ++count;
                continue;
            }
            StringTool.addRepeatingCharacterOnce(sb, lc, count);
            lc = c;
            count = 1;
        }
        StringTool.addRepeatingCharacterOnce(sb, lc, count);
        return sb.toString();
    }

    private static void addRepeatingCharacterOnce(StringBuilder sb, char lc, int count) {
        if (count < 3) {
            while (count > 0) {
                sb.append(lc);
                --count;
            }
        } else {
            sb.append(lc);
        }
    }

    public static String extractSingleLine(String in) {
        if (in == null || in.length() < 80) {
            return in;
        }
        int dotpos = in.indexOf(46);
        if (dotpos > 0) {
            return in.substring(0, dotpos + 1);
        }
        return in.substring(0, 75) + "...";
    }

    @Nonnull
    public static String generateGUID() {
        int sidx;
        byte[] bin = new byte[18];
        ByteArrayUtil.setInt(bin, 0, m_guidSeed);
        ByteArrayUtil.setShort(bin, 4, (short)(Math.random() * 65536.0));
        long v = System.currentTimeMillis() / 1000L - (long)(m_guidSeed * 60);
        ByteArrayUtil.setInt(bin, 6, (int)v);
        ByteArrayUtil.setLong(bin, 10, System.nanoTime());
        StringBuilder sb = new StringBuilder((bin.length + 2) / 3 * 4);
        for (sidx = 0; sidx < bin.length - 2; sidx += 3) {
            sb.append(GUIDBASE64MAP[bin[sidx] >>> 2 & 0x3F]);
            sb.append(GUIDBASE64MAP[bin[sidx + 1] >>> 4 & 0xF | bin[sidx] << 4 & 0x3F]);
            sb.append(GUIDBASE64MAP[bin[sidx + 2] >>> 6 & 3 | bin[sidx + 1] << 2 & 0x3F]);
            sb.append(GUIDBASE64MAP[bin[sidx + 2] & 0x3F]);
        }
        if (sidx < bin.length) {
            sb.append(GUIDBASE64MAP[bin[sidx] >>> 2 & 0x3F]);
            if (sidx < bin.length - 1) {
                sb.append(GUIDBASE64MAP[bin[sidx + 1] >>> 4 & 0xF | bin[sidx] << 4 & 0x3F]);
                sb.append(GUIDBASE64MAP[bin[sidx + 1] << 2 & 0x3F]);
            } else {
                sb.append(GUIDBASE64MAP[bin[sidx] << 4 & 0x3F]);
            }
        }
        return sb.toString();
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static void createInsertStatement(StringBuilder sb, String table, String pkname, String pkexpr, String[] fields) {
        sb.append("insert into ");
        sb.append(table);
        sb.append('(');
        int fc = 0;
        for (String s : fields) {
            if (fc++ > 0) {
                sb.append(',');
            }
            sb.append(s);
        }
        sb.append(',');
        sb.append(pkname);
        sb.append(") values (");
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('?');
        }
        sb.append(',');
        sb.append(pkexpr);
        sb.append(')');
    }

    public static void createUpdateStatement(StringBuilder sb, String table, String pkname, String[] fields) {
        sb.append("update ");
        sb.append(table);
        sb.append(" set ");
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(fields[i]);
            sb.append("=?");
        }
        sb.append(" where ");
        sb.append(pkname);
        sb.append("=?");
    }

    public static String fill(int count, char character) {
        char[] fill = new char[count];
        Arrays.fill(fill, character);
        return new String(fill);
    }

    @Nonnull
    public static String removeAccents(@Nonnull String str) {
        if (str == null) {
            return null;
        }
        String nfdNormalizedString = Normalizer.normalize(str, Normalizer.Form.NFD);
        return NORMALIZE_PATTERN.matcher(nfdNormalizedString).replaceAll("");
    }

    @Deprecated
    @Nonnull
    public static String getString(@Nonnull InputStream is) throws Exception {
        int read;
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(is, "UTF-8");
        do {
            if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
            out.append(buffer, 0, read);
        } while (read >= 0);
        return out.toString();
    }

    @Nullable
    public static String truncLeadingOracleColumn(@Nullable String text, int columnSize) {
        int lengthInBytes;
        if (text == null) {
            return null;
        }
        if (text.length() > columnSize) {
            text = text.substring(text.length() - columnSize);
        }
        if ((lengthInBytes = StringTool.getUtf8LengthInBytes(text)) <= 4000) {
            return text;
        }
        while ((lengthInBytes = StringTool.getUtf8LengthInBytes(text)) > 4000) {
            int tooMuchBytes = lengthInBytes - 4000;
            int startPosition = tooMuchBytes / 2 + 1;
            text = text.substring(startPosition);
        }
        return text;
    }

    private static int getUtf8LengthInBytes(@Nonnull String text) {
        try {
            return text.getBytes("utf8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new WrappedException(e);
        }
    }

    @Nonnull
    public static String strCapitalized(@Nonnull String name) {
        if (name.length() == 0) {
            return name;
        }
        char c = name.charAt(0);
        return Character.toUpperCase(c) + name.substring(1).toLowerCase();
    }

    public static boolean isInvalidOracleLength(@Nonnull String text) {
        return StringTool.getUtf8LengthInBytes(text) >= 4000;
    }

    public static boolean isInteger(@Nullable String string) {
        if (null == string) {
            return false;
        }
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Nonnull
    public static String replaceNewLineChars(@Nonnull String content, @Nonnull String replacement) {
        return content.replace("\r\n", replacement).replace("\r", replacement).replace("\n", replacement);
    }

    public static boolean validateUrl(@Nullable String urlValue) {
        if (urlValue == null || StringTool.isBlank(urlValue.toString())) {
            return false;
        }
        return URL_PATTERN.matcher(urlValue).matches();
    }

    public static String renderAsRawHtml(@Nonnull String input, boolean removeEndingNewLines) {
        input = (input = input.replace("<br>", "<br/>")).contains("<br/>") ? input.replace("\n", "") : input.replace("\n", "<br/>");
        if (removeEndingNewLines) {
            while (StringTool.strEndsWithIgnoreCase(input, "<br/>")) {
                input = input.substring(0, input.length() - 5).trim();
            }
        }
        return input;
    }

    static {
        for (int ix = 0; ix < BASE64MAP.length; ++ix) {
            StringTool.BASE64DECMAP[StringTool.BASE64MAP[ix]] = (byte)ix;
        }
        TIMESET = new long[]{3600000000000L, 60000000000L, 1000000000L, 1000000L, 1000L, 1L};
        SUFFIXES = new String[]{"H", "m", "s", "ms", "us", "ns"};
        GUIDBASE64MAP = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz$_".toCharArray();
        NORMALIZE_PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        StringTool.getJreVersion();
        long val = System.currentTimeMillis() / 1000L / 60L;
        m_guidSeed = (int)val;
        URL_PATTERN = Pattern.compile("\\b(?:(https?|ftp|file)://|www\\.)?([\\w-]+[\\.\\:\\-])+[\\w-]+(/[\\w- ;#,./?%&=]*)?", 66);
    }
}

