/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.util.Arrays;
import to.etc.util.InvalidVersionNumberException;

public final class VersionNumber
implements Comparable<VersionNumber> {
    private final String m_prefix;
    private final String m_suffix;
    private final int[] m_version;

    public VersionNumber(String prefix, int[] version, String suffix) {
        if (version == null || version.length == 0) {
            throw new IllegalArgumentException("The version array cannot be null or empty");
        }
        if (version[version.length - 1] <= 0) {
            throw new IllegalArgumentException("The version array cannot end in a 0: normalize the version # by removing trailing zeroes.");
        }
        this.m_prefix = prefix == null ? "" : prefix;
        this.m_version = version;
        this.m_suffix = suffix == null ? "" : suffix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_prefix);
        for (int i = 0; i < this.m_version.length; ++i) {
            if (i != 0) {
                sb.append('.');
            }
            sb.append(this.m_version[i]);
        }
        sb.append(this.m_suffix);
        return sb.toString();
    }

    public String toString(int mindigits) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_prefix);
        if (mindigits < this.m_version.length) {
            mindigits = this.m_version.length;
        }
        for (int i = 0; i < mindigits; ++i) {
            if (i != 0) {
                sb.append('.');
            }
            if (i >= this.m_version.length) {
                sb.append('0');
                continue;
            }
            sb.append(this.m_version[i]);
        }
        sb.append(this.m_suffix);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_prefix == null ? 0 : this.m_prefix.hashCode());
        result = 31 * result + (this.m_suffix == null ? 0 : this.m_suffix.hashCode());
        result = 31 * result + Arrays.hashCode(this.m_version);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionNumber other = (VersionNumber)obj;
        if (this.m_prefix == null ? other.m_prefix != null : !this.m_prefix.equals(other.m_prefix)) {
            return false;
        }
        if (this.m_suffix == null ? other.m_suffix != null : !this.m_suffix.equals(other.m_suffix)) {
            return false;
        }
        return Arrays.equals(this.m_version, other.m_version);
    }

    public static VersionNumber parse(String input) throws InvalidVersionNumberException {
        char c;
        char c2;
        int ix;
        if (input.trim().equalsIgnoreCase("trunk")) {
            return new VersionNumber("", new int[]{999, 999}, "");
        }
        int len = input.length();
        for (ix = 0; ix < len && !Character.isDigit(c2 = input.charAt(ix)); ++ix) {
            if (Character.isLetter(c2)) continue;
            throw new InvalidVersionNumberException("A version number must start with either letters or digits, the version '" + input + "' is invalid");
        }
        String prefix = input.substring(0, ix);
        while (len > ix && !Character.isDigit(c = input.charAt(len - 1))) {
            if (!Character.isLetter(c)) {
                throw new InvalidVersionNumberException("A version number must end with either letters or digits, the version '" + input + "' is invalid");
            }
            --len;
        }
        if (ix >= len) {
            throw new InvalidVersionNumberException("The version number '" + input + "' is invalid (no dotted number present)");
        }
        String suffix = input.substring(len);
        String vns = input.substring(ix, len);
        String[] ar = vns.split("\\.");
        int[] res = new int[ar.length];
        ix = 0;
        for (String v : ar) {
            try {
                res[ix] = Integer.parseInt(v);
                if (res[ix] < 0) {
                    throw new RuntimeException();
                }
                ++ix;
            }
            catch (Exception x) {
                throw new InvalidVersionNumberException("The version number '" + input + "' is invalid (invalid number '" + v + "' in dotted number)");
            }
        }
        for (ix = res.length; ix > 0 && res[ix - 1] == 0; --ix) {
        }
        if (ix != res.length) {
            int[] nr = new int[ix];
            System.arraycopy(res, 0, nr, 0, ix);
            res = nr;
        }
        if (res.length == 0) {
            throw new InvalidVersionNumberException("The version number '" + input + "' is invalid (invalid dotted number present)");
        }
        return new VersionNumber(prefix, res, suffix);
    }

    @Override
    public int compareTo(VersionNumber o) {
        int r = this.m_prefix.compareTo(o.m_prefix);
        if (r != 0) {
            return r;
        }
        r = VersionNumber.compareVersion(this.m_version, o.m_version);
        if (r != 0) {
            return r;
        }
        return this.m_suffix.compareTo(o.m_suffix);
    }

    private static int compareVersion(int[] a, int[] b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a != null && b == null) {
            return -1;
        }
        if (a == null && b != null) {
            return 1;
        }
        if (a == null) {
            throw new IllegalStateException("This is not possible because of the previous checks.");
        }
        if (a.length == 0 && b.length == 0) {
            return 0;
        }
        int clen = a.length;
        if (clen > b.length) {
            clen = b.length;
        }
        for (int i = 0; i < clen; ++i) {
            int res = a[i] - b[i];
            if (res == 0) continue;
            return res < 0 ? -1 : 1;
        }
        if (a.length == b.length) {
            return 0;
        }
        if (a.length > b.length) {
            if (VersionNumber.isRestZero(a, clen)) {
                return 0;
            }
            return 1;
        }
        if (VersionNumber.isRestZero(b, clen)) {
            return 0;
        }
        return -1;
    }

    private static boolean isRestZero(int[] a, int ix) {
        while (ix < a.length) {
            if (a[ix++] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isSameBase(VersionNumber o) {
        if (null == o) {
            return false;
        }
        return this.m_prefix.equals(o.m_prefix) && this.m_suffix.equals(o.m_suffix);
    }

    public boolean isDevelopment() {
        return this.m_version[0] >= 99;
    }

    private static void check(String in, String out) throws Exception {
        VersionNumber vn = VersionNumber.parse(in);
        String vns = vn.toString();
        if (vns.equals(out)) {
            return;
        }
        System.out.println("ERROR: input '" + in + "' -> " + vns + " instead of '" + out + "'");
    }

    public static void main(String[] args) {
        try {
            VersionNumber vn = VersionNumber.parse("vp4.0kv");
            System.out.println("vn = " + vn);
            VersionNumber.check("vp4.0kv", "vp4kv");
            VersionNumber.check("4.10", "4.10");
            VersionNumber.check("4.1.1kv", "4.1.1kv");
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

