/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

@Deprecated
public class WrapperCache {
    private static int BYTE_LOWER_BOUND = 0;
    private static int BYTE_UPPER_BOUND = 255;
    private static int CHARACTER_LOWER_BOUND = 0;
    private static int CHARACTER_UPPER_BOUND = 255;
    private static int SHORT_LOWER_BOUND = -1000;
    private static int SHORT_UPPER_BOUND = 1000;
    private static int INTEGER_LOWER_BOUND = -1000;
    private static int INTEGER_UPPER_BOUND = 1000;
    private static int LONG_LOWER_BOUND = -1000;
    private static int LONG_UPPER_BOUND = 1000;
    private static Byte[] m_bytes = WrapperCache.createBytes();
    private static Character[] m_chars = WrapperCache.createCharacters();
    private static Short[] m_shorts = WrapperCache.createShorts();
    private static Integer[] m_ints = WrapperCache.createIntegers();
    private static Long[] m_longs = WrapperCache.createLongs();

    public static Boolean getBoolean(boolean pValue) {
        return pValue ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Byte getByte(byte pValue) {
        if (pValue >= BYTE_LOWER_BOUND && pValue <= BYTE_UPPER_BOUND) {
            return m_bytes[pValue - BYTE_LOWER_BOUND];
        }
        return new Byte(pValue);
    }

    public static Character getCharacter(char pValue) {
        if (pValue >= CHARACTER_LOWER_BOUND && pValue <= CHARACTER_UPPER_BOUND) {
            return m_chars[pValue - CHARACTER_LOWER_BOUND];
        }
        return new Character(pValue);
    }

    public static Short getShort(short pValue) {
        if (pValue >= SHORT_LOWER_BOUND && pValue <= SHORT_UPPER_BOUND) {
            return m_shorts[pValue - SHORT_LOWER_BOUND];
        }
        return new Short(pValue);
    }

    public static Integer getInteger(int pValue) {
        if (pValue >= INTEGER_LOWER_BOUND && pValue <= INTEGER_UPPER_BOUND) {
            return m_ints[pValue - INTEGER_LOWER_BOUND];
        }
        return new Integer(pValue);
    }

    public static Long getLong(long pValue) {
        if (pValue >= (long)LONG_LOWER_BOUND && pValue <= (long)LONG_UPPER_BOUND) {
            return m_longs[(int)pValue - LONG_LOWER_BOUND];
        }
        return new Long(pValue);
    }

    public static Float getFloat(float pValue) {
        return new Float(pValue);
    }

    public static Double getDouble(double pValue) {
        return new Double(pValue);
    }

    private static Short[] createShorts() {
        int len = SHORT_UPPER_BOUND - SHORT_LOWER_BOUND + 1;
        Short[] ret = new Short[len];
        short val = (short)SHORT_LOWER_BOUND;
        int i = 0;
        while (i < len) {
            ret[i] = new Short(val);
            ++i;
            val = (short)(val + 1);
        }
        return ret;
    }

    private static Integer[] createIntegers() {
        int len = INTEGER_UPPER_BOUND - INTEGER_LOWER_BOUND + 1;
        Integer[] ret = new Integer[len];
        int val = INTEGER_LOWER_BOUND;
        int i = 0;
        while (i < len) {
            ret[i] = new Integer(val);
            ++i;
            ++val;
        }
        return ret;
    }

    private static Long[] createLongs() {
        int len = LONG_UPPER_BOUND - LONG_LOWER_BOUND + 1;
        Long[] ret = new Long[len];
        long val = LONG_LOWER_BOUND;
        int i = 0;
        while (i < len) {
            ret[i] = new Long(val);
            ++i;
            ++val;
        }
        return ret;
    }

    private static Byte[] createBytes() {
        int len = BYTE_UPPER_BOUND - BYTE_LOWER_BOUND + 1;
        Byte[] ret = new Byte[len];
        byte val = (byte)BYTE_LOWER_BOUND;
        int i = 0;
        while (i < len) {
            ret[i] = new Byte(val);
            ++i;
            val = (byte)(val + 1);
        }
        return ret;
    }

    private static Character[] createCharacters() {
        int len = CHARACTER_UPPER_BOUND - CHARACTER_LOWER_BOUND + 1;
        Character[] ret = new Character[len];
        char val = (char)CHARACTER_LOWER_BOUND;
        int i = 0;
        while (i < len) {
            ret[i] = new Character(val);
            ++i;
            val = (char)(val + '\u0001');
        }
        return ret;
    }
}

