/*
 * Decompiled with CFR 0.152.
 */
package to.etc.xml;

import java.util.Date;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import to.etc.xml.DOMDecoder;
import to.etc.xml.DOMNodeIterator;
import to.etc.xml.W3CEncodingException;
import to.etc.xml.W3CSchemaCoder;

public class DOMDecoderBase {
    private String m_encodingNamespace;
    private String m_defaultNamespace;
    private Node m_currentRoot;
    private static final DOMNodeIterator EMPTY_ITERATOR = new DOMNodeIterator();

    public DOMDecoderBase() {
        this.m_encodingNamespace = "http://schemas.xmlsoap.org/soap/encoding/";
    }

    public DOMDecoderBase(Node root) {
        this(root, null, "http://schemas.xmlsoap.org/soap/encoding/");
    }

    public DOMDecoderBase(String encodingNamespace) {
        this.m_encodingNamespace = encodingNamespace;
    }

    public DOMDecoderBase(Node currentRoot, String defaultNamespace, String encodingNamespace) {
        this.m_currentRoot = currentRoot;
        this.m_defaultNamespace = defaultNamespace;
        this.m_encodingNamespace = encodingNamespace;
    }

    private String findStringNode(String name) {
        Node n = this.nodeFind(this.getCurrentRoot(), this.currentNS(), name);
        if (n == null) {
            return null;
        }
        return this.textFrom(n);
    }

    private void appendParent(StringBuilder sb, Node nd) {
        if (nd == null) {
            return;
        }
        if (nd.getParentNode() != null && nd.getParentNode().getNodeType() != 9) {
            this.appendParent(sb, nd.getParentNode());
            sb.append('.');
        }
        sb.append(nd.getNodeName());
    }

    private String createLocation(String name) {
        StringBuilder sb = new StringBuilder();
        this.appendParent(sb, this.getCurrentRoot());
        if (sb.length() > 0) {
            sb.append('.');
        }
        sb.append(name);
        return sb.toString();
    }

    private void missing(String name) {
        StringBuilder sb = new StringBuilder();
        this.appendParent(sb, this.getCurrentRoot());
        throw new W3CEncodingException("Missing element '" + name + "@" + this.currentNS() + "'").setLocation(sb.toString());
    }

    private void invalid(String name, String value) {
        throw new W3CEncodingException("Invalid value", value).setLocation(this.createLocation(name));
    }

    public String string(String name) {
        Node n = this.nodeFind(this.getCurrentRoot(), this.currentNS(), name);
        if (n == null) {
            this.missing(name);
        }
        return this.textFrom(n);
    }

    public String string(String name, int maxlen) {
        String val;
        Node n = this.nodeFind(this.getCurrentRoot(), this.currentNS(), name);
        if (n == null) {
            this.missing(name);
        }
        if ((val = this.textFrom(n)).length() > maxlen) {
            val = val.substring(0, maxlen);
        }
        return val;
    }

    public String string(String name, String dflt) {
        String res = this.findStringNode(name);
        return res == null ? dflt : res;
    }

    public String string(String name, String dflt, int maxlen) {
        String res = this.findStringNode(name);
        if (res == null) {
            res = dflt;
        }
        if (res != null && res.length() > maxlen) {
            res = res.substring(0, maxlen);
        }
        return res;
    }

    public String oneOf(String name, String ... list) {
        String value = this.string(name, null);
        for (String pv : list) {
            if (pv == null) {
                if (value != null) continue;
                return null;
            }
            if (!pv.equals(value)) continue;
            return value;
        }
        this.invalid(name, value);
        return null;
    }

    public Date dateOnly(String name) {
        try {
            return W3CSchemaCoder.decodeDate(this.string(name)).getTime();
        }
        catch (W3CEncodingException x) {
            x.setLocation(this.createLocation(name));
            throw x;
        }
    }

    public Date dateOnly(String name, Date deflt) {
        String s = this.string(name, null);
        if (s == null || s.length() == 0) {
            return deflt;
        }
        try {
            return W3CSchemaCoder.decodeDate(s).getTime();
        }
        catch (W3CEncodingException x) {
            x.setLocation(this.createLocation(name));
            throw x;
        }
    }

    public Date dateTime(String name) {
        try {
            return W3CSchemaCoder.decodeDateTime(this.string(name)).getTime();
        }
        catch (W3CEncodingException x) {
            x.setLocation(this.createLocation(name));
            throw x;
        }
    }

    public Node getCurrentRoot() {
        if (this.m_currentRoot == null) {
            throw new IllegalStateException("The current root node is undefined.");
        }
        return this.m_currentRoot;
    }

    private String currentNS() {
        if (this.m_defaultNamespace == null) {
            throw new IllegalStateException("No namespace to use for nodes known");
        }
        return this.m_defaultNamespace;
    }

    public boolean selectNode(String name) {
        Node nd = this.nodeFind(this.getCurrentRoot(), this.currentNS(), name);
        if (nd == null) {
            return false;
        }
        this.m_currentRoot = nd;
        return true;
    }

    public void into(String name) {
        if (!this.selectNode(name)) {
            this.missing(name);
        }
    }

    public void up(int count) {
        while (count-- > 0) {
            this.m_currentRoot = this.getCurrentRoot().getParentNode();
        }
    }

    public void up() {
        this.up(1);
    }

    public Iterable<DOMDecoder> list(String name) {
        Node nd = this.nodeFind(this.getCurrentRoot(), this.currentNS(), name);
        if (nd == null) {
            return EMPTY_ITERATOR;
        }
        return new DOMNodeIterator(this, nd);
    }

    public Iterable<DOMDecoder> list(String name, String childNodeName) {
        Node nd = this.nodeFind(this.getCurrentRoot(), this.currentNS(), name);
        if (nd == null) {
            return EMPTY_ITERATOR;
        }
        return new DOMNodeIterator(this, nd, childNodeName, null, true);
    }

    public Iterable<DOMDecoder> getChildIterator() {
        return new DOMNodeIterator(this, this.m_currentRoot);
    }

    public Node nodeFind(Node rn, String ns, String name) {
        NodeList nl = rn.getChildNodes();
        Node fn = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!name.equals(n.getLocalName()) || !ns.equals(n.getNamespaceURI()) || n.getNodeType() != 1) continue;
            if (fn != null) {
                throw new W3CEncodingException(name + ": duplicate instance within " + rn.getNodeName());
            }
            fn = nl.item(i);
        }
        return fn;
    }

    public Node nodeGet(Node rn, String ns, String name) {
        Node n = this.nodeFind(rn, ns, name);
        if (n == null) {
            throw new W3CEncodingException(name + "@" + ns + ": node not found.");
        }
        return n;
    }

    public String textFrom_untrimmed(Node n) {
        StringBuilder sb = null;
        String res = null;
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node cn = nl.item(i);
            String txt = cn.getNodeValue();
            if (txt == null) continue;
            if (res == null) {
                res = txt;
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(txt.length() + res.length() + 100);
                sb.append(res);
            }
            sb.append(txt);
        }
        return sb != null ? sb.toString() : res;
    }

    public String textFrom(Node n) {
        String v = this.textFrom_untrimmed(n);
        return v == null ? null : v.trim();
    }

    public String getEncodingNamespace() {
        return this.m_encodingNamespace;
    }

    public void setEncodingNamespace(String encodingNamespace) {
        this.m_encodingNamespace = encodingNamespace;
    }

    public String getDefaultNamespace() {
        return this.m_defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.m_defaultNamespace = defaultNamespace;
    }

    public void setCurrentRoot(Node currentRoot) {
        this.m_currentRoot = currentRoot;
    }
}

