/*
 * Decompiled with CFR 0.152.
 */
package to.etc.xml;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultErrorHandler
implements ErrorHandler {
    private StringBuilder m_xmlerr_sb = new StringBuilder();
    private boolean m_errors;

    private void genErr(SAXParseException exception, String type) {
        String id;
        if (this.m_xmlerr_sb.length() > 0) {
            this.m_xmlerr_sb.append("\n");
        }
        if ((id = exception.getPublicId()) == null || id.length() == 0) {
            id = exception.getPublicId();
        }
        if (id == null || id.length() == 0) {
            id = "unknown-source";
        }
        this.m_xmlerr_sb.append(id);
        this.m_xmlerr_sb.append('(');
        this.m_xmlerr_sb.append(Integer.toString(exception.getLineNumber()));
        this.m_xmlerr_sb.append(':');
        this.m_xmlerr_sb.append(Integer.toString(exception.getColumnNumber()));
        this.m_xmlerr_sb.append(") ");
        this.m_xmlerr_sb.append(type);
        this.m_xmlerr_sb.append(":");
        this.m_xmlerr_sb.append(exception.getMessage());
    }

    @Override
    public final void warning(SAXParseException exception) throws SAXException {
        this.genErr(exception, "warning");
    }

    @Override
    public final void error(SAXParseException exception) throws SAXException {
        this.m_errors = true;
        this.genErr(exception, "error");
    }

    @Override
    public final void fatalError(SAXParseException exception) throws SAXException {
        this.m_errors = true;
        this.genErr(exception, "fatal");
    }

    public String getErrors() {
        return this.m_xmlerr_sb.toString();
    }

    public boolean hasErrors() {
        return this.m_errors;
    }
}

