/*
 * Decompiled with CFR 0.152.
 */
package to.etc.xml;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.Node;
import to.etc.xml.AttrSelector;
import to.etc.xml.ElementSelector;
import to.etc.xml.IndexedSelector;
import to.etc.xml.PathSelector;
import to.etc.xml.RootSelector;
import to.etc.xml.TextSelector;

public class PathExpression {
    private PathSelector[] m_path;
    private String m_s;

    private PathExpression(PathSelector[] par, String s) {
        this.m_s = s;
        this.m_path = par;
    }

    public static PathExpression getExpression(String s) throws Exception {
        ArrayList<PathSelector> al = new ArrayList<PathSelector>();
        if (s.startsWith("/")) {
            s = s.substring(1);
            al.add(new RootSelector());
        }
        StringTokenizer st = new StringTokenizer(s, "/");
        while (st.hasMoreTokens()) {
            String sel = st.nextToken();
            if (sel.length() == 0) continue;
            al.add(PathExpression.decodeSelector(sel));
        }
        return new PathExpression(al.toArray(new PathSelector[al.size()]), s);
    }

    public String toString() {
        return this.m_s;
    }

    private static PathSelector decodeSelector(String s) throws Exception {
        int pos = s.indexOf(91);
        if (pos != -1) {
            int ix;
            int epos = s.lastIndexOf(93);
            if (epos < pos) {
                throw new IllegalStateException("The selector " + s + " is invalid (bad [] placement)");
            }
            if (epos != s.length() - 1) {
                throw new IllegalStateException("The '[]' index selector MUST be the last thing in a selector string");
            }
            String b = s.substring(pos + 1, epos);
            try {
                ix = Integer.parseInt(b);
            }
            catch (Exception x) {
                throw new IllegalStateException("The selector " + s + " has an invalid number in the index expression");
            }
            String el = s.substring(0, pos);
            if (el.startsWith("@")) {
                throw new IllegalStateException("An attribute cannot be used with an indexing selector: attributes are unique, Einstein!");
            }
            return new IndexedSelector(el, ix);
        }
        if (s.equalsIgnoreCase("#text")) {
            return new TextSelector();
        }
        if (s.startsWith("@")) {
            return new AttrSelector(s.substring(1));
        }
        return new ElementSelector(s);
    }

    public final Node getNode(Node root, Node parent, StringBuffer error) throws Exception {
        for (int i = 0; i < this.m_path.length; ++i) {
            PathSelector ps = this.m_path[i];
            Node n = ps.select(root, parent);
            if (n == null) {
                error.setLength(0);
                error.append("No match for selector '");
                for (int j = 0; j <= i; ++j) {
                    if (j > 0) {
                        error.append("/");
                    }
                    error.append(this.m_path[j].toString());
                }
                error.append("'");
                return null;
            }
            parent = n;
        }
        return parent;
    }
}

