/*
 * Decompiled with CFR 0.152.
 */
package to.etc.xml;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import to.etc.util.DateUtil;
import to.etc.xml.W3CEncodingException;

public class W3CSchemaCoder {
    private static final ThreadLocal<GregorianCalendar> m_calendar = new ThreadLocal();
    private static final ThreadLocal<MiniParser> m_parser = new ThreadLocal();
    private static final byte[] BASE64MAP = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    public static String encodeBoolean(boolean val) {
        return val ? "true" : "false";
    }

    public static boolean decodeBoolean(String in) {
        if ("true".equals(in = in.trim().toLowerCase()) || "1".equals(in)) {
            return true;
        }
        if ("false".equals(in) || "0".equals(in)) {
            return false;
        }
        throw new W3CEncodingException("Invalid 'boolean' value", in);
    }

    public static String encodeDouble(double v) {
        return Double.toString(v);
    }

    @Nonnull
    private static GregorianCalendar calendar() {
        GregorianCalendar c = m_calendar.get();
        if (c == null) {
            c = (GregorianCalendar)DateUtil.getCalendar(Locale.US);
            m_calendar.set(c);
        }
        c.setTimeZone(TimeZone.getDefault());
        return c;
    }

    @Nonnull
    private static GregorianCalendar calendar(@Nonnull Date in) {
        GregorianCalendar c = W3CSchemaCoder.calendar();
        c.setTime(in);
        return c;
    }

    private static MiniParser parser() {
        MiniParser mp = m_parser.get();
        if (mp == null) {
            mp = new MiniParser();
            m_parser.set(mp);
        }
        return mp;
    }

    private static MiniParser parser(String txt) {
        MiniParser p = W3CSchemaCoder.parser();
        p.init(txt.trim());
        return p;
    }

    public static String encodeDateTimeToUTC(Date in, TimeZone sourceZone) {
        GregorianCalendar cal;
        if (sourceZone != null) {
            cal = W3CSchemaCoder.calendar();
            cal.setTime(in);
            long utc = cal.getTimeInMillis();
            ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("UTC"));
            cal.setTimeInMillis(utc);
        } else {
            cal = W3CSchemaCoder.calendar();
            cal.setTime(in);
        }
        StringBuilder sb = new StringBuilder(32);
        int yr = cal.get(1);
        if (yr < 0) {
            sb.append('-');
        }
        W3CSchemaCoder.appendInt(sb, yr, 4);
        sb.append('-');
        W3CSchemaCoder.appendInt(sb, cal.get(2) + 1, 2);
        sb.append('-');
        W3CSchemaCoder.appendInt(sb, cal.get(5), 2);
        sb.append('T');
        W3CSchemaCoder.appendInt(sb, cal.get(11), 2);
        sb.append(':');
        W3CSchemaCoder.appendInt(sb, cal.get(12), 2);
        sb.append(':');
        W3CSchemaCoder.appendInt(sb, cal.get(13), 2);
        int ms = cal.get(14);
        if (ms != 0) {
            sb.append('.');
            W3CSchemaCoder.appendInt(sb, ms, 4);
        }
        return sb.toString();
    }

    public static String encodeDateTime(Date in, TimeZone timezone) {
        GregorianCalendar cal = W3CSchemaCoder.calendar();
        if (timezone != null) {
            ((Calendar)cal).setTimeZone(timezone);
        }
        cal.setTime(in);
        StringBuilder sb = new StringBuilder(32);
        int yr = cal.get(1);
        if (yr < 0) {
            sb.append('-');
        }
        W3CSchemaCoder.appendInt(sb, yr, 4);
        sb.append('-');
        W3CSchemaCoder.appendInt(sb, cal.get(2) + 1, 2);
        sb.append('-');
        W3CSchemaCoder.appendInt(sb, cal.get(5), 2);
        sb.append('T');
        W3CSchemaCoder.appendInt(sb, cal.get(11), 2);
        sb.append(':');
        W3CSchemaCoder.appendInt(sb, cal.get(12), 2);
        sb.append(':');
        W3CSchemaCoder.appendInt(sb, cal.get(13), 2);
        int ms = cal.get(14);
        if (ms != 0) {
            sb.append('.');
            W3CSchemaCoder.appendInt(sb, ms, 4);
        }
        W3CSchemaCoder.addTimezone(sb, timezone, in.getTime());
        return sb.toString();
    }

    private static void addTimezone(StringBuilder sb, TimeZone timezone, long atdate) {
        int offset;
        if (timezone == null) {
            return;
        }
        int n = offset = atdate != -1L ? timezone.getOffset(atdate) : timezone.getRawOffset();
        if (offset == 0) {
            sb.append('Z');
        } else {
            if (offset > 0) {
                sb.append('+');
            } else {
                sb.append('-');
                offset = -offset;
            }
            W3CSchemaCoder.appendInt(sb, (offset /= 60000) / 60, 2);
            sb.append(':');
            W3CSchemaCoder.appendInt(sb, offset % 60, 2);
        }
    }

    public static String encodeTime(Date in, TimeZone timezone) {
        GregorianCalendar cal = W3CSchemaCoder.calendar(in);
        StringBuilder sb = new StringBuilder(32);
        W3CSchemaCoder.appendInt(sb, cal.get(11), 2);
        sb.append(':');
        W3CSchemaCoder.appendInt(sb, cal.get(12), 2);
        sb.append(':');
        W3CSchemaCoder.appendInt(sb, cal.get(13), 2);
        int ms = cal.get(14);
        if (ms != 0) {
            sb.append('.');
            W3CSchemaCoder.appendInt(sb, ms, 4);
        }
        W3CSchemaCoder.addTimezone(sb, timezone, in.getTime());
        return sb.toString();
    }

    public static String encodeDate(Date in, TimeZone timezone) {
        GregorianCalendar cal = W3CSchemaCoder.calendar(in);
        StringBuilder sb = new StringBuilder(32);
        int yr = cal.get(1);
        if (yr < 0) {
            sb.append('-');
        }
        W3CSchemaCoder.appendInt(sb, yr, 4);
        sb.append('-');
        W3CSchemaCoder.appendInt(sb, cal.get(2) + 1, 2);
        sb.append('-');
        W3CSchemaCoder.appendInt(sb, cal.get(5), 2);
        W3CSchemaCoder.addTimezone(sb, timezone, in.getTime());
        return sb.toString();
    }

    private static final void appendInt(StringBuilder sb, int val, int minlen) {
        String s = Integer.toString(val);
        int len = s.length();
        while (len++ < minlen) {
            sb.append('0');
        }
        sb.append(s);
    }

    public static final String encodeInteger(long value) {
        return Long.toString(value);
    }

    public static final String encodeInteger(int value) {
        return Integer.toString(value);
    }

    public static final String encodeDecimal(BigDecimal value) {
        return value.toString();
    }

    public static final GregorianCalendar decodeDate(String in) {
        try {
            MiniParser p = W3CSchemaCoder.parser(in);
            GregorianCalendar cal = W3CSchemaCoder.calendar();
            cal.setLenient(false);
            W3CSchemaCoder.parseDate(cal, p, true);
            TimeZone tz = W3CSchemaCoder.parseTimeZone(p);
            if (tz != null) {
                cal.setTimeZone(tz);
            }
            DateUtil.clearTime(cal);
            return cal;
        }
        catch (W3CEncodingException x) {
            x.setReason("Invalid xsd:date: " + x.getReason());
            throw x;
        }
    }

    public static final GregorianCalendar decodeDateTime(String in) {
        try {
            MiniParser p = W3CSchemaCoder.parser(in);
            GregorianCalendar cal = W3CSchemaCoder.calendar();
            cal.setLenient(false);
            W3CSchemaCoder.parseDate(cal, p, true);
            if (!p.curIs("T") && !p.curIs("t")) {
                throw new W3CEncodingException("Missing 'T' in dateTime", in);
            }
            W3CSchemaCoder.parseTime(cal, p);
            TimeZone tz = W3CSchemaCoder.parseTimeZone(p);
            if (tz != null) {
                cal.setTimeZone(tz);
            }
            return cal;
        }
        catch (W3CEncodingException x) {
            x.setReason("Invalid xsd:dateTime: " + x.getReason());
            throw x;
        }
    }

    public static final GregorianCalendar decodeDateTime_iso8601(String in) {
        try {
            MiniParser p = W3CSchemaCoder.parser(in);
            GregorianCalendar cal = W3CSchemaCoder.calendar();
            W3CSchemaCoder.parseDate(cal, p, false);
            if (!p.curIs("T") && !p.curIs("t")) {
                throw new W3CEncodingException("Missing 'T' in dateTime", in);
            }
            W3CSchemaCoder.parseTime(cal, p);
            return cal;
        }
        catch (W3CEncodingException x) {
            x.setReason("Invalid iso8601 datetime: " + x.getReason());
            throw x;
        }
    }

    public static final GregorianCalendar decodeTime(String in) {
        try {
            GregorianCalendar cal = W3CSchemaCoder.calendar();
            MiniParser p = W3CSchemaCoder.parser(in);
            W3CSchemaCoder.parseTime(cal, p);
            TimeZone tz = W3CSchemaCoder.parseTimeZone(p);
            if (tz != null) {
                cal.setTimeZone(tz);
            }
            return cal;
        }
        catch (W3CEncodingException x) {
            x.setReason("Invalid xsd:time: " + x.getReason());
            throw x;
        }
    }

    private static void parseDate(Calendar cal, MiniParser p, boolean dashed) {
        int year = W3CSchemaCoder.parseYear(p);
        if (dashed) {
            p.require("-");
        }
        int month = p.parseFixedInt(2);
        if (dashed) {
            p.require("-");
        }
        int day = p.parseFixedInt(2);
        DateUtil.setDate(cal, year, month - 1, day);
    }

    private static void parseTime(Calendar cal, MiniParser p) {
        double frac;
        int hour = p.parseFixedInt(2);
        p.require(":");
        int min = p.parseFixedInt(2);
        p.require(":");
        int sec = p.parseFixedInt(2);
        int msec = 0;
        if (p.curIs(".") && (msec = (int)(1000.0 * (frac = p.parseFraction()))) > 1000) {
            msec = 999;
        }
        DateUtil.setTime(cal, hour, min, sec, msec);
    }

    private static int parseYear(MiniParser p) {
        int year;
        p.skipWs();
        int sign = 1;
        if (p.curIs("-")) {
            sign = -1;
        }
        if ((year = p.parseFixedInt(4)) == 0) {
            throw new W3CEncodingException("'yyyy' date fragment cannot be zeroes.", p.getInput());
        }
        return year * sign;
    }

    private static TimeZone parseTimeZone(MiniParser p) {
        int sign;
        if (p.atEnd()) {
            return null;
        }
        if (p.curIs("Z") || p.curIs("z")) {
            return TimeZone.getTimeZone("UTC");
        }
        if (p.curIs("+")) {
            sign = 1;
        } else if (p.curIs("-")) {
            sign = -1;
        } else {
            throw new W3CEncodingException("Missing +/- in timezone", p.getInput());
        }
        int hh = p.parseFixedInt(2);
        p.require(":");
        int mm = p.parseFixedInt(2);
        return new SimpleTimeZone((hh * 60 + mm) * 60 * 1000, (sign < 0 ? 45 : 43) + hh + ":" + mm);
    }

    public static final void encodeBase64(Writer out, byte[] data) throws IOException {
        if (data == null) {
            return;
        }
        int olen = 0;
        char[] dest = new char[512];
        int sidx = 0;
        int didx = 0;
        while (sidx < data.length - 2) {
            byte v1 = data[sidx++];
            byte v2 = data[sidx++];
            byte v3 = data[sidx++];
            dest[didx++] = (char)BASE64MAP[v1 >> 2 & 0x3F];
            dest[didx++] = (char)BASE64MAP[v1 << 4 & 0x30 | v2 >> 4 & 0xF];
            dest[didx++] = (char)BASE64MAP[v2 << 2 & 0x3C | v3 >> 6 & 3];
            dest[didx++] = (char)BASE64MAP[v3 & 0x3F];
            if (didx < dest.length) continue;
            out.write(dest);
            olen += didx;
            didx = 0;
        }
        if (didx > 0) {
            out.write(dest, 0, didx);
            olen += didx;
            didx = 0;
        }
        if (sidx < data.length) {
            dest[didx++] = (char)BASE64MAP[data[sidx] >>> 2 & 0x3F];
            ++olen;
            if (sidx < data.length - 1) {
                dest[didx++] = (char)BASE64MAP[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
                dest[didx++] = (char)BASE64MAP[data[sidx + 1] << 2 & 0x3F];
                olen += 2;
            } else {
                dest[didx++] = (char)BASE64MAP[data[sidx] << 4 & 0x3F];
            }
        }
        int flen = (data.length + 2) / 3 * 4;
        while (true) {
            int n = ++olen;
            ++olen;
            if (n >= flen) break;
            dest[didx++] = 61;
        }
        if (didx > 0) {
            out.write(dest, 0, didx);
            olen += didx;
            didx = 0;
        }
    }

    private static class MiniParser {
        private String m_input;
        private int m_ix;
        private int m_len;

        public void init(String s) {
            this.m_input = s;
            this.m_ix = 0;
            this.m_len = s.length();
        }

        public String getInput() {
            return this.m_input;
        }

        public void skipWs() {
            while (this.m_ix < this.m_len) {
                char c = this.m_input.charAt(this.m_ix);
                if (!Character.isWhitespace(c)) {
                    return;
                }
                ++this.m_ix;
            }
        }

        public boolean atEnd() {
            return this.m_ix >= this.m_len;
        }

        public boolean curIs(String s) {
            if (this.m_ix + s.length() > this.m_len || s.length() == 0) {
                return false;
            }
            if (this.m_input.charAt(this.m_ix) != s.charAt(0)) {
                return false;
            }
            int i = s.length();
            while (--i >= 1) {
                if (this.m_input.charAt(this.m_ix + i) == s.charAt(i)) continue;
                return false;
            }
            this.m_ix += s.length();
            return true;
        }

        public void require(String s) {
            if (!this.curIs(s)) {
                throw new W3CEncodingException("Missing '" + s + "'", this.m_input);
            }
        }

        public int parseFixedInt(int ndigits) {
            if (this.m_ix + ndigits > this.m_len) {
                throw new W3CEncodingException("Input too short for " + ndigits + " digits", this.m_input);
            }
            int value = 0;
            while (ndigits-- > 0) {
                char c;
                if (!Character.isDigit(c = this.m_input.charAt(this.m_ix++))) {
                    throw new W3CEncodingException("Invalid digit: '" + c + "'", this.m_input);
                }
                value = value * 10 + (c - 48);
            }
            return value;
        }

        public double parseFraction() {
            double value = 0.0;
            int nc = 0;
            double fix = 0.1;
            while (this.m_ix < this.m_len) {
                char c = this.m_input.charAt(this.m_ix);
                if (!Character.isDigit(c)) {
                    if (nc == 0) {
                        throw new W3CEncodingException("Missing digits in integer number", this.m_input);
                    }
                    return value;
                }
                value += fix * (double)(c - 48);
                fix /= 10.0;
                ++nc;
                ++this.m_ix;
            }
            if (nc == 0) {
                throw new W3CEncodingException("Missing digits in integer number", this.m_input);
            }
            return value;
        }
    }
}

