/*
 * Decompiled with CFR 0.152.
 */
package to.etc.xml;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import to.etc.util.IndentWriter;
import to.etc.util.StringTool;
import to.etc.xml.DomTools;
import to.etc.xml.W3CSchemaCoder;

public class XmlWriter
extends IndentWriter {
    private int m_tag_lvl = 1;
    private String[] m_tag_ar = new String[15];

    public XmlWriter() {
    }

    public XmlWriter(Writer w) {
        this.init(w, 0);
    }

    @Override
    public void init(Writer w, int taglvl) {
        super.init(w, taglvl);
        this.m_tag_lvl = 0;
    }

    public void wraw(String s) throws IOException {
        super.write(s);
    }

    public void writeAttr(String name, String value) throws IOException {
        this.print(name);
        if (value == null) {
            value = "";
        }
        this.print("=\"");
        this.print(StringTool.xmlStringize(value));
        this.print("\"");
    }

    public void cdata(String s) throws IOException {
        if (s == null) {
            this.writeRaw("(dbnull)");
            return;
        }
        int sl = s.length();
        block6: for (int ix = 0; ix < sl; ++ix) {
            int runstart = ix;
            char c = '\u0000';
            while (ix < sl && (c = s.charAt(ix)) != '<' && c != '>' && c != '&' && c != '\n') {
                ++ix;
            }
            if (ix > runstart) {
                this.writeRaw(s, runstart, ix - runstart);
                if (ix >= sl) {
                    return;
                }
            }
            switch (c) {
                case '>': {
                    this.writeRaw("&gt;");
                    continue block6;
                }
                case '<': {
                    this.writeRaw("&lt;");
                    continue block6;
                }
                case '&': {
                    this.writeRaw("&amp;");
                    continue block6;
                }
                case '\n': {
                    this.println();
                }
            }
        }
    }

    public void unclosed() {
        this.dec();
        if (this.m_tag_lvl > 0) {
            --this.m_tag_lvl;
        }
    }

    public void tag(String tn, String attrs) throws IOException {
        this.wraw("<" + tn);
        if (attrs.length() >= 1 && attrs.charAt(0) != '>') {
            this.wraw(" ");
        }
        this.wraw(attrs);
        ++this.m_tag_lvl;
        this.inc();
        this.m_tag_ar[this.m_tag_lvl] = tn;
    }

    public void tagnl(String tn, String ... attrvalueset) throws IOException {
        this.tag(tn, attrvalueset);
        this.wraw("\n");
    }

    public void tag(String tn, Object ... ar) throws Exception {
        this.wraw("<" + tn);
        ArrayList avs = new ArrayList();
        for (int i = 0; i < ar.length; i += 2) {
            String attr = (String)ar[i];
            Object val = ar[i + 1];
            if (val == null) continue;
            this.wraw(" ");
            this.wraw(attr);
            this.wraw("=\"");
            String s = this.renderValue(val);
            this.wraw(StringTool.xmlStringize(s));
            this.wraw("\"");
        }
        this.wraw(">");
        ++this.m_tag_lvl;
        this.inc();
        this.m_tag_ar[this.m_tag_lvl] = tn;
    }

    private String renderValue(Object val) throws Exception {
        if (null == val) {
            return "";
        }
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Date) {
            return W3CSchemaCoder.encodeDateTime((Date)val, null);
        }
        if (val instanceof Boolean) {
            return W3CSchemaCoder.encodeBoolean((Boolean)val);
        }
        return String.valueOf(val);
    }

    public void tag(String tn, String ... attrvalueset) throws IOException {
        this.wraw("<" + tn);
        for (int i = 0; i < attrvalueset.length; i += 2) {
            this.wraw(" ");
            this.wraw(attrvalueset[i]);
            this.wraw("=\"");
            if (i + 1 < attrvalueset.length) {
                this.wraw(StringTool.xmlStringize(attrvalueset[i + 1]));
            }
            this.wraw("\"");
        }
        this.wraw(">");
        ++this.m_tag_lvl;
        this.inc();
        this.m_tag_ar[this.m_tag_lvl] = tn;
    }

    public void startTag(String tn) throws IOException {
        this.wraw("<" + tn);
        ++this.m_tag_lvl;
        this.inc();
        this.m_tag_ar[this.m_tag_lvl] = tn;
    }

    public void attr(String name, String value) throws IOException {
        this.wraw(" ");
        this.wraw(name);
        this.wraw("=\"");
        this.wraw(StringTool.xmlStringize(value));
        this.wraw("\"");
    }

    public void attrForDomApi(String name, String value) throws IOException {
        this.wraw(" ");
        this.wraw(name);
        this.wraw("=\"");
        this.wraw(StringTool.xmlStringizeForDomApi(value));
        this.wraw("\"");
    }

    public void attr(String name, Object value) throws Exception {
        if (null == value) {
            return;
        }
        this.wraw(" ");
        this.wraw(name);
        this.wraw("=\"");
        this.wraw(StringTool.xmlStringize(this.renderValue(value)));
        this.wraw("\"");
    }

    public void endTag(boolean complete) throws IOException {
        if (complete) {
            this.wraw("/>");
            --this.m_tag_lvl;
        } else {
            this.wraw(">");
        }
    }

    public void tagonly(String tn, String ... attrvalueset) throws IOException {
        this.wraw("<" + tn);
        for (int i = 0; i < attrvalueset.length; i += 2) {
            if (attrvalueset[i + 1] == null) continue;
            this.wraw(" ");
            this.wraw(attrvalueset[i]);
            this.wraw("=\"");
            this.wraw(StringTool.xmlStringize(attrvalueset[i + 1]));
            this.wraw("\"");
        }
        this.wraw(" />\n");
    }

    public void tagonlynl(String tn, String ... attrvalueset) throws IOException {
        this.tagonly(tn, attrvalueset);
    }

    public void tag(String tn) throws IOException {
        this.tag(tn, ">\n");
    }

    public void tagfull(String tn) throws IOException {
        this.wraw("<");
        this.wraw(tn);
        this.wraw("/>\n");
    }

    public void tagfull(String tn, String text) throws IOException {
        this.wraw("<");
        this.wraw(tn);
        this.wraw(">");
        if (text == null) {
            text = "(dbnull)";
        }
        this.cdata(text);
        this.wraw("</");
        this.wraw(tn);
        this.wraw(">\n");
    }

    public void tagfull(String tn, Date dt) throws IOException {
        this.wraw("<");
        this.wraw(tn);
        this.wraw(">");
        if (dt == null) {
            this.cdata("(dbnull)");
        } else {
            this.cdata(DomTools.dateEncode(dt));
        }
        this.wraw("</");
        this.wraw(tn);
        this.wraw(">\n");
    }

    public void tagfull(String tn, String attrs, String text) throws IOException {
        this.wraw("<");
        this.wraw(tn);
        if (attrs.length() >= 1) {
            this.wraw(" ");
            this.wraw(attrs);
        }
        this.wraw(">");
        this.cdata(text);
        this.wraw("</");
        this.wraw(tn);
        this.wraw(">\n");
    }

    public void tagfull(String tn, int val) throws IOException {
        this.tagfull(tn, Integer.toString(val));
    }

    public void tagfull(String tn, long val) throws IOException {
        this.tagfull(tn, Long.toString(val));
    }

    public void tagfull(String tn, Number val) throws IOException {
        if (val == null) {
            this.cdata("(dbnull)");
        } else {
            this.tagfull(tn, val.toString());
        }
    }

    public void tagfull(String tn, boolean onoff) throws IOException {
        this.tagfull(tn, onoff ? "true" : "false");
    }

    public void tagfull(String tn, Boolean onoff) throws IOException {
        if (onoff != null) {
            this.tagfull(tn, (boolean)onoff);
        }
    }

    public void tagendnl() throws IOException {
        --this.m_tag_lvl;
        this.dec();
        this.wraw("</" + this.m_tag_ar[this.m_tag_lvl + 1] + ">\n");
    }

    @Override
    public void close() throws IOException {
        while (this.m_tag_lvl > 0) {
            this.tagendnl();
        }
        super.close();
    }

    public void dumpBean(Object o) throws IOException {
        Class<?> cl = o.getClass();
        Method[] mar = cl.getMethods();
        int i = mar.length;
        while (--i >= 0) {
            this.handleMethod(o, mar[i]);
        }
    }

    private void handleMethod(Object o, Method m) throws IOException {
        String name = m.getName();
        if (!name.startsWith("get")) {
            return;
        }
        String res = null;
        try {
            Object val = m.invoke(o, (Object[])null);
            res = val == null ? "(null)" : val.toString();
        }
        catch (Exception x) {
            res = x.toString();
        }
        name = name.substring(3, 4).toLowerCase() + name.substring(4);
        this.tagfull(name, res);
    }
}

