/*
 * Decompiled with CFR 0.152.
 */
package tokyo.baseballyama.kvelte;

import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.File;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tokyo.baseballyama.kvelte.Command;
import tokyo.baseballyama.kvelte.KvelteBuilder;
import tokyo.baseballyama.kvelte.KvelteException;
import tokyo.baseballyama.kvelte.RollupConfigFileWriter;
import tokyo.baseballyama.kvelte.SvelteBuilder;
import tokyo.baseballyama.kvelte.SvelteFilePaths;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J4\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ltokyo/baseballyama/kvelte/Kvelte;", "", "()V", "defaultLang", "", "defaultTitle", "enableSSR", "", "isProduction", "rollupConfigFileWriter", "Ltokyo/baseballyama/kvelte/RollupConfigFileWriter;", "svelteFileMap", "", "svelteProjectDir", "Ljava/io/File;", "getSvelteProjectAbsolutePath", "svelteProjectDirPath", "load", "lang", "title", "rootSvelteFilePath", "props", "", "setDefaultLang", "", "setDefaultTitle", "setEnableSSR", "setIsProduction", "setSvelteProjectDir", "path", "kvelte"})
public final class Kvelte {
    @NotNull
    public static final Kvelte INSTANCE = new Kvelte();
    @Nullable
    private static File svelteProjectDir;
    private static boolean enableSSR;
    private static boolean isProduction;
    @NotNull
    private static String defaultLang;
    @NotNull
    private static String defaultTitle;
    @Nullable
    private static RollupConfigFileWriter rollupConfigFileWriter;
    @NotNull
    private static final Map<String, String> svelteFileMap;

    private Kvelte() {
    }

    public final void setSvelteProjectDir(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = svelteProjectDir = this.getSvelteProjectAbsolutePath(path);
        Intrinsics.checkNotNull((Object)file);
        rollupConfigFileWriter = new RollupConfigFileWriter(file, isProduction);
    }

    public final void setEnableSSR(boolean enableSSR) {
        Kvelte.enableSSR = enableSSR;
    }

    public final void setIsProduction(boolean isProduction) {
        Kvelte.isProduction = isProduction;
        File file = svelteProjectDir;
        Intrinsics.checkNotNull((Object)file);
        rollupConfigFileWriter = new RollupConfigFileWriter(file, Kvelte.isProduction);
    }

    public final void setDefaultLang(@NotNull String defaultLang) {
        Intrinsics.checkNotNullParameter((Object)defaultLang, (String)"defaultLang");
        Kvelte.defaultLang = defaultLang;
    }

    public final void setDefaultTitle(@NotNull String defaultTitle) {
        Intrinsics.checkNotNullParameter((Object)defaultTitle, (String)"defaultTitle");
        Kvelte.defaultTitle = defaultTitle;
    }

    @NotNull
    public final String load(@NotNull String lang, @NotNull String title, @NotNull String rootSvelteFilePath, @NotNull Map<String, ?> props) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)rootSvelteFilePath, (String)"rootSvelteFilePath");
        Intrinsics.checkNotNullParameter(props, (String)"props");
        if (svelteProjectDir == null) {
            throw new KvelteException("should set value to " + Kvelte.class.getName() + '.' + "svelteProjectDir" + " before calling this method");
        }
        if (!svelteFileMap.containsKey(rootSvelteFilePath)) {
            String string;
            if (enableSSR) {
                RollupConfigFileWriter rollupConfigFileWriter = Kvelte.rollupConfigFileWriter;
                Intrinsics.checkNotNull((Object)rollupConfigFileWriter);
                File ssrOutDir = rollupConfigFileWriter.write(rootSvelteFilePath, false);
                File file = svelteProjectDir;
                Intrinsics.checkNotNull((Object)file);
                SvelteFilePaths ssr = SvelteBuilder.INSTANCE.build(file, ssrOutDir);
                RollupConfigFileWriter rollupConfigFileWriter2 = Kvelte.rollupConfigFileWriter;
                Intrinsics.checkNotNull((Object)rollupConfigFileWriter2);
                rollupConfigFileWriter2.restore();
                String[] stringArray = new String[2];
                stringArray[0] = "node";
                String string2 = ssr.getJs().getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ssr.js.absolutePath");
                stringArray[1] = string2;
                string = Command.INSTANCE.execute(stringArray).getStdout();
            } else {
                string = "";
            }
            String ssrHTML = string;
            RollupConfigFileWriter rollupConfigFileWriter = Kvelte.rollupConfigFileWriter;
            Intrinsics.checkNotNull((Object)rollupConfigFileWriter);
            File domOutDir = rollupConfigFileWriter.write(rootSvelteFilePath, true);
            File file = svelteProjectDir;
            Intrinsics.checkNotNull((Object)file);
            SvelteFilePaths dom = SvelteBuilder.INSTANCE.build(file, domOutDir);
            RollupConfigFileWriter rollupConfigFileWriter3 = Kvelte.rollupConfigFileWriter;
            Intrinsics.checkNotNull((Object)rollupConfigFileWriter3);
            rollupConfigFileWriter3.restore();
            String js = FilesKt.readText$default((File)dom.getJs(), null, (int)1, null);
            String css = FilesKt.readText$default((File)dom.getCss(), null, (int)1, null);
            String html = KvelteBuilder.INSTANCE.build(lang, title, ssrHTML, js, css);
            svelteFileMap.put(rootSvelteFilePath, html);
        }
        String string = svelteFileMap.get(rootSvelteFilePath);
        Intrinsics.checkNotNull((Object)string);
        String string3 = ExtensionsKt.jacksonObjectMapper().writeValueAsString(props);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jacksonObjectMapper().writeValueAsString(props)");
        return StringsKt.replace$default((String)string, (String)"__KVELTE_PROPS__", (String)string3, (boolean)false, (int)4, null);
    }

    public static /* synthetic */ String load$default(Kvelte kvelte, String string, String string2, String string3, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = defaultLang;
        }
        if ((n & 2) != 0) {
            string2 = defaultTitle;
        }
        return kvelte.load(string, string2, string3, map);
    }

    private final File getSvelteProjectAbsolutePath(String svelteProjectDirPath) {
        File dir;
        File file;
        if (StringsKt.startsWith$default((String)svelteProjectDirPath, (String)"/", (boolean)false, (int)2, null)) {
            file = new File(svelteProjectDirPath);
        } else {
            String abs = new File("").getAbsolutePath();
            file = dir = Paths.get(abs, new String[0]).resolve(svelteProjectDirPath).toFile();
        }
        if (!dir.exists()) {
            throw new KvelteException(Intrinsics.stringPlus((String)"Svelte project does not exists. path: ", (Object)dir.getAbsolutePath()));
        }
        Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
        return dir;
    }

    static {
        enableSSR = true;
        isProduction = true;
        defaultLang = "en";
        defaultTitle = "Hello Kvelte";
        svelteFileMap = new LinkedHashMap();
    }
}

