/*
 * Decompiled with CFR 0.152.
 */
package tokyo.baseballyama.kvelte;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tokyo.baseballyama.kvelte.KvelteException;
import tokyo.baseballyama.kvelte.VirtualFileBuilder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0003H\u0002J\b\u0010\u000e\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\bH\u0002J\u0016\u0010\u0014\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltokyo/baseballyama/kvelte/RollupConfigFileWriter;", "", "svelteProjectDir", "Ljava/io/File;", "isProduction", "", "(Ljava/io/File;Z)V", "originalText", "", "outputFolder", "rollupFile", "buildRollupConfigFile", "rootSvelteFilePath", "dom", "getOutputFolder", "getRollupConfigFile", "readRollupConfigFile", "restore", "", "throwExceptionIfSvelteFileIsNotExists", "write", "Companion", "kvelte"})
public final class RollupConfigFileWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File svelteProjectDir;
    private final boolean isProduction;
    @NotNull
    private final File rollupFile;
    @NotNull
    private final String originalText;
    @NotNull
    private final File outputFolder;
    @NotNull
    private static final String ROLLUP_FILE_NAME = "rollup.config.js";
    @NotNull
    private static final String KVELTE_INPUT = "__KVELTE_INPUT__";
    @NotNull
    private static final String KVELTE_OUTPUT = "__KVELTE_OUTPUT__";
    @NotNull
    private static final String KVELTE_OUTPUT_CSS = "__KVELTE_OUTPUT_CSS__";
    @NotNull
    private static final String KVELTE_GENERATE = "__KVELTE_GENERATE__";
    @NotNull
    private static final String KVELTE_HYDRATABLE = "__KVELTE_HYDRATABLE__";
    @NotNull
    private static final String KVELTE_PRODUCTION = "__KVELTE_PRODUCTION__";
    @NotNull
    public static final String OUTPUT_FILE_NAME_JS = "bundle.js";
    @NotNull
    public static final String OUTPUT_FILE_NAME_JS_SOURCE_MAP = "bundle.js.map";
    @NotNull
    public static final String OUTPUT_FILE_NAME_CSS = "bundle.css";
    @NotNull
    private static final Path outputBaseDir;

    public RollupConfigFileWriter(@NotNull File svelteProjectDir, boolean isProduction) {
        Intrinsics.checkNotNullParameter((Object)svelteProjectDir, (String)"svelteProjectDir");
        this.svelteProjectDir = svelteProjectDir;
        this.isProduction = isProduction;
        this.outputFolder = this.getOutputFolder();
        this.rollupFile = this.getRollupConfigFile(this.svelteProjectDir);
        this.originalText = this.readRollupConfigFile(this.rollupFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File write(@NotNull String rootSvelteFilePath, boolean dom) {
        Intrinsics.checkNotNullParameter((Object)rootSvelteFilePath, (String)"rootSvelteFilePath");
        this.throwExceptionIfSvelteFileIsNotExists(this.svelteProjectDir, rootSvelteFilePath);
        File outDir = FilesKt.resolve((File)FilesKt.resolve((File)this.outputFolder, (String)rootSvelteFilePath), (String)(dom ? "dom" : "ssr"));
        String rollupConfig = this.buildRollupConfigFile(rootSvelteFilePath, dom, outDir);
        Closeable closeable = new FileWriter(this.rollupFile);
        Throwable throwable = null;
        try {
            FileWriter writer = (FileWriter)closeable;
            boolean bl = false;
            Closeable closeable2 = new PrintWriter(new BufferedWriter(writer));
            Throwable throwable2 = null;
            try {
                PrintWriter pw = (PrintWriter)closeable2;
                boolean bl2 = false;
                pw.println(rollupConfig);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return outDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void restore() {
        Closeable closeable = new FileWriter(this.rollupFile);
        Throwable throwable = null;
        try {
            FileWriter writer = (FileWriter)closeable;
            boolean bl = false;
            Closeable closeable2 = new PrintWriter(new BufferedWriter(writer));
            Throwable throwable2 = null;
            try {
                PrintWriter pw = (PrintWriter)closeable2;
                boolean bl2 = false;
                pw.println(this.originalText);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String buildRollupConfigFile(String rootSvelteFilePath, boolean dom, File outputFolder) {
        String virtualFile = VirtualFileBuilder.INSTANCE.build(rootSvelteFilePath, dom);
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)this.originalText, (String)KVELTE_INPUT, (String)virtualFile, (boolean)false, (int)4, null), (String)KVELTE_OUTPUT, (String)('\"' + FilesKt.resolve((File)outputFolder, (String)OUTPUT_FILE_NAME_JS).getAbsolutePath() + '\"'), (boolean)false, (int)4, null), (String)KVELTE_OUTPUT_CSS, (String)"\"bundle.css\"", (boolean)false, (int)4, null), (String)KVELTE_GENERATE, (String)('\"' + (dom ? "dom" : "ssr") + '\"'), (boolean)false, (int)4, null), (String)KVELTE_HYDRATABLE, (String)(dom ? "true" : "false"), (boolean)false, (int)4, null), (String)KVELTE_PRODUCTION, (String)(this.isProduction ? "true" : "false"), (boolean)false, (int)4, null);
    }

    private final void throwExceptionIfSvelteFileIsNotExists(File svelteProjectDir, String rootSvelteFilePath) {
        File file = FilesKt.resolve((File)svelteProjectDir, (String)rootSvelteFilePath);
        if (!file.exists()) {
            throw new KvelteException(Intrinsics.stringPlus((String)"Svelte file does not exists. path: ", (Object)file.getAbsolutePath()));
        }
    }

    private final File getRollupConfigFile(File svelteProjectDir) {
        File file = FilesKt.resolve((File)svelteProjectDir, (String)ROLLUP_FILE_NAME);
        if (!file.exists()) {
            throw new KvelteException(Intrinsics.stringPlus((String)"rollup.config.js does not exists. path: ", (Object)file.getAbsolutePath()));
        }
        return file;
    }

    private final String readRollupConfigFile(File rollupFile) {
        String text = FilesKt.readText$default((File)rollupFile, null, (int)1, null);
        if (StringsKt.indexOf$default((CharSequence)text, (String)KVELTE_INPUT, (int)0, (boolean)false, (int)6, null) == -1) {
            throw new KvelteException("rollup.config.js does not contains __KVELTE_INPUT__");
        }
        if (StringsKt.indexOf$default((CharSequence)text, (String)KVELTE_OUTPUT, (int)0, (boolean)false, (int)6, null) == -1) {
            throw new KvelteException("rollup.config.js does not contains __KVELTE_OUTPUT__");
        }
        if (StringsKt.indexOf$default((CharSequence)text, (String)KVELTE_GENERATE, (int)0, (boolean)false, (int)6, null) == -1) {
            throw new KvelteException("rollup.config.js does not contains __KVELTE_GENERATE__");
        }
        if (StringsKt.indexOf$default((CharSequence)text, (String)KVELTE_HYDRATABLE, (int)0, (boolean)false, (int)6, null) == -1) {
            throw new KvelteException("rollup.config.js does not contains __KVELTE_HYDRATABLE__");
        }
        if (StringsKt.indexOf$default((CharSequence)text, (String)KVELTE_PRODUCTION, (int)0, (boolean)false, (int)6, null) == -1) {
            throw new KvelteException("rollup.config.js does not contains __KVELTE_PRODUCTION__");
        }
        return text;
    }

    private final File getOutputFolder() {
        File file;
        File it = file = Files.createTempDirectory(outputBaseDir, "", new FileAttribute[0]).toFile();
        boolean bl = false;
        it.deleteOnExit();
        File file2 = file;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempDirectory(outp\u2026lso { it.deleteOnExit() }");
        return file2;
    }

    static {
        File baseDir = new File("./temp/svelte");
        if (baseDir.exists()) {
            FilesKt.deleteRecursively((File)baseDir);
        }
        baseDir.mkdirs();
        Path path = baseDir.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"baseDir.toPath()");
        outputBaseDir = path;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ltokyo/baseballyama/kvelte/RollupConfigFileWriter$Companion;", "", "()V", "KVELTE_GENERATE", "", "KVELTE_HYDRATABLE", "KVELTE_INPUT", "KVELTE_OUTPUT", "KVELTE_OUTPUT_CSS", "KVELTE_PRODUCTION", "OUTPUT_FILE_NAME_CSS", "OUTPUT_FILE_NAME_JS", "OUTPUT_FILE_NAME_JS_SOURCE_MAP", "ROLLUP_FILE_NAME", "outputBaseDir", "Ljava/nio/file/Path;", "kvelte"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

