/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermList;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.net.URL;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ContentImage;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.Viewport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundImage
extends ContentImage {
    private static Logger log = LoggerFactory.getLogger(BackgroundImage.class);
    private CSSProperty.BackgroundPosition position;
    private CSSProperty.BackgroundRepeat repeat;
    private CSSProperty.BackgroundAttachment attachment;
    private CSSProperty.BackgroundSize size;
    private TermList positionValues;
    private TermList sizeValues;
    private boolean viewportOwner;
    private int imgx;
    private int imgy;
    private int imgw;
    private int imgh;
    private boolean repeatx;
    private boolean repeaty;

    public BackgroundImage(ElementBox owner, URL url, CSSProperty.BackgroundPosition position, TermList positionValues, CSSProperty.BackgroundRepeat repeat, CSSProperty.BackgroundAttachment attachment, CSSProperty.BackgroundSize size, TermList sizeValues) {
        super(owner);
        this.loadImages = owner.getViewport().getConfig().getLoadBackgroundImages();
        this.url = url;
        this.position = position;
        this.positionValues = positionValues;
        this.size = size;
        this.sizeValues = sizeValues;
        this.repeat = repeat;
        this.attachment = attachment;
        if (this.loadImages) {
            this.image = this.loadImage(this.caching);
        }
        this.repeatx = repeat == CSSProperty.BackgroundRepeat.REPEAT || repeat == CSSProperty.BackgroundRepeat.REPEAT_X;
        this.repeaty = repeat == CSSProperty.BackgroundRepeat.REPEAT || repeat == CSSProperty.BackgroundRepeat.REPEAT_Y;
        this.viewportOwner = owner instanceof Viewport;
    }

    @Override
    public void setOwner(ElementBox owner) {
        super.setOwner(owner);
        this.viewportOwner = owner instanceof Viewport;
    }

    public CSSProperty.BackgroundPosition getPosition() {
        return this.position;
    }

    public CSSProperty.BackgroundRepeat getRepeat() {
        return this.repeat;
    }

    public CSSProperty.BackgroundAttachment getAttachment() {
        return this.attachment;
    }

    public CSSProperty.BackgroundSize getSize() {
        return this.size;
    }

    @Override
    public void draw(Graphics2D g, int width, int height) {
        Rectangle bounds = this.getOwner().getAbsoluteBackgroundBounds();
        this.computeCoordinates(bounds);
        this.drawScaledImage(g, this.image, bounds.x + this.imgx, bounds.y + this.imgy, this.observer);
    }

    @Override
    public BufferedImage getBufferedImage() {
        if (this.image == null || this.abort) {
            return null;
        }
        this.image = this.loadImage(this.caching);
        if (this.container == null) {
            this.waitForLoad();
        }
        Rectangle bounds = this.getOwner().getAbsoluteBackgroundBounds();
        Rectangle clipped = this.getOwner().getClippedBounds();
        if (this.viewportOwner) {
            bounds = clipped;
        }
        clipped = new Rectangle(bounds.x - clipped.x, bounds.y - clipped.y, clipped.width, clipped.height);
        if (bounds.width > 0 && bounds.height > 0) {
            this.computeCoordinates(bounds);
            BufferedImage img = new BufferedImage(bounds.width, bounds.height, 2);
            Graphics2D g = img.createGraphics();
            if (this.repeatx && this.repeaty) {
                this.drawRepeatBoth(g, this.imgx, this.imgy, bounds.width, bounds.height, clipped);
            } else if (this.repeatx) {
                this.drawRepeatX(g, this.imgx, this.imgy, bounds.width, clipped);
            } else if (this.repeaty) {
                this.drawRepeatY(g, this.imgx, this.imgy, bounds.height, clipped);
            } else {
                this.drawScaledImage(g, this.image, this.imgx, this.imgy, this.observer);
            }
            g.dispose();
            return img;
        }
        return null;
    }

    private void drawRepeatX(Graphics2D g, int sx, int sy, int limit, Rectangle clip) {
        int width = this.imgw;
        int height = this.imgh;
        Rectangle r = new Rectangle(0, 0, width, height);
        if (width > 0) {
            int x;
            for (x = sx; x < limit; x += width) {
                r.setLocation(x, sy);
                if (!r.intersects(clip)) continue;
                this.drawScaledImage(g, this.image, x, sy, this.observer);
            }
            x = sx - width;
            while (x + width - 1 >= 0) {
                r.setLocation(x, sy);
                if (r.intersects(clip)) {
                    this.drawScaledImage(g, this.image, x, sy, this.observer);
                }
                x -= width;
            }
        }
    }

    private void drawRepeatY(Graphics2D g, int sx, int sy, int limit, Rectangle clip) {
        int width = this.imgw;
        int height = this.imgh;
        Rectangle r = new Rectangle(0, 0, width, height);
        if (height > 0) {
            int y;
            for (y = sy; y < limit; y += height) {
                r.setLocation(sx, y);
                if (!r.intersects(clip)) continue;
                this.drawScaledImage(g, this.image, sx, y, this.observer);
            }
            y = sy - height;
            while (y + height - 1 >= 0) {
                r.setLocation(sx, y);
                if (r.intersects(clip)) {
                    this.drawScaledImage(g, this.image, sx, y, this.observer);
                }
                y -= height;
            }
        }
    }

    private void drawRepeatBoth(Graphics2D g, int sx, int sy, int limitx, int limity, Rectangle clip) {
        int width = this.imgw;
        int height = this.imgh;
        Rectangle r = new Rectangle(0, 0, width, height);
        if (height > 0) {
            int y;
            for (y = sy; y < limity; y += height) {
                r.setLocation(sx, y);
                if (!r.intersects(clip)) continue;
                this.drawRepeatX(g, sx, y, limitx, clip);
            }
            y = sy - height;
            while (y + height - 1 >= 0) {
                r.setLocation(sx, y);
                if (r.intersects(clip)) {
                    this.drawRepeatX(g, sx, y, limitx, clip);
                }
                y -= height;
            }
        }
    }

    private void drawScaledImage(Graphics2D g, Image image, int x, int y, ImageObserver observer) {
        g.drawImage(image, x, y, x + this.imgw, y + this.imgh, 0, 0, this.getIntrinsicWidth(), this.getIntrinsicHeight(), observer);
    }

    public boolean isRepeatX() {
        return this.repeatx;
    }

    public boolean isRepeatY() {
        return this.repeaty;
    }

    public int getImgX() {
        return this.imgx;
    }

    public int getImgY() {
        return this.imgy;
    }

    public int getImgWidth() {
        return this.imgw;
    }

    public int getImgHeight() {
        return this.imgh;
    }

    public void computeCoordinates() {
        this.computeCoordinates(this.getOwner().getAbsoluteBackgroundBounds());
    }

    protected void computeCoordinates(Rectangle bounds) {
        ElementBox rootBox;
        ElementBox contextBox;
        if (this.viewportOwner) {
            contextBox = ((Viewport)this.getOwner()).getBackgroundSource();
            if (contextBox == null) {
                contextBox = this.getOwner();
            }
        } else {
            contextBox = this.getOwner();
        }
        CSSDecoder dec = new CSSDecoder(contextBox.getVisualContext());
        this.computeSize(bounds, dec);
        this.imgx = this.position == CSSProperty.BackgroundPosition.LEFT ? 0 : (this.position == CSSProperty.BackgroundPosition.RIGHT ? bounds.width - this.imgw : (this.position == CSSProperty.BackgroundPosition.CENTER ? (bounds.width - this.imgw) / 2 : (this.position == CSSProperty.BackgroundPosition.list_values ? dec.getLength((TermLengthOrPercent)this.positionValues.get(0), false, 0, 0, bounds.width - this.imgw) : 0)));
        if (this.position == CSSProperty.BackgroundPosition.TOP) {
            this.imgy = 0;
        } else if (this.position == CSSProperty.BackgroundPosition.BOTTOM) {
            this.imgy = bounds.height - this.imgh;
        } else if (this.position == CSSProperty.BackgroundPosition.CENTER) {
            this.imgy = (bounds.height - this.imgh) / 2;
        } else if (this.position == CSSProperty.BackgroundPosition.list_values) {
            int i = this.positionValues.size() > 1 ? 1 : 0;
            this.imgy = dec.getLength((TermLengthOrPercent)this.positionValues.get(i), false, 0, 0, bounds.height - this.imgh);
        } else {
            this.imgy = 0;
        }
        if (this.viewportOwner && (rootBox = ((Viewport)this.getOwner()).getRootBox()) != null) {
            Rectangle cbounds = rootBox.getAbsoluteBackgroundBounds();
            this.imgx += cbounds.x;
            this.imgy += cbounds.y;
        }
    }

    protected void computeSize(Rectangle bounds, CSSDecoder dec) {
        float ir = this.getIntrinsicRatio();
        if (this.size == CSSProperty.BackgroundSize.COVER) {
            int h2;
            int w2;
            int w1 = bounds.width;
            int h1 = Math.round((float)w1 / ir);
            if (h1 - bounds.height > (w2 = Math.round((float)(h2 = bounds.height) * ir)) - bounds.width) {
                this.imgw = w1;
                this.imgh = h1;
            } else {
                this.imgw = w2;
                this.imgh = h2;
            }
        } else if (this.size == CSSProperty.BackgroundSize.CONTAIN) {
            int h2;
            int w2;
            int w1 = bounds.width;
            int h1 = Math.round((float)w1 / ir);
            if (h1 - bounds.height < (w2 = Math.round((float)(h2 = bounds.height) * ir)) - bounds.width) {
                this.imgw = w1;
                this.imgh = h1;
            } else {
                this.imgw = w2;
                this.imgh = h2;
            }
        } else if (this.size == CSSProperty.BackgroundSize.list_values) {
            if (this.sizeValues == null) {
                this.imgw = this.getIntrinsicWidth();
                this.imgh = this.getIntrinsicHeight();
            } else if (this.sizeValues.size() == 2) {
                Term w = (Term)this.sizeValues.get(0);
                Term h = (Term)this.sizeValues.get(1);
                if (w instanceof TermLengthOrPercent && h instanceof TermLengthOrPercent) {
                    this.imgw = dec.getLength((TermLengthOrPercent)w, false, 0, 0, bounds.width);
                    this.imgh = dec.getLength((TermLengthOrPercent)h, false, 0, 0, bounds.height);
                } else if (w instanceof TermLengthOrPercent) {
                    this.imgw = dec.getLength((TermLengthOrPercent)w, false, 0, 0, bounds.width);
                    this.imgh = Math.round((float)this.imgw / ir);
                } else if (h instanceof TermLengthOrPercent) {
                    this.imgh = dec.getLength((TermLengthOrPercent)h, false, 0, 0, bounds.height);
                    this.imgw = Math.round((float)this.imgh * ir);
                } else {
                    this.imgw = this.getIntrinsicWidth();
                    this.imgh = this.getIntrinsicHeight();
                }
            } else {
                log.error("Invalid number BackgroundSize values: {}", (Object)this.sizeValues);
                this.imgw = this.getIntrinsicWidth();
                this.imgh = this.getIntrinsicHeight();
            }
        }
    }
}

