/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermRect;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.fit.cssbox.css.HTMLNorm;
import org.fit.cssbox.layout.BlockLayoutStatus;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.FloatList;
import org.fit.cssbox.layout.Inline;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.InlineElement;
import org.fit.cssbox.layout.LengthSet;
import org.fit.cssbox.layout.LineBox;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.layout.VisualContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class BlockBox
extends ElementBox {
    private static Logger log = LoggerFactory.getLogger(BlockBox.class);
    public static final CSSProperty.Float FLOAT_NONE = CSSProperty.Float.NONE;
    public static final CSSProperty.Float FLOAT_LEFT = CSSProperty.Float.LEFT;
    public static final CSSProperty.Float FLOAT_RIGHT = CSSProperty.Float.RIGHT;
    public static final CSSProperty.Clear CLEAR_NONE = CSSProperty.Clear.NONE;
    public static final CSSProperty.Clear CLEAR_LEFT = CSSProperty.Clear.LEFT;
    public static final CSSProperty.Clear CLEAR_RIGHT = CSSProperty.Clear.RIGHT;
    public static final CSSProperty.Clear CLEAR_BOTH = CSSProperty.Clear.BOTH;
    public static final CSSProperty.TextAlign ALIGN_LEFT = CSSProperty.TextAlign.LEFT;
    public static final CSSProperty.TextAlign ALIGN_RIGHT = CSSProperty.TextAlign.RIGHT;
    public static final CSSProperty.TextAlign ALIGN_CENTER = CSSProperty.TextAlign.CENTER;
    public static final CSSProperty.TextAlign ALIGN_JUSTIFY = CSSProperty.TextAlign.JUSTIFY;
    public static final CSSProperty.Overflow OVERFLOW_VISIBLE = CSSProperty.Overflow.VISIBLE;
    public static final CSSProperty.Overflow OVERFLOW_HIDDEN = CSSProperty.Overflow.HIDDEN;
    public static final CSSProperty.Overflow OVERFLOW_SCROLL = CSSProperty.Overflow.SCROLL;
    public static final CSSProperty.Overflow OVERFLOW_AUTO = CSSProperty.Overflow.AUTO;
    public static final CSSProperty.BoxSizing CONTENT_BOX = CSSProperty.BoxSizing.CONTENT_BOX;
    public static final CSSProperty.BoxSizing BORDER_BOX = CSSProperty.BoxSizing.BORDER_BOX;
    protected static final int INFLOW_SPACE_THRESHOLD = 15;
    protected boolean contblock;
    protected boolean anyinflow;
    protected FloatList fleft;
    protected FloatList fright;
    protected FloatList fown;
    protected int floatXl;
    protected int floatXr;
    protected int floatY;
    protected Dimension min_size;
    protected Dimension max_size;
    protected LineBox firstLine;
    protected boolean wset;
    protected boolean hset;
    protected boolean wrelative;
    protected boolean mleftauto;
    protected boolean mrightauto;
    protected int widthAdjust;
    protected boolean widthComputed = false;
    protected LengthSet declMargin;
    protected CSSProperty.Float floating;
    protected CSSProperty.Clear clearing;
    protected CSSProperty.Overflow overflowX;
    protected CSSProperty.Overflow overflowY;
    protected CSSProperty.BoxSizing boxSizing;
    protected boolean leftstatic;
    protected boolean topstatic;
    protected Box absReference;
    protected ElementBox domParent;
    protected CSSProperty.TextAlign align;
    protected int indent;
    protected TermRect clipRegion;

    public BlockBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.isblock = true;
        this.contblock = false;
        this.anyinflow = false;
        this.fleft = null;
        this.fright = null;
        this.fown = null;
        this.floatXl = 0;
        this.floatXr = 0;
        this.floatY = 0;
        this.firstLine = null;
        this.floating = FLOAT_NONE;
        this.clearing = CLEAR_NONE;
        this.overflowX = OVERFLOW_VISIBLE;
        this.overflowY = OVERFLOW_VISIBLE;
        this.boxSizing = CONTENT_BOX;
        this.align = ALIGN_LEFT;
        this.indent = 0;
        this.clipRegion = null;
        this.topstatic = false;
        this.leftstatic = false;
        this.widthAdjust = 0;
        if (this.style != null) {
            this.loadBlockStyle();
        }
    }

    public BlockBox(InlineBox src) {
        super(src.el, src.g, src.ctx);
        this.viewport = src.viewport;
        this.clipblock = src.clipblock;
        this.isblock = true;
        this.contblock = false;
        this.anyinflow = false;
        this.fleft = null;
        this.fright = null;
        this.fown = null;
        this.floatXl = 0;
        this.floatXr = 0;
        this.floatY = 0;
        this.floating = FLOAT_NONE;
        this.clearing = CLEAR_NONE;
        this.position = src.position;
        this.overflowX = OVERFLOW_VISIBLE;
        this.overflowY = OVERFLOW_VISIBLE;
        this.boxSizing = CONTENT_BOX;
        this.align = ALIGN_LEFT;
        this.indent = 0;
        this.clipRegion = null;
        this.topset = src.topset;
        this.leftset = src.leftset;
        this.bottomset = src.bottomset;
        this.rightset = src.rightset;
        this.topstatic = false;
        this.leftstatic = false;
        this.widthAdjust = 0;
        this.nested = src.nested;
        this.startChild = src.startChild;
        this.endChild = src.endChild;
        this.setStyle(src.getStyle());
    }

    public void copyValues(BlockBox src) {
        super.copyValues(src);
        this.contblock = src.contblock;
        this.anyinflow = src.anyinflow;
        this.setFloats(src.fleft, src.fright, src.floatXl, src.floatXr, src.floatY);
        this.fown = src.fown;
        this.floating = src.floating;
        this.clearing = src.clearing;
        this.overflowX = src.overflowX;
        this.overflowY = src.overflowY;
        this.boxSizing = src.boxSizing;
        this.align = src.align;
        this.indent = src.indent;
        this.topstatic = src.topstatic;
        this.leftstatic = src.leftstatic;
        this.domParent = src.domParent;
        if (src.declMargin != null) {
            this.declMargin = new LengthSet(src.declMargin);
        }
        this.clipRegion = src.clipRegion;
    }

    @Override
    public BlockBox copyBox() {
        BlockBox ret = new BlockBox(this.el, this.g, this.ctx);
        ret.copyValues(this);
        return ret;
    }

    @Override
    public void initBox() {
        this.setFloats(new FloatList(this), new FloatList(this), 0, 0, 0);
    }

    @Override
    public void addSubBox(Box box) {
        super.addSubBox(box);
        if (box.isInFlow()) {
            this.anyinflow = true;
            if (box.isBlock()) {
                this.contblock = true;
            }
        }
    }

    @Override
    public void setStyle(NodeData s) {
        super.setStyle(s);
        this.loadBlockStyle();
    }

    public String toString() {
        return "<" + this.el.getTagName() + " id=\"" + HTMLNorm.getAttribute(this.el, "id") + "\" class=\"" + HTMLNorm.getAttribute(this.el, "class") + "\">";
    }

    @Override
    public boolean mayContainBlocks() {
        return true;
    }

    public boolean containsBlocks() {
        return this.contblock;
    }

    public void setFloats(FloatList left, FloatList right, int xl, int xr, int y) {
        this.fleft = left;
        this.fright = right;
        this.floatXl = xl;
        this.floatXr = xr;
        this.floatY = y;
    }

    public void setOwnerFloatList(FloatList list) {
        this.fown = list;
    }

    public FloatList getOwnerFloatList() {
        return this.fown;
    }

    public CSSProperty.Float getFloating() {
        return this.floating;
    }

    public String getFloatingString() {
        return this.floating.toString();
    }

    public CSSProperty.Clear getClearing() {
        return this.clearing;
    }

    public String getClearingString() {
        return this.clearing.toString();
    }

    public CSSProperty.Overflow getOverflowX() {
        return this.overflowX;
    }

    public CSSProperty.Overflow getOverflowY() {
        return this.overflowY;
    }

    public String getOverflowXString() {
        return this.overflowX.toString();
    }

    public String getOverflowYString() {
        return this.overflowY.toString();
    }

    public int getFloatY() {
        return this.floatY;
    }

    @Override
    public boolean isInFlow() {
        return this.displayed && this.floating == FLOAT_NONE && this.position != POS_ABSOLUTE && this.position != POS_FIXED;
    }

    public boolean isPositioned() {
        return this.displayed && (this.position == POS_ABSOLUTE || this.position == POS_FIXED);
    }

    public boolean isFloating() {
        return this.displayed && this.floating != FLOAT_NONE;
    }

    @Override
    public boolean containsFlow() {
        return this.anyinflow;
    }

    @Override
    public boolean isWhitespace() {
        if (this.anyinflow || this.encloseFloats()) {
            return super.isWhitespace();
        }
        return true;
    }

    @Override
    public boolean marginsAdjoin() {
        if (this.padding.top > 0 || this.padding.bottom > 0 || this.border.top > 0 || this.border.bottom > 0) {
            return false;
        }
        if (this.min_size.height > 0) {
            return false;
        }
        if (this.hset) {
            return this.content.height == 0;
        }
        for (int i = this.startChild; i < this.endChild; ++i) {
            Box box = this.getSubBox(i);
            if (!(box instanceof ElementBox ? !((ElementBox)box).marginsAdjoin() : !box.isWhitespace())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean affectsDisplay() {
        boolean ret = this.containsFlow();
        if (this.border.top > 0 || this.border.bottom > 0) {
            ret = true;
        }
        if (this.padding.top > 0 || this.padding.bottom > 0) {
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean canSplitInside() {
        return false;
    }

    @Override
    public boolean canSplitBefore() {
        return true;
    }

    @Override
    public boolean canSplitAfter() {
        return true;
    }

    @Override
    public boolean startsWithWhitespace() {
        return false;
    }

    @Override
    public boolean endsWithWhitespace() {
        return false;
    }

    @Override
    public void setIgnoreInitialWhitespace(boolean b) {
    }

    public boolean canIncreaseWidth() {
        return false;
    }

    protected boolean encloseFloats() {
        return this.overflowX != OVERFLOW_VISIBLE || this.floating != FLOAT_NONE || this.position == POS_ABSOLUTE || this.position == POS_FIXED || this.display == ElementBox.DISPLAY_INLINE_BLOCK;
    }

    protected boolean mayOverlapFloats() {
        return this.overflowX == OVERFLOW_VISIBLE;
    }

    public Box getAbsReference() {
        return this.absReference;
    }

    public ElementBox getDomParent() {
        return this.domParent;
    }

    public void setContentWidth(int width) {
        int w = width;
        if (this.max_size.width != -1 && w > this.max_size.width) {
            w = this.max_size.width;
        }
        if (this.min_size.width != -1 && w < this.min_size.width) {
            w = this.min_size.width;
        }
        this.content.width = w;
    }

    public void setContentHeight(int height) {
        int h = height;
        if (this.max_size.height != -1 && h > this.max_size.height) {
            h = this.max_size.height;
        }
        if (this.min_size.height != -1 && h < this.min_size.height) {
            h = this.min_size.height;
        }
        this.content.height = h;
    }

    public void setWidthAdjust(int adjust) {
        if (!this.wset) {
            this.setContentWidth(this.getContentWidth() - this.widthAdjust + adjust);
        }
        this.widthAdjust = adjust;
    }

    @Override
    public int totalHeight() {
        if (this.border.top == 0 && this.border.bottom == 0 && this.padding.top == 0 && this.padding.bottom == 0 && this.content.height == 0) {
            return Math.max(this.emargin.top, this.emargin.bottom);
        }
        return this.emargin.top + this.border.top + this.padding.top + this.content.height + this.padding.bottom + this.border.bottom + this.emargin.bottom;
    }

    public int getIndent() {
        return this.indent;
    }

    @Override
    public Rectangle getContainingBlock() {
        if (this.position == POS_FIXED) {
            return this.viewport.getVisibleRect();
        }
        if (this.position == POS_ABSOLUTE) {
            return this.cbox.getPaddingBounds();
        }
        return super.getContainingBlock();
    }

    @Override
    public Rectangle getAbsoluteContainingBlock() {
        if (this.position == POS_FIXED) {
            return this.viewport.getVisibleRect();
        }
        if (this.position == POS_ABSOLUTE) {
            return this.cbox.getAbsolutePaddingBounds();
        }
        return super.getAbsoluteContainingBlock();
    }

    protected void moveFloatsDown(int ofs) {
        this.floatY += ofs;
        for (int i = this.startChild; i < this.endChild; ++i) {
            Box box = this.getSubBox(i);
            if (!(box instanceof BlockBox)) continue;
            BlockBox block = (BlockBox)box;
            if (block.isInFlow()) {
                block.moveFloatsDown(ofs);
                continue;
            }
            if (block.getFloating() == FLOAT_NONE) continue;
            block.moveDown(ofs);
        }
    }

    private void alignLineHorizontally(LineBox line, boolean isLast) {
        int dif = this.content.width - line.getLimits() - line.getWidth();
        if (dif > 0) {
            if (this.align == ALIGN_JUSTIFY) {
                if (!isLast) {
                    this.extendInlineChildWidths(dif, line.getStart(), line.getEnd(), true, true);
                }
            } else if (this.align != ALIGN_LEFT) {
                for (int i = line.getStart(); i < line.getEnd(); ++i) {
                    Box subbox = this.getSubBox(i);
                    if (!(subbox instanceof Inline)) continue;
                    if (this.align == ALIGN_RIGHT) {
                        subbox.moveRight(dif);
                        continue;
                    }
                    if (this.align != ALIGN_CENTER) continue;
                    subbox.moveRight(dif / 2);
                }
            }
        }
    }

    private void alignLineVertically(LineBox line) {
        for (int i = line.getStart(); i < line.getEnd(); ++i) {
            Box subbox = this.getSubBox(i);
            if (subbox.isBlock()) continue;
            int dif = line.alignBox((Inline)((Object)subbox));
            if (subbox instanceof InlineBox) {
                dif -= ((ElementBox)subbox).getContentOffsetY();
            }
            if (subbox instanceof InlineElement) {
                ((InlineElement)((Object)subbox)).setLineBox(line);
            }
            int y = line.getY() + line.getTopOffset() + line.getLead() / 2 + dif;
            subbox.moveDown(y);
        }
    }

    @Override
    public void computeEfficientMargins() {
        this.emargin.top = this.margin.top;
        this.emargin.bottom = this.margin.bottom;
        if (this.containsBlocks() && this.containsFlow()) {
            BlockBox firstseparated = null;
            int mbottom = 0;
            for (int i = 0; i < this.getSubBoxNumber(); ++i) {
                BlockBox subbox = (BlockBox)this.getSubBox(i);
                if (!subbox.isDisplayed() || !subbox.isInFlow()) continue;
                subbox.computeEfficientMargins();
                boolean boxempty = subbox.marginsAdjoin();
                if (firstseparated == null && !this.separatedFromTop(this) && subbox.emargin.top > this.emargin.top) {
                    this.emargin.top = subbox.emargin.top;
                }
                if (boxempty) {
                    int m = Math.max(subbox.emargin.top, subbox.emargin.bottom);
                    if (m > mbottom) {
                        mbottom = m;
                    }
                } else {
                    mbottom = subbox.emargin.bottom;
                }
                if (boxempty || firstseparated != null) continue;
                firstseparated = subbox;
            }
            if (mbottom > this.emargin.bottom && !this.separatedFromBottom(this)) {
                this.emargin.bottom = mbottom;
            }
        }
        if (this.marginsAdjoin()) {
            this.emargin.top = Math.max(this.emargin.top, this.emargin.bottom);
            this.emargin.bottom = 0;
        }
    }

    @Override
    public boolean doLayout(int availw, boolean force, boolean linestart) {
        if (!this.displayed) {
            this.content.setSize(0, 0);
            this.bounds.setSize(0, 0);
            return true;
        }
        this.clearSplitted();
        if (!this.hasFixedWidth()) {
            int min = Math.max(this.getMinimalContentWidthLimit(), this.getMinimalContentWidth());
            int max = this.getMaximalContentWidth();
            int availcont = availw - this.emargin.left - this.border.left - this.padding.left - this.emargin.right - this.border.right - this.padding.right;
            int pref = Math.min(Math.max(min, availcont), max);
            this.setContentWidth(pref);
            this.updateChildSizes();
        }
        this.widthComputed = true;
        this.setAvailableWidth(this.totalWidth());
        if (!this.contblock) {
            this.layoutInline();
        } else {
            this.layoutBlocks();
        }
        return true;
    }

    protected void layoutInline() {
        int x1 = this.fleft.getWidth(this.floatY) - this.floatXl;
        int x2 = this.fright.getWidth(this.floatY) - this.floatXr;
        if (x1 < 0) {
            x1 = 0;
        }
        if (x2 < 0) {
            x2 = 0;
        }
        int wlimit = this.getAvailableContentWidth();
        int minx1 = 0 - this.floatXl;
        int minx2 = 0 - this.floatXr;
        if (minx1 < 0) {
            minx1 = 0;
        }
        if (minx2 < 0) {
            minx2 = 0;
        }
        int x = x1;
        int y = 0;
        int lnstr = 0;
        int lastbreak = 0;
        x += this.indent;
        Vector<LineBox> lines = new Vector<LineBox>();
        LineBox curline = this.firstLine;
        if (curline == null) {
            curline = new LineBox(this, 0, 0);
        }
        lines.add(curline);
        for (int i = 0; i < this.getSubBoxNumber(); ++i) {
            boolean split;
            Box subbox = this.getSubBox(i);
            if (subbox.isBlock()) {
                boolean atstart;
                BlockBox sb = (BlockBox)subbox;
                BlockLayoutStatus stat = new BlockLayoutStatus();
                stat.inlineWidth = x - x1;
                stat.y = y;
                stat.maxh = 0;
                boolean bl = atstart = x <= x1;
                if (sb.getClearing() != CLEAR_NONE) {
                    int ny = stat.y;
                    if (sb.getClearing() == CLEAR_LEFT) {
                        ny = this.fleft.getMaxY() - this.floatY;
                    } else if (sb.getClearing() == CLEAR_RIGHT) {
                        ny = this.fright.getMaxY() - this.floatY;
                    } else if (sb.getClearing() == CLEAR_BOTH) {
                        ny = Math.max(this.fleft.getMaxY(), this.fright.getMaxY()) - this.floatY;
                    }
                    if (stat.y < ny) {
                        stat.y = ny;
                    }
                }
                if (sb.getFloating() == FLOAT_LEFT || sb.getFloating() == FLOAT_RIGHT) {
                    this.layoutBlockFloating(sb, wlimit, stat);
                    if (sb.getFloating() == FLOAT_LEFT && stat.inlineWidth > 0 && curline.getStart() < i) {
                        for (int j = curline.getStart(); j < i; ++j) {
                            Box child = this.getSubBox(j);
                            if (child.isBlock()) continue;
                            child.moveRight(sb.getWidth());
                        }
                        x += sb.getWidth();
                    }
                } else {
                    this.layoutBlockPositioned(sb, stat);
                }
                x1 = this.fleft.getWidth(y + this.floatY) - this.floatXl;
                x2 = this.fright.getWidth(y + this.floatY) - this.floatXr;
                if (x1 < 0) {
                    x1 = 0;
                }
                if (x2 < 0) {
                    x2 = 0;
                }
                if (!atstart || x >= x1) continue;
                x = x1;
                continue;
            }
            if (subbox.canSplitBefore()) {
                lastbreak = i;
            }
            do {
                boolean linebreak;
                split = false;
                int space = wlimit - x1 - x2;
                boolean narrowed = x1 > minx1 || x2 > minx2;
                boolean f = (x == x1 || lastbreak == lnstr || !this.allowsWrapping()) && !narrowed;
                boolean fit = false;
                if (space >= 15 || !narrowed) {
                    fit = subbox.doLayout(wlimit - x - x2, f, x == x1);
                }
                if (fit) {
                    if (subbox.isInFlow()) {
                        subbox.setPosition(x, 0);
                        x += subbox.getWidth();
                    }
                    curline.considerBox((Inline)((Object)subbox));
                }
                boolean over = x > wlimit - x2;
                boolean bl = linebreak = subbox instanceof Inline && ((Inline)((Object)subbox)).finishedByLineBreak();
                if (!fit && narrowed && (x == x1 || lastbreak == lnstr)) {
                    if (lnstr < i) {
                        lnstr = i;
                        curline.setEnd(lnstr);
                        curline = new LineBox(this, lnstr, y);
                        lines.add(curline);
                    }
                    curline.setY(y += this.getLineHeight());
                    x1 = this.fleft.getWidth(y + this.floatY) - this.floatXl;
                    x2 = this.fright.getWidth(y + this.floatY) - this.floatXr;
                    if (x1 < 0) {
                        x1 = 0;
                    }
                    if (x2 < 0) {
                        x2 = 0;
                    }
                    x = x1;
                    if (this.getLineHeight() <= 0) continue;
                    split = true;
                    continue;
                }
                if ((fit || lastbreak <= lnstr) && (!fit || !over && !linebreak && subbox.getRest() == null)) continue;
                curline.setWidth(x - x1);
                curline.setLimits(x1, x2);
                x1 = this.fleft.getWidth((y += curline.getMaxBoxHeight()) + this.floatY) - this.floatXl;
                x2 = this.fright.getWidth(y + this.floatY) - this.floatXr;
                if (x1 < 0) {
                    x1 = 0;
                }
                if (x2 < 0) {
                    x2 = 0;
                }
                x = x1;
                if (!fit) {
                    lnstr = i;
                    curline.setEnd(lnstr);
                    curline = new LineBox(this, lnstr, y);
                    lines.add(curline);
                    split = true;
                    continue;
                }
                if (!over && !linebreak && subbox.getRest() == null) continue;
                if (subbox.getRest() != null) {
                    this.insertSubBox(i + 1, subbox.getRest());
                }
                lnstr = i + 1;
                curline.setEnd(lnstr);
                curline = new LineBox(this, lnstr, y);
                lines.add(curline);
            } while (split);
            if (!subbox.canSplitAfter()) continue;
            lastbreak = i + 1;
        }
        if (!this.hasFixedHeight()) {
            int mfy;
            if (this.encloseFloats() && (mfy = this.getFloatHeight() - this.floatY) > (y += curline.getMaxBoxHeight())) {
                y = mfy;
            }
            this.setContentHeight(y);
            this.updateSizes();
            this.updateChildSizes();
        }
        this.setSize(this.totalWidth(), this.totalHeight());
        curline.setWidth(x - x1);
        curline.setLimits(x1, x2);
        curline.setEnd(this.getSubBoxNumber());
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            LineBox line = (LineBox)it.next();
            this.alignLineHorizontally(line, !it.hasNext());
            this.alignLineVertically(line);
        }
    }

    protected void layoutBlocks() {
        int wlimit = this.getAvailableContentWidth();
        BlockLayoutStatus stat = new BlockLayoutStatus();
        int mtop = 0;
        int mbottom = 0;
        for (int i = 0; i < this.getSubBoxNumber(); ++i) {
            int nexty = stat.y;
            BlockBox subbox = (BlockBox)this.getSubBox(i);
            if (!subbox.isDisplayed()) continue;
            boolean clearance = false;
            if (subbox.getClearing() != CLEAR_NONE) {
                int ny = stat.y;
                if (subbox.getClearing() == CLEAR_LEFT) {
                    ny = this.fleft.getMaxY() - this.floatY;
                } else if (subbox.getClearing() == CLEAR_RIGHT) {
                    ny = this.fright.getMaxY() - this.floatY;
                } else if (subbox.getClearing() == CLEAR_BOTH) {
                    ny = Math.max(this.fleft.getMaxY(), this.fright.getMaxY()) - this.floatY;
                }
                if (stat.y < ny) {
                    stat.y = ny;
                    clearance = true;
                }
            }
            if (subbox.isInFlow()) {
                boolean boxempty = subbox.marginsAdjoin();
                int borderY = stat.y;
                if (stat.lastinflow != null) {
                    borderY -= stat.lastinflow.emargin.bottom;
                }
                if (subbox.emargin.top > mtop) {
                    mtop = subbox.emargin.top;
                }
                if (stat.firstseparated == null && this.separatedFromTop(this)) {
                    borderY += mtop;
                }
                if (stat.firstseparated != null) {
                    borderY = clearance ? (borderY += mtop + mbottom) : (borderY += this.collapsedMarginHeight(mtop, mbottom));
                }
                stat.lastinflow = subbox;
                if (!boxempty && stat.firstseparated == null) {
                    stat.firstseparated = subbox;
                }
                if (!boxempty) {
                    stat.lastseparated = subbox;
                    mtop = 0;
                    mbottom = subbox.emargin.bottom;
                }
                if (stat.lastseparated != null && subbox.emargin.bottom > mbottom) {
                    mbottom = subbox.emargin.bottom;
                }
                if (subbox.emargin.top > 0) {
                    stat.y = borderY - subbox.emargin.top;
                }
                if (subbox.mayOverlapFloats()) {
                    this.layoutBlockInFlow(subbox, wlimit, stat);
                } else {
                    this.layoutBlockInFlowAvoidFloats(subbox, wlimit, stat);
                }
                if (subbox.getRest() != null) {
                    this.insertSubBox(i + 1, subbox.getRest());
                }
                nexty = stat.y;
            } else if (subbox.getFloating() == FLOAT_LEFT || subbox.getFloating() == FLOAT_RIGHT) {
                this.layoutBlockFloating(subbox, wlimit, stat);
            } else {
                this.layoutBlockPositioned(subbox, stat);
            }
            stat.y = nexty;
        }
        if (!this.separatedFromBottom(this)) {
            stat.y -= mbottom;
        }
        if (!this.hasFixedHeight()) {
            int mfy;
            if (this.encloseFloats() && (mfy = this.getFloatHeight() - this.floatY) > stat.y) {
                stat.y = mfy;
            }
            this.setContentHeight(stat.y);
            this.updateSizes();
            this.updateChildSizes();
        }
        this.setSize(this.totalWidth(), this.totalHeight());
    }

    protected void layoutBlockInFlow(BlockBox subbox, int wlimit, BlockLayoutStatus stat) {
        int newfloatXl = this.floatXl + subbox.margin.left + subbox.border.left + subbox.padding.left;
        int newfloatXr = this.floatXr + subbox.margin.right + subbox.border.right + subbox.padding.right;
        int newfloatY = this.floatY + subbox.emargin.top + subbox.border.top + subbox.padding.top;
        if (subbox.position == POS_RELATIVE) {
            int dx = subbox.leftset ? subbox.coords.left : -subbox.coords.right;
            int dy = subbox.topset ? subbox.coords.top : -subbox.coords.bottom;
            newfloatXl += dx;
            newfloatXr -= dx;
            newfloatY += dy;
        }
        subbox.setFloats(this.fleft, this.fright, newfloatXl, newfloatXr, stat.y + newfloatY);
        subbox.setPosition(0, stat.y);
        subbox.doLayout(wlimit, true, true);
        stat.y += subbox.getHeight();
        if (subbox.getWidth() > stat.maxw) {
            stat.maxw = subbox.getWidth();
        }
    }

    protected void layoutBlockInFlowAvoidFloats(BlockBox subbox, int wlimit, BlockLayoutStatus stat) {
        int minw = subbox.getMinimalDecorationWidth();
        int yoffset = stat.y + this.floatY;
        int availw = 0;
        do {
            int frx;
            int fy;
            int flx;
            if ((flx = this.fleft.getWidth(fy = yoffset) - this.floatXl) < 0) {
                flx = 0;
            }
            if ((frx = this.fright.getWidth(fy) - this.floatXr) < 0) {
                frx = 0;
            }
            int avail = wlimit - flx - frx;
            int startfy = fy;
            while ((flx > this.floatXl || frx > this.floatXr) && minw > avail) {
                int nexty = FloatList.getNextY(this.fleft, this.fright, fy);
                fy = nexty == -1 ? (fy += Math.max(stat.maxh, this.getLineHeight())) : nexty;
                flx = this.fleft.getWidth(fy) - this.floatXl;
                if (flx < 0) {
                    flx = 0;
                }
                if ((frx = this.fright.getWidth(fy) - this.floatXr) < 0) {
                    frx = 0;
                }
                avail = wlimit - flx - frx;
            }
            if (fy > startfy && subbox.margin.top != 0 && (fy -= subbox.margin.top) < startfy) {
                fy = startfy;
            }
            stat.y = fy - this.floatY;
            subbox.setFloats(new FloatList(subbox), new FloatList(subbox), 0, 0, 0);
            subbox.setPosition(flx, stat.y);
            subbox.setWidthAdjust(-flx - frx);
            subbox.doLayout(avail, true, true);
            int[] xlimit = this.computeFloatLimits(fy, fy + subbox.getBounds().height, new int[]{flx, frx});
            availw = wlimit - xlimit[0] - xlimit[1];
            if (minw <= availw) continue;
            yoffset = FloatList.getNextY(this.fleft, this.fright, fy);
        } while (minw > availw && yoffset != -1);
        stat.y += subbox.getHeight();
        if (subbox.getWidth() > stat.maxw) {
            stat.maxw = subbox.getWidth();
        }
    }

    protected void layoutBlockFloating(BlockBox subbox, int wlimit, BlockLayoutStatus stat) {
        int ofx;
        int fx;
        subbox.setFloats(new FloatList(subbox), new FloatList(subbox), 0, 0, 0);
        subbox.doLayout(wlimit, true, true);
        FloatList f = subbox.getFloating() == FLOAT_LEFT ? this.fleft : this.fright;
        FloatList of = subbox.getFloating() == FLOAT_LEFT ? this.fright : this.fleft;
        int floatX = subbox.getFloating() == FLOAT_LEFT ? this.floatXl : this.floatXr;
        int oFloatX = subbox.getFloating() == FLOAT_LEFT ? this.floatXr : this.floatXl;
        int fy = stat.y + this.floatY;
        if (fy < f.getLastY()) {
            fy = f.getLastY();
        }
        if ((fx = f.getWidth(fy)) < floatX) {
            fx = floatX;
        }
        if (fx == 0 && floatX < 0) {
            fx = floatX;
        }
        if ((ofx = of.getWidth(fy)) < oFloatX) {
            ofx = oFloatX;
        }
        if (ofx == 0 && oFloatX < 0) {
            ofx = oFloatX;
        }
        while ((fx > floatX || ofx > oFloatX || stat.inlineWidth > 0) && stat.inlineWidth + fx - floatX + ofx - oFloatX + subbox.getWidth() > wlimit) {
            int nexty = FloatList.getNextY(this.fleft, this.fright, fy);
            fy = nexty == -1 ? (fy += Math.max(stat.maxh, this.getLineHeight())) : nexty;
            fx = f.getWidth(fy);
            if (fx < floatX) {
                fx = floatX;
            }
            if (fx == 0 && floatX < 0) {
                fx = floatX;
            }
            if ((ofx = of.getWidth(fy)) < oFloatX) {
                ofx = oFloatX;
            }
            if (ofx == 0 && oFloatX < 0) {
                ofx = oFloatX;
            }
            stat.inlineWidth = 0;
        }
        subbox.setPosition(fx, fy);
        f.add(subbox);
        int floatw = this.maxFloatWidth(fy, fy + subbox.getHeight());
        if (floatw > stat.maxw) {
            stat.maxw = floatw;
        }
        if (stat.maxw > wlimit) {
            stat.maxw = wlimit;
        }
    }

    protected void layoutBlockPositioned(BlockBox subbox, BlockLayoutStatus stat) {
        int wlimit = this.availwidth;
        if (this.leftset) {
            wlimit -= this.coords.left;
        }
        if (this.rightset) {
            wlimit -= this.coords.right;
        }
        subbox.setFloats(new FloatList(subbox), new FloatList(subbox), 0, 0, 0);
        subbox.doLayout(wlimit, true, true);
    }

    public void initFirstLine(ElementBox box) {
        if (this.firstLine == null) {
            this.firstLine = new LineBox(this, 0, 0);
        }
        this.firstLine.considerBoxProperties(box);
        for (int i = this.startChild; i < this.endChild; ++i) {
            Box child = this.getSubBox(i);
            if (!child.isInFlow()) continue;
            if (!child.isBlock()) break;
            ((BlockBox)child).initFirstLine(box);
            break;
        }
    }

    @Override
    public void absolutePositions() {
        this.updateStackingContexts();
        if (this.displayed) {
            BlockBox listowner;
            Rectangle cblock = this.getAbsoluteContainingBlock();
            int x = cblock.x + this.bounds.x;
            int y = cblock.y + this.bounds.y;
            if (this.floating == FLOAT_NONE) {
                if (this.position == POS_RELATIVE) {
                    x += this.leftset ? this.coords.left : -this.coords.right;
                    y += this.topset ? this.coords.top : -this.coords.bottom;
                } else if (this.position == POS_ABSOLUTE || this.position == POS_FIXED) {
                    if (this.topstatic || this.leftstatic) {
                        this.updateStaticPosition();
                    }
                    x = cblock.x + this.coords.left;
                    y = cblock.y + this.coords.top;
                    if (this.position == POS_FIXED && this.getContainingBlockBox() instanceof Viewport) {
                        x += ((Viewport)this.getContainingBlockBox()).getVisibleRect().x;
                        y += ((Viewport)this.getContainingBlockBox()).getVisibleRect().y;
                    }
                }
            } else if (this.floating == FLOAT_LEFT) {
                listowner = this.fown.getOwner();
                x = listowner.getAbsoluteContentX() + this.bounds.x;
                y = listowner.getAbsoluteContentY() + this.bounds.y;
            } else if (this.floating == FLOAT_RIGHT) {
                listowner = this.fown.getOwner();
                x = listowner.getAbsoluteContentX() + listowner.getContentWidth() - this.bounds.width - this.bounds.x;
                y = listowner.getAbsoluteContentY() + this.bounds.y;
            }
            this.absbounds.x = x;
            this.absbounds.y = y;
            this.absbounds.width = this.bounds.width;
            this.absbounds.height = this.bounds.height;
            if (this.isDisplayed()) {
                if (this.isVisible()) {
                    if (this.clipblock == this.viewport) {
                        this.viewport.updateBoundsFor(this.absbounds);
                    } else {
                        this.viewport.updateBoundsFor(this.getClippedBounds());
                    }
                }
                for (int i = this.startChild; i < this.endChild; ++i) {
                    this.getSubBox(i).absolutePositions();
                }
            }
        }
    }

    private void updateStaticPosition() {
        if (this.topstatic || this.leftstatic) {
            ElementBox cblock = this.getContainingBlockBox();
            if (this.absReference != null) {
                Rectangle cb = this.getContainingBlockBox().getAbsoluteBounds();
                if (this.topstatic) {
                    Rectangle ab = new Rectangle(this.absReference.getAbsoluteBounds());
                    ab.x -= cb.x;
                    ab.y -= cb.y;
                    this.coords.top = !this.absReference.isblock || ((BlockBox)this.absReference).getFloating() == FLOAT_NONE ? ab.y + ab.height - cblock.emargin.top - cblock.border.top : ab.y - cblock.emargin.top - cblock.border.top;
                }
                if (this.leftstatic) {
                    ElementBox refcblock = this.absReference.getContainingBlockBox();
                    this.coords.left = refcblock != null ? refcblock.getAbsoluteContentBounds().x - cb.x - cblock.emargin.left - cblock.border.left : 0;
                }
                this.viewport.requireRecomputePositions();
            } else if (this.domParent != null) {
                ElementBox dparent;
                for (dparent = this.domParent; dparent != null && dparent.getContainingBlockBox() == null; dparent = dparent.getParent()) {
                }
                Rectangle ab = new Rectangle(dparent.getAbsoluteContentBounds());
                Rectangle cb = cblock.getAbsoluteBounds();
                ab.x -= cb.x;
                ab.y -= cb.y;
                if (this.topstatic) {
                    this.coords.top = ab.y - cblock.emargin.top - cblock.border.top;
                }
                if (this.leftstatic) {
                    this.coords.left = ab.x - cblock.emargin.left - cblock.border.left;
                }
                this.viewport.requireRecomputePositions();
            } else {
                log.warn("No static position available for " + this.toString());
                if (this.topstatic) {
                    this.coords.top = cblock.padding.top;
                }
                if (this.leftstatic) {
                    this.coords.left = cblock.padding.left;
                }
            }
        }
    }

    @Override
    public int getAvailableContentWidth() {
        int ret = this.availwidth - this.margin.left - this.border.left - this.padding.left - this.padding.right - this.border.right - this.margin.right;
        if (this.max_size.width != -1 && ret > this.max_size.width) {
            ret = this.max_size.width;
        }
        return ret;
    }

    @Override
    public int getMinimalWidth() {
        int ret = 0;
        ret = this.wset && !this.wrelative ? this.content.width : this.getMinimalContentWidth();
        if (this.max_size.width != -1 && ret > this.max_size.width) {
            ret = this.max_size.width;
        }
        if (this.min_size.width != -1 && ret < this.min_size.width) {
            ret = this.min_size.width;
        }
        return ret += this.declMargin.left + this.padding.left + this.border.left + this.declMargin.right + this.padding.right + this.border.right;
    }

    protected int getMinimalContentWidth() {
        int ret = 0;
        int max = 0;
        int sum = 0;
        for (int i = this.startChild; i < this.endChild; ++i) {
            Box box = this.getSubBox(i);
            if (box instanceof Inline) {
                if (this.allowsWrapping() && box.canSplitBefore()) {
                    sum = 0;
                }
                sum += box.getMinimalWidth();
            } else {
                BlockBox block = (BlockBox)box;
                if (block.position != POS_ABSOLUTE && block.position != POS_FIXED) {
                    int w = box.getMinimalWidth();
                    if (w > max) {
                        max = w;
                    }
                    sum = 0;
                }
            }
            if (sum > ret) {
                ret = sum;
            }
            if (max > ret) {
                ret = max;
            }
            if (!this.allowsWrapping() || !box.canSplitAfter()) continue;
            sum = 0;
        }
        return ret;
    }

    protected int getMinimalDecorationWidth() {
        int ret = 0;
        if (this.wset) {
            ret = this.content.width;
        }
        if (this.max_size.width != -1 && ret > this.max_size.width) {
            ret = this.max_size.width;
        }
        if (this.min_size.width != -1 && ret < this.min_size.width) {
            ret = this.min_size.width;
        }
        return ret += this.declMargin.left + this.padding.left + this.border.left + this.declMargin.right + this.padding.right + this.border.right;
    }

    @Override
    public int getMaximalWidth() {
        int ret = this.wset && !this.wrelative ? this.content.width : this.getMaximalContentWidth();
        if (this.max_size.width != -1 && ret > this.max_size.width) {
            ret = this.max_size.width;
        }
        if (this.min_size.width != -1 && ret < this.min_size.width) {
            ret = this.min_size.width;
        }
        return ret += this.declMargin.left + this.padding.left + this.border.left + this.declMargin.right + this.padding.right + this.border.right;
    }

    protected int getMaximalContentWidth() {
        int sum = 0;
        int max = 0;
        for (int i = this.startChild; i < this.endChild; ++i) {
            Box subbox = this.getSubBox(i);
            if (subbox.isBlock()) {
                BlockBox block = (BlockBox)subbox;
                if (block.getFloating() != FLOAT_NONE) {
                    sum += subbox.getMaximalWidth();
                    continue;
                }
                if (!block.isInFlow()) continue;
                int sm = subbox.getMaximalWidth();
                if (sm > max) {
                    max = sm;
                }
                if (sum > max) {
                    max = sum;
                }
                sum = 0;
                continue;
            }
            if (this.preservesLineBreaks()) {
                int sm = subbox.getMaximalWidth();
                if (sm <= max) continue;
                max = sm;
                continue;
            }
            sum += subbox.getMaximalWidth();
        }
        return Math.max(sum, max);
    }

    public int getMinimalContentWidthLimit() {
        int dif = this.declMargin.left + this.padding.left + this.border.left + this.declMargin.right + this.padding.right + this.border.right;
        int ret = this.wset ? this.content.width : (this.min_size.width != -1 ? this.min_size.width : (this.isInFlow() ? ((BlockBox)this.getContainingBlockBox()).getMinimalContentWidthLimit() - dif : 0));
        return ret;
    }

    public int getFirstInlineBoxBaseline() {
        return this.recursiveGetFirstInlineBoxBaseline(this);
    }

    protected int recursiveGetFirstInlineBoxBaseline(ElementBox root) {
        Box box = null;
        for (int i = root.startChild; i < root.endChild && !(box = root.getSubBox(i)).isInFlow(); ++i) {
            box = null;
        }
        if (box != null) {
            if (box instanceof Inline) {
                return box.getContentY() + ((Inline)((Object)box)).getBaselineOffset();
            }
            return box.getContentY() + this.recursiveGetFirstInlineBoxBaseline((ElementBox)box);
        }
        return -1;
    }

    public boolean isRelative() {
        return this.wrelative;
    }

    @Override
    public boolean hasFixedWidth() {
        return this.wset || this.isInFlow() || this.isPositioned() && !this.mleftauto && !this.mrightauto && this.leftset && this.rightset;
    }

    @Override
    public boolean hasFixedHeight() {
        return this.hset;
    }

    public int getFloatHeight() {
        if (this.fleft != null && this.fright != null) {
            int mfy = Math.max(this.fleft.getMaxYForOwner(this, true), this.fright.getMaxYForOwner(this, true));
            if (this.containsBlocks()) {
                for (int i = 0; i < this.getSubBoxNumber(); ++i) {
                    int cmfy;
                    Box subbox = this.getSubBox(i);
                    if (!(subbox instanceof BlockBox) || ((BlockBox)subbox).isPositioned() || (cmfy = ((BlockBox)subbox).getFloatHeight()) <= mfy) continue;
                    mfy = cmfy;
                }
            }
            return mfy;
        }
        return 0;
    }

    @Override
    public void draw(Box.DrawStage turn) {
        if (this.isDisplayed() && this.isDeclaredVisible() && !this.formsStackingContext()) {
            switch (turn) {
                case DRAW_NONINLINE: {
                    if (this.floating != FLOAT_NONE) break;
                    if (this.isVisible()) {
                        this.getViewport().getRenderer().renderElementBackground(this);
                    }
                    this.drawChildren(turn);
                    break;
                }
                case DRAW_FLOAT: {
                    if (this.floating != FLOAT_NONE) {
                        if (this.isVisible()) {
                            this.getViewport().getRenderer().renderElementBackground(this);
                        }
                        this.drawStackingContext(true);
                        break;
                    }
                    this.drawChildren(turn);
                    break;
                }
                case DRAW_INLINE: {
                    if (this.floating != FLOAT_NONE) break;
                    this.getViewport().getRenderer().startElementContents(this);
                    this.drawChildren(turn);
                    this.getViewport().getRenderer().finishElementContents(this);
                }
            }
        }
    }

    @Override
    protected Rectangle applyClip(Shape current, Rectangle newclip) {
        Rectangle cr = this.getClippingRectangle();
        if (cr != null) {
            return super.applyClip(current, newclip.intersection(cr));
        }
        return super.applyClip(current, newclip);
    }

    @Override
    public Rectangle getClippedBounds() {
        Rectangle cr = this.getClippingRectangle();
        if (cr == null) {
            return super.getClippedBounds();
        }
        return super.getClippedBounds().intersection(cr);
    }

    @Override
    public Rectangle getClippedContentBounds() {
        Rectangle cr = this.getClippingRectangle();
        if (cr == null) {
            return super.getClippedContentBounds();
        }
        return super.getClippedContentBounds().intersection(cr);
    }

    protected Rectangle getClippingRectangle() {
        if (this.clipRegion != null) {
            List args = (List)this.clipRegion.getValue();
            CSSDecoder dec = new CSSDecoder(this.ctx);
            Rectangle brd = this.getAbsoluteBorderBounds();
            int x1 = brd.x;
            int y1 = brd.y;
            int x2 = brd.x + brd.width - 1;
            int y2 = brd.y + brd.height - 1;
            TermLength top = (TermLength)args.get(0);
            TermLength right = (TermLength)args.get(1);
            TermLength bottom = (TermLength)args.get(2);
            TermLength left = (TermLength)args.get(3);
            if (left != null) {
                x1 = brd.x + dec.getLength((TermLengthOrPercent)left, false, 0, 0, 0);
            }
            if (top != null) {
                y1 = brd.y + dec.getLength((TermLengthOrPercent)top, false, 0, 0, 0);
            }
            if (right != null) {
                x2 = brd.x + dec.getLength((TermLengthOrPercent)right, false, 0, 0, 0);
            }
            if (bottom != null) {
                y2 = brd.y + dec.getLength((TermLengthOrPercent)bottom, false, 0, 0, 0);
            }
            return new Rectangle(x1, y1, x2 - x1, y2 - y1);
        }
        return null;
    }

    protected void loadBlockStyle() {
        CSSProperty.Clip clip;
        this.floating = (CSSProperty.Float)this.style.getProperty("float");
        if (this.floating == null) {
            this.floating = FLOAT_NONE;
        }
        this.clearing = (CSSProperty.Clear)this.style.getProperty("clear");
        if (this.clearing == null) {
            this.clearing = CLEAR_NONE;
        }
        this.overflowX = (CSSProperty.Overflow)this.style.getProperty("overflow-x");
        if (this.overflowX == null) {
            this.overflowX = OVERFLOW_VISIBLE;
        }
        this.overflowY = (CSSProperty.Overflow)this.style.getProperty("overflow-y");
        if (this.overflowY == null) {
            this.overflowY = OVERFLOW_VISIBLE;
        }
        if (this.overflowX == OVERFLOW_VISIBLE && this.overflowY != OVERFLOW_VISIBLE) {
            this.overflowX = OVERFLOW_AUTO;
        } else if (this.overflowY == OVERFLOW_VISIBLE && this.overflowX != OVERFLOW_VISIBLE) {
            this.overflowY = OVERFLOW_AUTO;
        }
        this.boxSizing = (CSSProperty.BoxSizing)this.style.getProperty("box-sizing");
        if (this.boxSizing == null) {
            this.boxSizing = CONTENT_BOX;
        }
        this.align = (CSSProperty.TextAlign)this.style.getProperty("text-align");
        if (this.align == null) {
            this.align = ALIGN_LEFT;
        }
        if (this.display == ElementBox.DISPLAY_NONE) {
            this.position = POS_STATIC;
            this.floating = FLOAT_NONE;
        } else if (this.position == POS_ABSOLUTE || this.position == POS_FIXED) {
            this.floating = FLOAT_NONE;
        }
        if (this.position == POS_ABSOLUTE && (clip = (CSSProperty.Clip)this.style.getProperty("clip")) == CSSProperty.Clip.shape) {
            this.clipRegion = (TermRect)this.style.getValue(TermRect.class, "clip");
        }
    }

    protected int blockWidth() {
        return this.content.width;
    }

    protected int blockHeight() {
        return this.content.height;
    }

    protected int maxFloatWidth(int y1, int y2) {
        int ret = 0;
        for (int y = y1; y <= y2; ++y) {
            int w = this.fleft.getWidth(y) + this.fright.getWidth(y);
            if (w <= ret) continue;
            ret = w;
        }
        return ret;
    }

    protected int[] computeFloatLimits(int y1, int y2, int[] fx) {
        int nexty;
        int fy = y1;
        while (fy < y2 && (nexty = FloatList.getNextY(this.fleft, this.fright, fy)) != -1) {
            int frx;
            fy = nexty;
            if (fy >= y2) continue;
            int flx = this.fleft.getWidth(fy) - this.floatXl;
            if (flx < 0) {
                flx = 0;
            }
            if ((frx = this.fright.getWidth(fy) - this.floatXr) < 0) {
                frx = 0;
            }
            if (fx[0] < flx) {
                fx[0] = flx;
            }
            if (fx[1] >= frx) continue;
            fx[1] = frx;
        }
        return fx;
    }

    @Override
    protected void loadSizes() {
        this.loadSizes(false);
    }

    @Override
    public void updateSizes() {
        this.loadSizes(true);
    }

    protected void loadSizes(boolean update) {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        int contw = this.getContainingBlock().width;
        int conth = this.getContainingBlock().height;
        if (!update) {
            this.loadBorders(dec, contw);
        }
        this.loadPadding(dec, contw);
        this.loadPosition();
        if (!update) {
            this.content = new Dimension(0, 0);
            this.margin = new LengthSet();
            this.declMargin = new LengthSet();
        }
        this.loadWidthsHeights(dec, contw, conth, update);
        if (!update) {
            this.emargin = new LengthSet(this.margin);
            this.widthAdjust = 0;
        } else {
            this.emargin.left = this.margin.left;
            this.emargin.right = this.margin.right;
        }
        this.indent = dec.getLength(this.getLengthValue("text-indent"), false, 0, 0, contw);
    }

    protected void loadPadding(CSSDecoder dec, int contw) {
        this.padding = new LengthSet();
        this.padding.top = dec.getLength(this.getLengthValue("padding-top"), false, null, null, contw);
        this.padding.right = dec.getLength(this.getLengthValue("padding-right"), false, null, null, contw);
        this.padding.bottom = dec.getLength(this.getLengthValue("padding-bottom"), false, null, null, contw);
        this.padding.left = dec.getLength(this.getLengthValue("padding-left"), false, null, null, contw);
    }

    protected void loadWidthsHeights(CSSDecoder dec, int contw, int conth, boolean update) {
        TermLengthOrPercent height;
        TermLengthOrPercent width;
        TermLengthOrPercent minw = this.getLengthValue("min-width");
        TermLengthOrPercent minh = this.getLengthValue("min-height");
        boolean autoMinW = false;
        boolean autoMinH = minh != null && minh.isPercentage() && !this.getContainingBlockBox().hasFixedHeight();
        this.min_size = new Dimension(dec.getLength(minw, autoMinW, -1, -1, contw), dec.getLength(minh, autoMinH, -1, -1, conth));
        TermLengthOrPercent maxw = this.getLengthValue("max-width");
        TermLengthOrPercent maxh = this.getLengthValue("max-height");
        boolean autoMaxW = this.style.getProperty("max-width") == CSSProperty.MaxWidth.NONE;
        boolean autoMaxH = this.style.getProperty("max-height") == CSSProperty.MaxHeight.NONE || maxh != null && maxh.isPercentage() && !this.getContainingBlockBox().hasFixedHeight();
        this.max_size = new Dimension(dec.getLength(maxw, autoMaxW, -1, -1, contw), dec.getLength(maxh, autoMaxH, -1, -1, conth));
        if (this.max_size.width != -1 && this.max_size.width < this.min_size.width) {
            this.max_size.width = this.min_size.width;
        }
        if (this.max_size.height != -1 && this.max_size.height < this.min_size.height) {
            this.max_size.height = this.min_size.height;
        }
        boolean wauto = (width = this.getLengthValue("width")) == null || this.style.getProperty("width") == CSSProperty.Width.AUTO;
        this.computeWidths(width, wauto, true, update);
        if (this.max_size.width != -1 && this.content.width > this.max_size.width) {
            width = this.getLengthValue("max-width");
            this.computeWidths(width, false, false, update);
        }
        if (this.min_size.width != -1 && this.content.width < this.min_size.width) {
            width = this.getLengthValue("min-width");
            this.computeWidths(width, false, false, update);
        }
        boolean hauto = (height = this.getLengthValue("height")) == null || this.style.getProperty("height") == CSSProperty.Height.AUTO;
        this.computeHeights(height, hauto, true, update);
        if (this.max_size.height != -1 && this.content.height > this.max_size.height) {
            height = this.getLengthValue("max-height");
            this.computeHeights(height, false, false, update);
        }
        if (this.min_size.height != -1 && this.content.height < this.min_size.height) {
            height = this.getLengthValue("min-height");
            this.computeHeights(height, false, false, update);
        }
        if (this.boxSizing == BORDER_BOX) {
            if (!wauto) {
                this.content.width -= this.border.left + this.border.right + this.padding.left + this.padding.right;
                if (this.content.width < 0) {
                    this.content.width = 0;
                }
            }
            if (!hauto) {
                this.content.height -= this.border.top + this.border.bottom + this.padding.top + this.padding.bottom;
                if (this.content.height < 0) {
                    this.content.height = 0;
                }
            }
        }
        if (update && this.widthAdjust != 0) {
            if (!this.wset) {
                this.content.width += this.widthAdjust;
            } else if (this.mleftauto) {
                this.margin.left += this.widthAdjust;
            } else {
                this.margin.right += this.widthAdjust;
            }
        }
    }

    protected void computeWidths(TermLengthOrPercent width, boolean auto, boolean exact, boolean update) {
        this.mleftauto = this.style.getProperty("margin-left") == CSSProperty.Margin.AUTO;
        boolean bl = this.mrightauto = this.style.getProperty("margin-right") == CSSProperty.Margin.AUTO;
        if (this.position == POS_ABSOLUTE || this.position == POS_FIXED) {
            this.computeWidthsAbsolute(width, auto, exact, this.getContainingBlock().width, update);
        } else {
            this.computeWidthsInFlow(width, auto, exact, this.getContainingBlock().width, update);
        }
    }

    protected void computeWidthsInFlow(TermLengthOrPercent width, boolean auto, boolean exact, int contw, boolean update) {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (width == null) {
            auto = true;
        }
        TermLengthOrPercent mleft = this.getLengthValue("margin-left");
        TermLengthOrPercent mright = this.getLengthValue("margin-right");
        if (!this.widthComputed) {
            update = false;
        }
        if (auto) {
            if (exact) {
                this.wset = false;
            }
            this.margin.left = dec.getLength(mleft, this.mleftauto, 0, 0, contw);
            this.margin.right = dec.getLength(mright, this.mrightauto, 0, 0, contw);
            this.declMargin.left = this.margin.left;
            this.declMargin.right = this.margin.right;
            if (!update || this.isInFlow()) {
                this.content.width = contw - this.margin.left - this.border.left - this.padding.left - this.padding.right - this.border.right - this.margin.right;
                if (this.content.width < 0) {
                    this.content.width = 0;
                }
            }
        } else {
            boolean prefer;
            if (exact) {
                this.wset = true;
                this.wrelative = width.isPercentage();
            }
            this.content.width = dec.getLength(width, auto, 0, 0, contw);
            this.margin.left = dec.getLength(mleft, this.mleftauto, 0, 0, contw);
            this.margin.right = dec.getLength(mright, this.mrightauto, 0, 0, contw);
            this.declMargin.left = this.margin.left;
            this.declMargin.right = this.margin.right;
            boolean bl = prefer = !width.isPercentage();
            if (this.isInFlow() && prefer) {
                if (this.mleftauto && this.mrightauto) {
                    int rest = contw - this.content.width - this.border.left - this.padding.left - this.padding.right - this.border.right;
                    if (rest >= 0) {
                        this.margin.left = (rest + 1) / 2;
                        this.margin.right = rest / 2;
                    } else {
                        this.margin.left = 0;
                        this.margin.right = rest;
                    }
                } else if (this.mleftauto) {
                    this.margin.left = contw - this.content.width - this.border.left - this.padding.left - this.padding.right - this.border.right - this.margin.right;
                } else if (this.mrightauto) {
                    this.margin.right = contw - this.content.width - this.border.left - this.padding.left - this.padding.right - this.border.right - this.margin.left;
                    if (this.margin.right < 0 && this.getContainingBlockBox() instanceof BlockBox && ((BlockBox)this.getContainingBlockBox()).canIncreaseWidth()) {
                        this.margin.right = 0;
                    }
                } else {
                    this.margin.right = contw - this.content.width - this.border.left - this.padding.left - this.padding.right - this.border.right - this.margin.left;
                    if (this.margin.right < 0 && this.getContainingBlockBox() instanceof BlockBox && ((BlockBox)this.getContainingBlockBox()).canIncreaseWidth()) {
                        this.margin.right = 0;
                    }
                }
            }
        }
    }

    protected void computeWidthsAbsolute(TermLengthOrPercent width, boolean auto, boolean exact, int contw, boolean update) {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (width == null) {
            auto = true;
        }
        TermLengthOrPercent mleft = this.getLengthValue("margin-left");
        TermLengthOrPercent mright = this.getLengthValue("margin-right");
        if (!this.widthComputed) {
            update = false;
        }
        if (auto) {
            if (exact) {
                this.wset = false;
            }
            if (!update) {
                this.content.width = dec.getLength(width, auto, 0, 0, contw);
            }
        } else {
            if (exact) {
                this.wset = true;
                this.wrelative = width.isPercentage();
            }
            this.content.width = dec.getLength(width, auto, 0, 0, contw);
        }
        int constr = 0;
        if (this.wset) {
            ++constr;
        }
        if (this.leftset) {
            ++constr;
        }
        if (this.rightset) {
            ++constr;
        }
        if (constr < 3) {
            this.margin.left = this.mleftauto ? 0 : dec.getLength(mleft, false, 0, 0, contw);
            this.margin.right = this.mrightauto ? 0 : dec.getLength(mright, false, 0, 0, contw);
        } else if (this.mleftauto && this.mrightauto) {
            int rest = contw - this.coords.left - this.coords.right - this.border.left - this.border.right - this.padding.left - this.padding.right - this.content.width;
            this.margin.left = (rest + 1) / 2;
            this.margin.right = rest / 2;
        } else if (this.mleftauto) {
            this.margin.right = dec.getLength(mright, false, 0, 0, contw);
            this.margin.left = contw - this.coords.right - this.border.left - this.border.right - this.padding.left - this.padding.right - this.content.width - this.margin.right;
        } else if (this.mrightauto) {
            this.margin.left = dec.getLength(mleft, false, 0, 0, contw);
            this.margin.right = contw - this.coords.right - this.border.left - this.border.right - this.padding.left - this.padding.right - this.content.width - this.margin.left;
        } else {
            this.margin.left = dec.getLength(mleft, false, 0, 0, contw);
            this.margin.right = dec.getLength(mright, false, 0, 0, contw);
        }
        this.declMargin.left = this.margin.left;
        this.declMargin.right = this.margin.right;
        if (!this.leftset && !this.rightset) {
            this.leftstatic = true;
            this.coords.right = contw - this.coords.left - this.border.left - this.border.right - this.padding.left - this.padding.right - this.content.width - this.margin.left - this.margin.right;
        } else if (!this.leftset) {
            this.coords.left = contw - this.coords.right - this.border.left - this.border.right - this.padding.left - this.padding.right - this.content.width - this.margin.left - this.margin.right;
        } else if (!this.rightset) {
            this.coords.right = contw - this.coords.left - this.border.left - this.border.right - this.padding.left - this.padding.right - this.content.width - this.margin.left - this.margin.right;
        } else if (auto) {
            this.content.width = contw - this.coords.left - this.coords.right - this.border.left - this.border.right - this.padding.left - this.padding.right - this.margin.left - this.margin.right;
        } else {
            this.coords.right = contw - this.coords.left - this.border.left - this.border.right - this.padding.left - this.padding.right - this.content.width - this.margin.left - this.margin.right;
        }
    }

    protected void computeHeights(TermLengthOrPercent height, boolean auto, boolean exact, boolean update) {
        Rectangle cb = this.getContainingBlock();
        if (this.position == POS_ABSOLUTE || this.position == POS_FIXED) {
            this.computeHeightsAbsolute(height, auto, exact, cb.width, cb.height, update);
        } else {
            this.computeHeightsInFlow(height, auto, exact, cb.width, cb.height, update);
        }
        this.declMargin.top = this.margin.top;
        this.declMargin.bottom = this.margin.bottom;
    }

    protected void computeHeightsInFlow(TermLengthOrPercent height, boolean auto, boolean exact, int contw, int conth, boolean update) {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (height == null) {
            auto = true;
        }
        boolean mtopauto = this.style.getProperty("margin-top") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mtop = this.getLengthValue("margin-top");
        boolean mbottomauto = this.style.getProperty("margin-bottom") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mbottom = this.getLengthValue("margin-bottom");
        if (!auto) {
            if (exact) {
                this.hset = true;
            }
            if (!update) {
                this.content.height = dec.getLength(height, false, 0, 0, conth);
            }
        } else if (exact) {
            this.hset = false;
        }
        this.margin.top = mtopauto ? 0 : dec.getLength(mtop, false, 0, 0, contw);
        this.margin.bottom = mbottomauto ? 0 : dec.getLength(mbottom, false, 0, 0, contw);
    }

    protected void computeHeightsAbsolute(TermLengthOrPercent height, boolean auto, boolean exact, int contw, int conth, boolean update) {
        LengthSet m;
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (height == null) {
            auto = true;
        }
        boolean mtopauto = this.style.getProperty("margin-top") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mtop = this.getLengthValue("margin-top");
        boolean mbottomauto = this.style.getProperty("margin-bottom") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mbottom = this.getLengthValue("margin-bottom");
        if (!auto && height != null) {
            this.hset = exact;
            if (!update) {
                this.content.height = dec.getLength(height, auto, 0, 0, conth);
            }
        } else {
            this.hset = false;
        }
        int constr = 0;
        if (this.hset) {
            ++constr;
        }
        if (this.topset) {
            ++constr;
        }
        if (this.bottomset) {
            ++constr;
        }
        if (constr < 3) {
            this.margin.top = mtopauto ? 0 : dec.getLength(mtop, false, 0, 0, contw);
            this.margin.bottom = mbottomauto ? 0 : dec.getLength(mbottom, false, 0, 0, contw);
        } else if (mtopauto && mbottomauto) {
            int rest = conth - this.coords.top - this.coords.bottom - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - this.content.height;
            this.margin.top = (rest + 1) / 2;
            this.margin.bottom = rest / 2;
        } else if (mtopauto) {
            this.margin.bottom = dec.getLength(mbottom, false, 0, 0, contw);
            this.margin.top = conth - this.coords.top - this.coords.bottom - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - this.content.height - this.margin.bottom;
        } else if (mbottomauto) {
            this.margin.top = dec.getLength(mtop, false, 0, 0, contw);
            this.margin.bottom = conth - this.coords.top - this.coords.bottom - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - this.content.height - this.margin.top;
        } else {
            this.margin.top = dec.getLength(mtop, false, 0, 0, contw);
            this.margin.bottom = dec.getLength(mbottom, false, 0, 0, contw);
        }
        LengthSet lengthSet = m = update ? this.emargin : this.margin;
        if (!this.topset && !this.bottomset) {
            this.topstatic = true;
            this.coords.bottom = conth - this.coords.top - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - m.top - m.bottom - this.content.height;
        } else if (!this.topset) {
            this.coords.top = conth - this.coords.bottom - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - m.top - m.bottom - this.content.height;
        } else if (!this.bottomset) {
            this.coords.bottom = conth - this.coords.top - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - m.top - m.bottom - this.content.height;
        } else if (auto) {
            this.content.height = conth - this.coords.top - this.coords.bottom - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - m.top - m.bottom;
        } else {
            this.coords.bottom = conth - this.coords.top - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - m.top - m.bottom - this.content.height;
        }
    }

    protected boolean separatedFromTop(ElementBox box) {
        return box.border.top > 0 || box.padding.top > 0 || box.isRootElement();
    }

    protected boolean separatedFromBottom(ElementBox box) {
        return box.border.bottom > 0 || box.padding.bottom > 0 || box.isRootElement();
    }

    protected int collapsedMarginHeight(int m1, int m2) {
        if (m1 >= 0 && m2 >= 0) {
            return Math.max(m1, m2);
        }
        if (m1 < 0 && m2 < 0) {
            return Math.min(m1, m2);
        }
        return m1 + m2;
    }

    protected void clearSplitted() {
        Iterator it = this.nested.iterator();
        while (it.hasNext()) {
            Box box = (Box)it.next();
            if (!box.splitted) continue;
            it.remove();
            --this.endChild;
        }
    }
}

