/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.fit.cssbox.io.ContentObserver;
import org.fit.cssbox.io.DOMSource;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.ImageCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserConfig {
    private static Logger log = LoggerFactory.getLogger(BrowserConfig.class);
    private Color viewportBackgroundColor = Color.WHITE;
    private boolean loadImages = true;
    private boolean loadBackgroundImages = true;
    private boolean loadFonts = true;
    private int imageLoadTimeout = 500;
    private boolean useHTML = true;
    private boolean replaceImagesWithAlt = false;
    private boolean clipViewport = false;
    private Class<? extends DocumentSource> documentSourceClass = DefaultDocumentSource.class;
    private Class<? extends DOMSource> domSourceClass = DefaultDOMSource.class;
    private ContentObserver contentObserver = null;
    private ImageCache imageCache;
    private Map<String, String> defaultFonts;

    public BrowserConfig() {
        this.initDefaultFonts();
    }

    public Color getViewportBackgroundColor() {
        return this.viewportBackgroundColor;
    }

    public void setViewportBackgroundColor(Color viewportBackgroundColor) {
        this.viewportBackgroundColor = viewportBackgroundColor;
    }

    public boolean getLoadImages() {
        return this.loadImages;
    }

    public void setLoadImages(boolean loadImages) {
        this.loadImages = loadImages;
    }

    public boolean getLoadBackgroundImages() {
        return this.loadBackgroundImages;
    }

    public void setLoadFonts(boolean loadFonts) {
        this.loadFonts = loadFonts;
    }

    public boolean isLoadFonts() {
        return this.loadFonts;
    }

    public void setLoadBackgroundImages(boolean loadBackgroundImages) {
        this.loadBackgroundImages = loadBackgroundImages;
    }

    public int getImageLoadTimeout() {
        return this.imageLoadTimeout;
    }

    public void setImageLoadTimeout(int imageLoadTimeout) {
        this.imageLoadTimeout = imageLoadTimeout;
    }

    public void setContentObserver(ContentObserver contentObserver) {
        this.contentObserver = contentObserver;
    }

    public ContentObserver getContentObserver() {
        return this.contentObserver;
    }

    public ImageCache getImageCache() {
        return this.imageCache;
    }

    public void setImageCache(ImageCache imageCache) {
        this.imageCache = imageCache;
    }

    public boolean getUseHTML() {
        return this.useHTML;
    }

    public void setUseHTML(boolean useHTML) {
        this.useHTML = useHTML;
    }

    public boolean getReplaceImagesWithAlt() {
        return this.replaceImagesWithAlt;
    }

    public void setReplaceImagesWithAlt(boolean replaceImagesWithAlt) {
        this.replaceImagesWithAlt = replaceImagesWithAlt;
    }

    public boolean getClipViewport() {
        return this.clipViewport;
    }

    public void setClipViewport(boolean clipViewport) {
        this.clipViewport = clipViewport;
    }

    public void registerDocumentSource(Class<? extends DocumentSource> documentSourceClass) {
        this.documentSourceClass = documentSourceClass;
    }

    public Class<? extends DocumentSource> getDocumentSourceClass() {
        return this.documentSourceClass;
    }

    public DocumentSource createDocumentSource(URL url) throws IOException {
        try {
            Constructor<? extends DocumentSource> constr = this.getDocumentSourceClass().getConstructor(URL.class);
            return constr.newInstance(url);
        }
        catch (Exception e) {
            Throwable cause = e;
            while (cause != null && !(cause instanceof IOException)) {
                cause = e.getCause();
            }
            if (cause != null && cause instanceof IOException) {
                throw (IOException)cause;
            }
            log.error("Could not create the DocumentSource instance: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public DocumentSource createDocumentSource(URL base, String urlstring) {
        try {
            Constructor<? extends DocumentSource> constr = this.getDocumentSourceClass().getConstructor(URL.class, String.class);
            return constr.newInstance(base, urlstring);
        }
        catch (Exception e) {
            log.warn("Could not create the DocumentSource instance: " + e.getMessage());
            return null;
        }
    }

    public void registerDOMSource(Class<? extends DOMSource> domSourceClass) {
        this.domSourceClass = domSourceClass;
    }

    public Class<? extends DOMSource> getDOMSourceClass() {
        return this.domSourceClass;
    }

    public DOMSource createDOMSource(DocumentSource src) {
        try {
            Constructor<? extends DOMSource> constr = this.getDOMSourceClass().getConstructor(DocumentSource.class);
            return constr.newInstance(src);
        }
        catch (Exception e) {
            log.warn("BoxFactory: Warning: could not create the DOMSource instance: " + e.getMessage());
            return null;
        }
    }

    public void setDefaultFont(String logical, String physical) {
        this.defaultFonts.put(logical, physical);
    }

    public String getDefaultFont(String logical) {
        return this.defaultFonts.get(logical);
    }

    protected void initDefaultFonts() {
        this.defaultFonts = new HashMap<String, String>(3);
        this.defaultFonts.put("Serif", "Serif");
        this.defaultFonts.put("SansSerif", "SansSerif");
        this.defaultFonts.put("Monospaced", "Monospaced");
    }
}

