/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.stream.ImageInputStream;
import org.fit.cssbox.io.ContentObserver;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.ImageCache;
import org.fit.cssbox.layout.ReplacedContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContentImage
extends ReplacedContent
implements ImageObserver,
IIOReadUpdateListener {
    private static Logger log = LoggerFactory.getLogger(ContentImage.class);
    protected final int DEFAULT_IMAGE_WIDTH = 0;
    protected final int DEFAULT_IMAGE_HEIGHT = 0;
    protected int loadTimeout;
    protected boolean loadImages = true;
    protected boolean caching = true;
    protected URL url;
    protected Image image;
    protected int width = -1;
    protected int height = -1;
    protected ImageObserver observer = this;
    protected Container container = null;
    protected Toolkit toolkit = Toolkit.getDefaultToolkit();
    protected boolean abort = false;
    protected boolean complete = false;

    public ContentImage(ElementBox owner) {
        super(owner);
        this.loadTimeout = owner.getViewport().getConfig().getImageLoadTimeout();
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public Container getContainer() {
        return this.container;
    }

    protected void repaint(int t) {
        if (this.container != null) {
            Rectangle bounds = this.owner.getAbsoluteBounds();
            this.container.repaint(t, bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    protected Image loadImage(boolean cache) {
        if (this.url != null) {
            Image img;
            ImageCache imageCache = this.getImageCache(cache);
            if (imageCache != null) {
                img = imageCache.get(this.url);
                if (img == null && !imageCache.hasFailed(this.url)) {
                    img = this.loadImageFromSource(this.url);
                    if (img != null) {
                        imageCache.put(this.url, img);
                    } else {
                        imageCache.putFailed(this.url);
                    }
                }
            } else {
                img = this.loadImageFromSource(this.url);
            }
            if (img != null) {
                this.toolkit.prepareImage(img, -1, -1, this.observer);
                return img;
            }
            this.observeLoadFailed(this.url);
        }
        return null;
    }

    private ImageCache getImageCache(boolean cache) {
        return cache ? this.getOwner().getViewport().getConfig().getImageCache() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Image loadImageFromSource(URL url) {
        BufferedImage image = null;
        try (DocumentSource imgsrc = this.owner.getViewport().getConfig().createDocumentSource(url);){
            InputStream urlStream = imgsrc.getInputStream();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(urlStream);
            try {
                Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageInputStream);
                if (!imageReaders.hasNext()) {
                    log.warn("No image readers for URL: " + url);
                    log.warn("  owner: " + this.getOwner());
                    return image;
                }
                do {
                    ImageReader currentImageReader = imageReaders.next();
                    currentImageReader.setInput(imageInputStream);
                    currentImageReader.addIIOReadUpdateListener(this);
                    try {
                        image = currentImageReader.read(0);
                    }
                    catch (Exception e) {
                        log.error("Image decoding error: " + e.getMessage() + " with reader " + currentImageReader);
                    }
                    finally {
                        currentImageReader.dispose();
                    }
                    if (image != null) return image;
                } while (imageReaders.hasNext());
                return image;
            }
            catch (Exception e) {
                log.error("Image decoding error: " + e.getMessage());
            }
            return image;
        }
        catch (IOException e) {
            log.error("Unable to get image from: " + url);
            log.error(e.getMessage());
        }
        return image;
    }

    private void observeLoadFailed(URL url) {
        ContentObserver observer = this.getOwner().getViewport().getConfig().getContentObserver();
        if (observer != null) {
            observer.contentLoadFailed(url);
        }
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean val) {
        this.caching = val;
    }

    public URL getUrl() {
        return this.url;
    }

    public Image getImage() {
        return this.image;
    }

    public BufferedImage getBufferedImage() {
        if (this.image == null || this.abort) {
            return null;
        }
        if (this.container == null) {
            this.waitForLoad();
        }
        BufferedImage img = new BufferedImage(this.getIntrinsicWidth(), this.getIntrinsicHeight(), 2);
        Graphics2D g = img.createGraphics();
        g.drawImage(this.image, null, null);
        g.dispose();
        return img;
    }

    public void setImageObserver(ImageObserver observer) {
        this.observer = observer;
    }

    public ImageObserver getImageObserver() {
        return this.observer;
    }

    @Override
    public int getIntrinsicHeight() {
        if (this.height > -1) {
            return this.height;
        }
        if (this.loadImages) {
            if (this.image == null) {
                this.image = this.loadImage(this.caching);
            }
            this.height = this.obtainImageHeight();
            return this.height;
        }
        return 0;
    }

    @Override
    public int getIntrinsicWidth() {
        if (this.width > -1) {
            return this.width;
        }
        if (this.loadImages) {
            if (this.image == null) {
                this.image = this.loadImage(this.caching);
            }
            this.width = this.obtainImageWidth();
            return this.width;
        }
        return 0;
    }

    private int obtainImageWidth() {
        int width = -1;
        this.abort = false;
        int loadtime = 0;
        while (!this.abort && this.image != null && (width = this.image.getWidth(this.observer)) == -1) {
            try {
                if (loadtime > this.loadTimeout) {
                    this.image = null;
                    this.abort = true;
                    log.warn("obtainImageWidth(): Image loading aborted for timeout: " + this.url + " " + loadtime);
                }
                Thread.sleep(25L);
                loadtime += 25;
            }
            catch (Exception e) {
                this.image = null;
                this.abort = true;
                log.warn("obtainImageWidth(): Image loading aborted: " + e.getMessage());
            }
        }
        if (width == -1) {
            width = 0;
        }
        return width;
    }

    private int obtainImageHeight() {
        int height = -1;
        this.abort = false;
        int loadtime = 0;
        while (!this.abort && this.image != null && (height = this.image.getHeight(this.observer)) == -1) {
            try {
                if (loadtime > this.loadTimeout) {
                    this.image = null;
                    this.abort = true;
                    log.warn("obtainImageHeight(): Image loading aborted for timeout: " + this.url);
                } else {
                    Thread.sleep(25L);
                }
                loadtime += 25;
            }
            catch (Exception e) {
                this.image = null;
                this.abort = true;
                log.warn("obtainImageHeight(): Image loading aborted: " + e.getMessage());
            }
        }
        if (height == -1) {
            height = 0;
        }
        return height;
    }

    @Override
    public float getIntrinsicRatio() {
        return (float)this.getIntrinsicWidth() / (float)this.getIntrinsicHeight();
    }

    public void dispose() {
        if (this.image != null) {
            this.image.flush();
        }
        this.image = null;
    }

    public void reset() {
        this.abort = false;
        this.complete = false;
        this.width = -1;
        this.height = -1;
        if (this.image != null) {
            this.image.flush();
        }
        this.image = null;
    }

    public synchronized void abort() {
        this.abort = true;
        this.image = null;
    }

    public boolean waitForLoad() {
        this.abort = false;
        int loadtime = 0;
        while (!this.abort && this.image != null && (this.height = this.image.getHeight(this.observer)) == -1) {
            try {
                if (loadtime > this.loadTimeout) {
                    this.image = null;
                    this.abort = true;
                    log.warn("waitForLoad(): Image loading aborted for timeout: " + this.url + " " + loadtime);
                }
                Thread.sleep(25L);
                loadtime += 25;
            }
            catch (Exception e) {
                this.image = null;
                this.abort = true;
                log.warn("waitForLoad(): Image loading aborted: " + e.getMessage());
            }
        }
        if (this.image == null) {
            this.observeLoadFailed(this.url);
        }
        return this.complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int newWidth, int newHeight) {
        if ((flags & 0xC0) != 0) {
            ContentImage contentImage = this;
            synchronized (contentImage) {
                if (this.image == img) {
                    this.abort();
                }
            }
            this.repaint(0);
            return false;
        }
        if ((flags & 0x30) != 0) {
            this.repaint(0);
        }
        if ((flags & 0x20) != 0) {
            this.complete = true;
        }
        return (flags & 0x20) == 0;
    }

    @Override
    public void imageUpdate(ImageReader source, BufferedImage theImage, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
        if (this.image == null || !this.image.equals(theImage)) {
            this.repaint(0);
            this.image = theImage;
        }
    }

    @Override
    public void passComplete(ImageReader source, BufferedImage theImage) {
        if (this.image == null || !this.image.equals(theImage)) {
            this.repaint(0);
            this.image = theImage;
        }
    }

    @Override
    public void passStarted(ImageReader source, BufferedImage theImage, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
        if (this.image == null || !this.image.equals(theImage)) {
            this.repaint(0);
            this.image = theImage;
        }
    }

    @Override
    public void thumbnailPassComplete(ImageReader source, BufferedImage theThumbnail) {
    }

    @Override
    public void thumbnailPassStarted(ImageReader source, BufferedImage theThumbnail, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
    }

    @Override
    public void thumbnailUpdate(ImageReader source, BufferedImage theThumbnail, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
    }
}

