/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.util.ArrayList;
import java.util.List;
import org.fit.cssbox.layout.BlockBox;

public class FloatList {
    private BlockBox owner;
    private List<BlockBox> floats;
    private BlockBox bottomBox = null;
    private BlockBox lastBox = null;

    public FloatList(BlockBox ownerBox) {
        this.owner = ownerBox;
        this.floats = new ArrayList<BlockBox>();
    }

    public BlockBox getOwner() {
        return this.owner;
    }

    public void add(BlockBox box) {
        box.setOwnerFloatList(this);
        this.floats.add(box);
        if (box.getBounds().y + box.getBounds().height > this.getMaxY()) {
            this.bottomBox = box;
        }
        if (box.getBounds().y > this.getLastY()) {
            this.lastBox = box;
        }
    }

    public int size() {
        return this.floats.size();
    }

    public BlockBox getBox(int index) {
        return this.floats.get(index);
    }

    public int getMaxY() {
        if (this.bottomBox == null) {
            return 0;
        }
        return this.bottomBox.getBounds().y + this.bottomBox.getBounds().height;
    }

    public int getLastY() {
        if (this.lastBox == null) {
            return 0;
        }
        return this.lastBox.getBounds().y;
    }

    public int getWidth(int y) {
        int maxx = 0;
        for (int i = 0; i < this.size(); ++i) {
            int wx;
            BlockBox box = this.getBox(i);
            if (box.getBounds().y > y || box.getBounds().y + box.getBounds().height <= y || (wx = box.getBounds().x + box.getBounds().width) <= maxx) continue;
            maxx = wx;
        }
        return maxx;
    }

    public int getNextY(int y) {
        int maxx = 0;
        int nexty = -1;
        for (int i = 0; i < this.size(); ++i) {
            int wx;
            BlockBox box = this.getBox(i);
            if (box.getBounds().y > y || box.getBounds().y + box.getBounds().height <= y || (wx = box.getBounds().x + box.getBounds().width) <= maxx) continue;
            maxx = wx;
            nexty = box.getBounds().y + box.getBounds().height;
        }
        return nexty;
    }

    public int getMaxYForOwner(BlockBox owner, boolean requireVisible) {
        int maxy = 0;
        for (int i = 0; i < this.size(); ++i) {
            int ny;
            BlockBox box = this.getBox(i);
            if (requireVisible && !box.isDeclaredVisible() || box.getContainingBlockBox() != owner || (ny = box.bounds.y + box.bounds.height) <= maxy) continue;
            maxy = ny;
        }
        return maxy;
    }

    public static int getNextY(FloatList fleft, FloatList fright, int y) {
        int fy = y;
        int nexty1 = fleft.getNextY(fy);
        int nexty2 = fright.getNextY(fy);
        fy = nexty1 != -1 && nexty2 != -1 ? Math.min(nexty1, nexty2) : (nexty2 != -1 ? nexty2 : (nexty1 != -1 ? nexty1 : -1));
        return fy;
    }
}

