/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.Inline;
import org.fit.cssbox.layout.InlineElement;
import org.fit.cssbox.layout.VisualContext;

public class LineBox {
    private ElementBox parent;
    private int start;
    private int y;
    private int end;
    private int width;
    private int left;
    private int right;
    private int above;
    private int below;
    private int maxAlignedHeight;
    private int maxBoxHeight;
    private int heightFromBottom;

    public LineBox(ElementBox parent, int start, int y) {
        this.parent = parent;
        this.start = start;
        this.y = y;
        this.width = 0;
        this.left = 0;
        this.right = 0;
        this.above = 0;
        this.below = 0;
    }

    public String toString() {
        return "LineBox " + this.start + ".." + this.end + " y=" + this.y + " width=" + this.width + " above=" + this.above + " below=" + this.below + " total=" + (this.above + this.below) + " alignedHeight=" + this.maxAlignedHeight + " lead=" + this.getLead();
    }

    public ElementBox getParent() {
        return this.parent;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getY() {
        return this.y;
    }

    public int getAbsoluteY() {
        return this.parent.getAbsoluteContentY() + this.y;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getLeftLimit() {
        return this.left;
    }

    public int getRightLimit() {
        return this.right;
    }

    public int getLimits() {
        return this.left + this.right;
    }

    public void setLimits(int left, int right) {
        this.left = left;
        this.right = right;
    }

    public int getTotalLineHeight() {
        return this.above + this.below;
    }

    public int getTopOffset() {
        int ofs = this.heightFromBottom - this.getMaxAlignedHeight();
        return ofs >= 0 ? ofs : 0;
    }

    public int getMaxAlignedHeight() {
        return this.maxAlignedHeight;
    }

    public int getMaxBoxHeight() {
        return this.maxBoxHeight;
    }

    public int getBaselineOffset() {
        return this.above;
    }

    public int getBelowBaseline() {
        return this.below;
    }

    public int getLead() {
        return this.maxAlignedHeight - (this.above + this.below);
    }

    public void considerBox(Inline box) {
        if (((Box)((Object)box)).isDisplayed() && !box.collapsedCompletely()) {
            int a = box.getBaselineOffset();
            int b = box.getBelowBaseline();
            if (box instanceof InlineElement) {
                CSSProperty.VerticalAlign va = ((InlineElement)box).getVerticalAlign();
                if (va != CSSProperty.VerticalAlign.TOP && va != CSSProperty.VerticalAlign.BOTTOM) {
                    int dif = this.computeBaselineDifference((InlineElement)box);
                    this.above = Math.max(this.above, a -= dif);
                    this.below = Math.max(this.below, b += dif);
                    this.maxAlignedHeight = Math.max(this.maxAlignedHeight, box.getMaxLineHeight());
                } else if (va == CSSProperty.VerticalAlign.BOTTOM) {
                    this.heightFromBottom = Math.max(this.heightFromBottom, box.getMaxLineHeight());
                }
            } else {
                this.above = Math.max(this.above, a);
                this.below = Math.max(this.below, b);
                this.maxAlignedHeight = Math.max(this.maxAlignedHeight, box.getMaxLineHeight());
            }
            this.maxBoxHeight = Math.max(this.maxBoxHeight, box.getMaxLineHeight());
        }
    }

    public void considerBoxProperties(ElementBox box) {
        VisualContext ctx = box.getVisualContext();
        int a = ctx.getBaselineOffset();
        int b = ctx.getFontHeight() - ctx.getBaselineOffset();
        this.above = Math.max(this.above, a);
        this.below = Math.max(this.below, b);
        this.maxAlignedHeight = Math.max(this.maxAlignedHeight, box.getLineHeight());
    }

    public int alignBox(Inline box) {
        if (box instanceof InlineElement) {
            CSSProperty.VerticalAlign va = ((InlineElement)box).getVerticalAlign();
            if (va == CSSProperty.VerticalAlign.TOP || va == CSSProperty.VerticalAlign.BOTTOM) {
                return 0;
            }
            return this.above + this.computeBaselineDifference((InlineElement)box) - box.getBaselineOffset() + ((InlineElement)box).getLineboxOffset();
        }
        return this.above - box.getBaselineOffset();
    }

    private int computeBaselineDifference(InlineElement box) {
        int a = box.getBaselineOffset();
        int b = box.getBelowBaseline();
        CSSProperty.VerticalAlign va = box.getVerticalAlign();
        int dif = 0;
        if (va == CSSProperty.VerticalAlign.BASELINE) {
            dif = 0;
        } else if (va == CSSProperty.VerticalAlign.MIDDLE) {
            int midbox = box.getLineHeight() / 2;
            int halfex = (int)Math.round(this.parent.getVisualContext().getEx() / 2.0);
            dif = midbox - halfex;
        } else if (va == CSSProperty.VerticalAlign.SUB) {
            dif = (int)Math.round(0.3 * (double)this.parent.getLineHeight());
        } else if (va == CSSProperty.VerticalAlign.SUPER) {
            dif = -((int)Math.round(0.3 * (double)this.parent.getLineHeight()));
        } else if (va == CSSProperty.VerticalAlign.TEXT_TOP) {
            int na = this.parent.getVisualContext().getBaselineOffset();
            dif = a - na;
        } else if (va == CSSProperty.VerticalAlign.TEXT_BOTTOM) {
            int nb = this.parent.getVisualContext().getFontHeight() - this.parent.getVisualContext().getBaselineOffset();
            dif = nb - b;
        } else if (va == CSSProperty.VerticalAlign.length || va == CSSProperty.VerticalAlign.percentage) {
            CSSDecoder dec = new CSSDecoder(((ElementBox)((Object)box)).getVisualContext());
            int len = dec.getLength(((ElementBox)((Object)box)).getLengthValue("vertical-align"), false, 0, 0, box.getLineHeight());
            dif = -len;
        }
        return dif;
    }
}

