/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.TermLengthOrPercent;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.fit.cssbox.css.HTMLNorm;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.LengthSet;
import org.fit.cssbox.layout.VisualContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TableColumn
extends BlockBox {
    private static Logger log = LoggerFactory.getLogger(TableColumn.class);
    protected int span;
    protected String colwidth;
    protected int mincwidth;
    protected int maxcwidth;
    protected int percent;
    protected int abswidth;

    public TableColumn(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.isblock = true;
        this.loadAttributes();
    }

    public TableColumn(InlineBox src) {
        super(src);
        this.isblock = true;
        this.loadAttributes();
    }

    public void copyValues(TableColumn src) {
        super.copyValues(src);
        this.span = src.span;
        this.colwidth = src.colwidth == null ? null : new String(src.colwidth);
        this.mincwidth = src.mincwidth;
        this.maxcwidth = src.maxcwidth;
        this.wrelative = src.wrelative;
        this.percent = src.percent;
        this.abswidth = src.abswidth;
    }

    @Override
    public TableColumn copyBox() {
        TableColumn ret = new TableColumn(this.el, this.g, this.ctx);
        ret.copyValues(this);
        return ret;
    }

    public int getSpan() {
        return this.span;
    }

    public String getSpecifiedWidth() {
        return this.colwidth;
    }

    public void setSpecifiedWidth(String width) {
        block2: {
            this.colwidth = width;
            try {
                this.content = new Dimension(0, 0);
                this.bounds.width = this.content.width = Integer.parseInt(width);
                this.abswidth = this.content.width;
                this.wset = true;
            }
            catch (NumberFormatException e) {
                if (width.equals("")) break block2;
                log.warn("Invalid width value: " + width);
            }
        }
    }

    public void setColumnWidth(int width) {
        this.content = new Dimension(0, 0);
        this.bounds.width = this.content.width = width;
    }

    @Override
    public int getMaximalWidth() {
        return this.maxcwidth;
    }

    public void setMaximalWidth(int maxwidth) {
        this.maxcwidth = maxwidth;
    }

    @Override
    public int getMinimalWidth() {
        return this.mincwidth;
    }

    public void setMinimalWidth(int minwidth) {
        this.mincwidth = minwidth;
    }

    public int getPercent() {
        return this.percent;
    }

    public void setPercent(int percent) {
        this.percent = percent;
    }

    public boolean isWrelative() {
        return this.wrelative;
    }

    public void setRelative(boolean wrelative) {
        this.wrelative = wrelative;
    }

    @Override
    public boolean affectsDisplay() {
        return false;
    }

    @Override
    public boolean doLayout(int widthlimit, boolean force, boolean linestart) {
        return true;
    }

    @Override
    protected void loadSizes(boolean update) {
        this.bounds = new Rectangle(0, 0, 0, 0);
        this.min_size = new Dimension();
        this.max_size = new Dimension();
        this.emargin = this.margin = new LengthSet();
        this.padding = new LengthSet();
        this.border = new LengthSet();
        this.isempty = true;
        this.displayed = false;
        this.visible = false;
        this.coords = new LengthSet();
        if (this.colwidth.equals("")) {
            int contw = this.getContainingBlock().width;
            CSSDecoder dec = new CSSDecoder(this.ctx);
            CSSProperty.Width wprop = (CSSProperty.Width)this.style.getProperty("width");
            if (wprop != null && wprop != CSSProperty.Width.AUTO) {
                TermLengthOrPercent width = this.getLengthValue("width");
                this.content.width = this.abswidth = dec.getLength(width, false, 0, 0, contw);
                this.wset = true;
                if (width.isPercentage()) {
                    this.wrelative = true;
                    this.percent = Math.round(((Float)width.getValue()).floatValue());
                    if (this.percent == 0) {
                        this.wrelative = false;
                    }
                }
            }
        }
        this.bounds.width = this.content.width;
    }

    protected void loadAttributes() {
        try {
            this.span = !HTMLNorm.getAttribute(this.el, "span").equals("") ? Integer.parseInt(HTMLNorm.getAttribute(this.el, "span")) : 1;
        }
        catch (NumberFormatException e) {
            log.warn("Invalid span value: " + HTMLNorm.getAttribute(this.el, "span"));
        }
        this.setSpecifiedWidth(HTMLNorm.getAttribute(this.el, "width"));
    }

    public static Element createAnonymousColumn(Document doc) {
        Element div = doc.createElement("col");
        div.setAttribute("class", "Xanonymous");
        div.setAttribute("style", "display:table-column;");
        return div;
    }
}

