/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermLengthOrPercent;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashSet;
import java.util.Set;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.Inline;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Text;

public class TextBox
extends Box
implements Inline {
    private Text textNode;
    private String text;
    private int textStart;
    private int textEnd;
    private int maxwidth;
    private int minwidth;
    private int expwidth;
    private boolean expAtLineEnd;
    private boolean ignoreinitialws;
    private boolean collapsews;
    private boolean splitws;
    private boolean linews;
    private int firstLineLength;
    private int lastLineLength;
    private int longestLineLength;
    private boolean containsLineBreak;
    private boolean lineBreakStop;
    private boolean collapsedCompletely;
    private CSSProperty.TextTransform transform;
    private Float wordSpacing;

    public TextBox(Text n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.textNode = n;
        this.transform = CSSProperty.TextTransform.NONE;
        this.wordSpacing = null;
        this.setWhiteSpace(ElementBox.WHITESPACE_NORMAL);
        ctx.updateForGraphics(null, g);
        this.ignoreinitialws = false;
        this.collapsews = true;
        this.containsLineBreak = false;
        this.lineBreakStop = false;
        this.collapsedCompletely = false;
    }

    public void copyValues(TextBox src) {
        super.copyValues(src);
        this.text = new String(src.text);
        this.ignoreinitialws = false;
        this.collapsews = src.collapsews;
        this.splitws = src.splitws;
        this.linews = src.linews;
        this.firstLineLength = src.firstLineLength;
        this.lastLineLength = src.lastLineLength;
        this.longestLineLength = src.longestLineLength;
        this.containsLineBreak = src.containsLineBreak;
        this.transform = src.transform;
        this.wordSpacing = src.wordSpacing;
    }

    public TextBox copyTextBox() {
        TextBox ret = new TextBox(this.textNode, this.g, this.ctx);
        ret.copyValues(this);
        return ret;
    }

    public String toString() {
        return "Text: " + this.text + "<" + this.textStart + "," + this.textEnd + ">";
    }

    @Override
    public void initBox() {
    }

    @Override
    public void setParent(ElementBox parent) {
        super.setParent(parent);
        if (this.getParent() != null) {
            CSSProperty.WordSpacing wspacing;
            this.transform = (CSSProperty.TextTransform)this.getParent().getStyle().getProperty("text-transform");
            if (this.transform == null) {
                this.transform = CSSProperty.TextTransform.NONE;
            }
            if ((wspacing = (CSSProperty.WordSpacing)this.getParent().getStyle().getProperty("word-spacing")) != null && wspacing != CSSProperty.WordSpacing.NORMAL) {
                TermLength lenspec = (TermLength)this.getParent().getStyle().getValue(TermLength.class, "word-spacing");
                if (lenspec != null) {
                    this.wordSpacing = Float.valueOf((float)this.ctx.pxLength((TermLengthOrPercent)lenspec));
                }
            } else {
                this.wordSpacing = null;
            }
            CSSProperty.WhiteSpace ws = this.getParent().getWhiteSpace();
            if (ws != ElementBox.WHITESPACE_NORMAL || this.transform != CSSProperty.TextTransform.NONE) {
                this.setWhiteSpace(ws);
            }
        }
    }

    @Override
    public String getText() {
        if (this.text != null) {
            return this.text.substring(this.textStart, this.textEnd);
        }
        return "";
    }

    @Override
    public boolean isDeclaredVisible() {
        return true;
    }

    @Override
    public boolean isDisplayed() {
        if (this.getParent() == null) {
            return true;
        }
        return this.parent.isDisplayed();
    }

    @Override
    public boolean isVisible() {
        if (this.getParent() == null) {
            return true;
        }
        return this.parent.isDeclaredVisible() && super.isVisible();
    }

    public void setWhiteSpace(CSSProperty.WhiteSpace value) {
        this.splitws = value == ElementBox.WHITESPACE_NORMAL || value == ElementBox.WHITESPACE_PRE_WRAP || value == ElementBox.WHITESPACE_PRE_LINE;
        this.collapsews = value == ElementBox.WHITESPACE_NORMAL || value == ElementBox.WHITESPACE_NOWRAP || value == ElementBox.WHITESPACE_PRE_LINE;
        boolean bl = this.linews = value == ElementBox.WHITESPACE_NORMAL || value == ElementBox.WHITESPACE_NOWRAP;
        if (!this.splitted) {
            this.applyWhiteSpace();
        }
        this.computeLineLengths();
        this.minwidth = this.computeMinimalWidth();
        this.maxwidth = this.computeMaximalWidth();
    }

    private void applyWhiteSpace() {
        this.text = this.applyTransformations(this.collapseWhitespaces(this.node.getNodeValue()));
        this.textStart = 0;
        this.textEnd = this.text.length();
        this.isempty = this.textEnd == 0;
    }

    private String collapseWhitespaces(String src) {
        StringBuffer ret = new StringBuffer();
        boolean inws = false;
        for (int i = 0; i < src.length(); ++i) {
            char ch = src.charAt(i);
            if (this.collapsews && this.isWhitespace(ch)) {
                if (inws) continue;
                ret.append(' ');
                inws = true;
                continue;
            }
            if (this.isLineBreak(ch)) {
                ret.append('\r');
                if (ch != '\r' || i + 1 >= src.length() || src.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            inws = false;
            ret.append(ch);
        }
        return new String(ret);
    }

    private String applyTransformations(String src) {
        switch (this.transform) {
            case LOWERCASE: {
                return src.toLowerCase();
            }
            case UPPERCASE: {
                return src.toUpperCase();
            }
            case CAPITALIZE: {
                StringBuilder ret = new StringBuilder(src.length());
                boolean ws = true;
                for (int i = 0; i < src.length(); ++i) {
                    char ch = src.charAt(i);
                    if (Character.isWhitespace(ch)) {
                        ws = true;
                    } else {
                        if (ws) {
                            ch = Character.toUpperCase(ch);
                        }
                        ws = false;
                    }
                    ret.append(ch);
                }
                return ret.toString();
            }
        }
        return src;
    }

    public void removeTrailingWhitespaces() {
        int last = -1;
        int i = this.text.length() - 1;
        while (i >= 0 && this.isWhitespace(this.text.charAt(i))) {
            last = i--;
        }
        if (last != -1) {
            this.text = this.text.substring(0, last);
            this.textStart = 0;
            this.textEnd = last;
        }
    }

    protected int getTextStart() {
        return this.textStart;
    }

    protected void setTextStart(int index) {
        this.textStart = index;
    }

    protected int getTextEnd() {
        return this.textEnd;
    }

    protected void setTextEnd(int index) {
        this.textEnd = index;
    }

    @Override
    public boolean affectsDisplay() {
        return !this.isEmpty();
    }

    @Override
    public boolean isWhitespace() {
        String s = this.getText();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean collapsesSpaces() {
        return this.collapsews;
    }

    @Override
    public boolean preservesLineBreaks() {
        return !this.linews;
    }

    @Override
    public boolean allowsWrapping() {
        return this.splitws;
    }

    @Override
    public int getContentX() {
        return this.bounds.x;
    }

    @Override
    public int getAbsoluteContentX() {
        return this.absbounds.x;
    }

    @Override
    public int getContentY() {
        return this.bounds.y;
    }

    @Override
    public int getAbsoluteContentY() {
        return this.absbounds.y;
    }

    @Override
    public int getContentWidth() {
        return this.bounds.width;
    }

    @Override
    public int getContentHeight() {
        return this.bounds.height;
    }

    @Override
    public int getAvailableContentWidth() {
        return this.availwidth;
    }

    @Override
    public int getLineHeight() {
        return this.parent.getLineHeight();
    }

    @Override
    public int getMaxLineHeight() {
        return this.parent.getLineHeight();
    }

    @Override
    public int getTotalLineHeight() {
        return this.ctx.getFontHeight();
    }

    @Override
    public int getBaselineOffset() {
        return this.ctx.getBaselineOffset();
    }

    @Override
    public int getBelowBaseline() {
        return this.ctx.getFontHeight() - this.ctx.getBaselineOffset();
    }

    @Override
    public int getHalfLead() {
        return 0;
    }

    public LineMetrics getLineMetrics() {
        return this.ctx.getFont().getLineMetrics(this.getText(), this.g.getFontRenderContext());
    }

    @Override
    public int totalHeight() {
        return this.bounds.width;
    }

    @Override
    public int totalWidth() {
        return this.bounds.height;
    }

    @Override
    public Rectangle getMinimalAbsoluteBounds() {
        return this.absbounds;
    }

    @Override
    public boolean isInFlow() {
        return true;
    }

    @Override
    public boolean containsFlow() {
        return false;
    }

    @Override
    public boolean canSplitInside() {
        return this.getText().indexOf(32) != -1;
    }

    @Override
    public boolean canSplitBefore() {
        if (this.textEnd > this.textStart) {
            return this.text.charAt(this.textStart) == ' ' || this.textStart > 0 && this.text.charAt(this.textStart - 1) == ' ';
        }
        return false;
    }

    @Override
    public boolean canSplitAfter() {
        if (this.textEnd > this.textStart) {
            return this.text.charAt(this.textEnd - 1) == ' ' || this.textEnd < this.text.length() && this.text.charAt(this.textEnd) == ' ';
        }
        return false;
    }

    @Override
    public boolean startsWithWhitespace() {
        if (this.textEnd > this.textStart) {
            return Character.isWhitespace(this.text.charAt(this.textStart));
        }
        return false;
    }

    @Override
    public boolean endsWithWhitespace() {
        if (this.textEnd > this.textStart) {
            return Character.isWhitespace(this.text.charAt(this.textEnd - 1));
        }
        return false;
    }

    @Override
    public void setIgnoreInitialWhitespace(boolean b) {
        this.ignoreinitialws = b;
        if (this.ignoreinitialws && this.collapsews) {
            while (this.textStart < this.textEnd && this.isWhitespace(this.text.charAt(this.textStart))) {
                ++this.textStart;
            }
            if (this.textStart == this.textEnd) {
                this.collapsedCompletely = true;
            }
            this.computeLineLengths();
            this.minwidth = this.computeMinimalWidth();
            this.maxwidth = this.computeMaximalWidth();
        }
    }

    @Override
    public boolean hasFixedWidth() {
        return false;
    }

    @Override
    public boolean hasFixedHeight() {
        return false;
    }

    @Override
    public boolean doLayout(int widthlimit, boolean force, boolean linestart) {
        if (!this.displayed) {
            this.bounds.setSize(0, 0);
            return true;
        }
        if (!this.splitted) {
            this.textEnd = this.text.length();
        }
        this.setAvailableWidth(widthlimit);
        boolean split = false;
        boolean allow = false;
        boolean fail = false;
        int wlimit = this.getAvailableContentWidth();
        boolean empty = this.isempty;
        FontMetrics fm = this.g.getFontMetrics();
        int w = 0;
        int h = 0;
        int end = this.textEnd;
        int lineend = this.text.indexOf(13, this.textStart);
        if (lineend != -1 && lineend < end) {
            end = lineend;
            split = true;
            allow = true;
        }
        if (!empty || !linestart) {
            if ((linestart || this.ignoreinitialws) && this.collapsews) {
                while (this.textStart < end && this.isWhitespace(this.text.charAt(this.textStart))) {
                    ++this.textStart;
                }
                if (this.textStart == end) {
                    this.collapsedCompletely = true;
                    empty = true;
                }
            }
            do {
                int wordend;
                w = this.stringWidth(fm, this.text.substring(this.textStart, end));
                h = fm.getHeight();
                if (w <= wlimit) continue;
                if (empty) {
                    w = 0;
                    h = 0;
                    split = false;
                    break;
                }
                for (wordend = this.text.substring(0, end).lastIndexOf(32); wordend > 0 && this.text.charAt(wordend - 1) == ' '; --wordend) {
                }
                if (wordend <= this.textStart || !this.splitws) {
                    if (!force) {
                        end = this.textEnd;
                        split = false;
                        allow = false;
                        fail = true;
                        break;
                    }
                    split = true;
                    break;
                }
                end = wordend;
                split = true;
            } while (end > this.textStart && w > wlimit);
        }
        this.textEnd = end;
        this.bounds.setSize(w, h);
        if (split) {
            int start = this.textEnd;
            if (start < this.text.length() && this.isLineBreak(this.text.charAt(start))) {
                ++start;
                this.lineBreakStop = true;
            }
            if (this.collapsews) {
                while (start < this.text.length() && this.isWhitespace(this.text.charAt(start))) {
                    ++start;
                }
            }
            if (start < this.text.length()) {
                TextBox rtext = this.copyTextBox();
                rtext.splitted = true;
                rtext.splitid = this.splitid + 1;
                rtext.setTextStart(start);
                rtext.setTextEnd(this.text.length());
                this.rest = rtext;
            } else {
                this.rest = null;
            }
        } else {
            this.rest = null;
        }
        return !fail && (this.textEnd > this.textStart || empty || allow);
    }

    @Override
    public void absolutePositions() {
        this.updateStackingContexts();
        if (this.displayed) {
            this.absbounds.x = this.getParent().getAbsoluteContentX() + this.bounds.x;
            this.absbounds.y = this.getParent().getAbsoluteContentY() + this.bounds.y;
            this.absbounds.width = this.bounds.width;
            this.absbounds.height = this.bounds.height;
        }
    }

    @Override
    public int getMinimalWidth() {
        return this.minwidth;
    }

    private int computeMinimalWidth() {
        int ret = 0;
        String t = this.getText();
        if (t.length() > 0) {
            ret = this.splitws ? this.getLongestWord() : this.longestLineLength;
        }
        return ret;
    }

    @Override
    public int getMaximalWidth() {
        return this.maxwidth;
    }

    private int computeMaximalWidth() {
        if (this.linews) {
            int len;
            this.firstLineLength = len = this.stringWidth(this.g.getFontMetrics(), this.getText());
            this.lastLineLength = len;
            this.longestLineLength = len;
            return len;
        }
        return this.longestLineLength;
    }

    private int getLongestWord() {
        int ret = 0;
        String t = this.getText();
        FontMetrics fm = this.g.getFontMetrics();
        int s1 = 0;
        int s2 = t.indexOf(32);
        do {
            int w;
            if (s2 == -1) {
                s2 = t.length();
            }
            if ((w = this.stringWidth(fm, t.substring(s1, s2))) > ret) {
                ret = w;
            }
            s1 = s2 + 1;
            s2 = t.indexOf(32, s1);
        } while (s1 < t.length() && s2 < t.length());
        return ret;
    }

    @Override
    public int getFirstLineLength() {
        return this.firstLineLength;
    }

    @Override
    public int getLastLineLength() {
        return this.lastLineLength;
    }

    @Override
    public boolean containsLineBreak() {
        return this.containsLineBreak;
    }

    @Override
    public boolean finishedByLineBreak() {
        return this.lineBreakStop;
    }

    @Override
    public boolean collapsedCompletely() {
        return this.collapsedCompletely;
    }

    @Override
    public int getWidthExpansionPoints(boolean atLineStart, boolean atLineEnd) {
        if (this.collapsews && this.splitws && !this.lineBreakStop) {
            int cnt = 0;
            String text = this.getText();
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) != ' ' || i == 0 && atLineStart || i == text.length() - 1 && atLineEnd) continue;
                ++cnt;
            }
            return cnt;
        }
        return 0;
    }

    @Override
    public void extendWidth(int ofs, boolean atLineStart, boolean atLineEnd) {
        this.expwidth = ofs;
        this.expAtLineEnd = atLineEnd;
        this.bounds.width += ofs;
    }

    public int getExtraWidth() {
        return this.expwidth;
    }

    public Float getWordSpacing() {
        return this.wordSpacing;
    }

    public int[][] getWordOffsets(String[] words) {
        return this.getWordOffsets(this.g.getFontMetrics(), words);
    }

    private int[][] getWordOffsets(FontMetrics fm, String[] words) {
        if (words.length > 0) {
            int[] ww = new int[words.length];
            int totalw = 0;
            for (int i = 0; i < words.length; ++i) {
                ww[i] = this.stringWidth(fm, words[i]);
                totalw += ww[i];
            }
            int spaces = words.length - 1;
            if (this.startsWithWhitespace()) {
                ++spaces;
            }
            if (this.endsWithWhitespace() && !this.expAtLineEnd) {
                ++spaces;
            }
            float spacing = spaces == 0 ? (float)(this.bounds.width - totalw) : (float)(this.bounds.width - totalw) / (float)spaces;
            int[][] ret = new int[words.length][2];
            float curX = 0.0f;
            if (this.startsWithWhitespace()) {
                curX += spacing;
            }
            for (int i = 0; i < words.length; ++i) {
                ret[i][0] = Math.round(curX);
                ret[i][1] = ww[i];
                curX += (float)ww[i] + spacing;
            }
            return ret;
        }
        return new int[0][0];
    }

    public int getCharOffsetX(int pos) {
        return this.getCharOffsetXElem(pos + this.textStart);
    }

    public int getCharOffsetXElem(int pos) {
        if (this.text != null) {
            FontMetrics fm = this.g.getFontMetrics();
            if (pos <= this.textStart) {
                return 0;
            }
            if (pos > this.textStart && pos < this.textEnd) {
                return this.stringWidth(fm, this.text.substring(this.textStart, pos));
            }
            return this.stringWidth(fm, this.text.substring(this.textStart, this.textEnd));
        }
        return 0;
    }

    protected void computeLineLengths() {
        this.firstLineLength = -1;
        this.lastLineLength = 0;
        this.longestLineLength = 0;
        String t = this.getText();
        FontMetrics fm = this.g.getFontMetrics();
        int s1 = 0;
        int s2 = t.indexOf(13);
        int w = 0;
        do {
            if (s2 == -1) {
                s2 = t.length();
            } else {
                this.containsLineBreak = true;
            }
            w = this.stringWidth(fm, t.substring(s1, s2));
            if (this.firstLineLength == -1) {
                this.firstLineLength = w;
            }
            if (w > this.longestLineLength) {
                this.longestLineLength = w;
            }
            s1 = s2 + 1;
            s2 = t.indexOf(13, s1);
        } while (s1 < t.length() && s2 < t.length());
        this.lastLineLength = w;
    }

    private int stringWidth(FontMetrics fm, String text) {
        int w = fm.stringWidth(text);
        if (this.wordSpacing != null) {
            float add = 0.0f;
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) != ' ') continue;
                add += this.wordSpacing.floatValue();
            }
            w = Math.round((float)w + add);
        }
        return w;
    }

    public void drawContent(Graphics2D g) {
        int x = this.absbounds.x;
        int y = this.absbounds.y;
        if (this.textEnd > this.textStart) {
            String t = this.text.substring(this.textStart, this.textEnd);
            Shape oldclip = g.getClip();
            if (this.clipblock != null) {
                g.setClip(this.applyClip(oldclip, this.clipblock.getClippedContentBounds()));
            }
            this.ctx.updateGraphics(g);
            if (this.wordSpacing == null && this.expwidth == 0) {
                this.drawAttributedString(g, x, y, t);
            } else {
                this.drawByWords(g, x, y, t);
            }
            g.setClip(oldclip);
        }
    }

    private void drawByWords(Graphics2D g, int x, int y, String text) {
        String[] words = text.split(" ");
        if (words.length > 0) {
            FontMetrics fm = g.getFontMetrics();
            int[][] offsets = this.getWordOffsets(fm, words);
            for (int i = 0; i < words.length; ++i) {
                this.drawAttributedString(g, x + offsets[i][0], y, words[i]);
            }
        } else {
            this.drawAttributedString(g, x, y, text);
        }
    }

    private void drawAttributedString(Graphics2D g, int x, int y, String text) {
        Set<CSSProperty.TextDecoration> decoration = this.getEfficientTextDecoration();
        if (!decoration.isEmpty()) {
            AttributedString as = new AttributedString(text);
            as.addAttribute(TextAttribute.FONT, this.ctx.getFont());
            if (decoration.contains(CSSProperty.TextDecoration.UNDERLINE)) {
                as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (decoration.contains(CSSProperty.TextDecoration.LINE_THROUGH)) {
                as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            g.drawString(as.getIterator(), x, y + this.getBaselineOffset());
        } else {
            g.drawString(text, x, y + this.getBaselineOffset());
        }
    }

    @Override
    public void draw(Box.DrawStage turn) {
        if (this.displayed && this.isVisible() && turn == Box.DrawStage.DRAW_INLINE) {
            this.getViewport().getRenderer().renderTextContent(this);
        }
    }

    @Override
    public void drawExtent(Graphics2D g) {
        g.setColor(Color.ORANGE);
        g.drawRect(this.absbounds.x, this.absbounds.y, this.bounds.width, this.bounds.height);
        g.setColor(Color.MAGENTA);
        int y = this.getAbsoluteContentY();
        int h = this.getTotalLineHeight();
        g.drawRect(this.getAbsoluteContentX(), y, this.getContentWidth(), h);
        g.setColor(Color.BLUE);
        y = this.getAbsoluteContentY() + this.getBaselineOffset();
        g.drawRect(this.getAbsoluteContentX(), y, this.getContentWidth(), 1);
    }

    public Set<CSSProperty.TextDecoration> getEfficientTextDecoration() {
        HashSet<CSSProperty.TextDecoration> ret = new HashSet<CSSProperty.TextDecoration>();
        Box curbox = this;
        ret.addAll(curbox.getVisualContext().getTextDecoration());
        while (curbox.getParent() != null && this.acceptsPropagatedDecorations(curbox)) {
            curbox = curbox.getParent();
            ret.addAll(curbox.getVisualContext().getTextDecoration());
        }
        return ret;
    }

    private boolean isWhitespace(char ch) {
        if (this.linews) {
            return Character.isWhitespace(ch);
        }
        return ch != '\n' && ch != '\r' && Character.isWhitespace(ch);
    }

    private boolean isLineBreak(char ch) {
        if (this.linews) {
            return false;
        }
        return ch == '\r' || ch == '\n';
    }

    private boolean acceptsPropagatedDecorations(Box box) {
        return !(box instanceof BlockBox) || !((BlockBox)box).isFloating() && !((BlockBox)box).isPositioned() && !(box instanceof Inline);
    }
}

