/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.render;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.ListItemBox;
import org.fit.cssbox.layout.ReplacedBox;
import org.fit.cssbox.layout.TextBox;
import org.fit.cssbox.render.BoxRenderer;
import org.fit.cssbox.render.Transform;

public class GraphicsRenderer
implements BoxRenderer {
    protected Graphics2D g;
    protected Map<ElementBox, AffineTransform> savedTransforms;

    public GraphicsRenderer(Graphics2D g) {
        this.g = g;
        this.savedTransforms = new HashMap<ElementBox, AffineTransform>();
    }

    @Override
    public void startElementContents(ElementBox elem) {
        AffineTransform at = Transform.createTransform(elem);
        if (at != null) {
            this.savedTransforms.put(elem, this.g.getTransform());
            this.g.transform(at);
        }
    }

    @Override
    public void finishElementContents(ElementBox elem) {
        AffineTransform origAt = this.savedTransforms.get(elem);
        if (origAt != null) {
            this.g.setTransform(origAt);
        }
    }

    @Override
    public void renderElementBackground(ElementBox elem) {
        AffineTransform origAt = null;
        AffineTransform at = Transform.createTransform(elem);
        if (at != null) {
            origAt = this.g.getTransform();
            this.g.transform(at);
        }
        elem.drawBackground(this.g);
        if (origAt != null) {
            this.g.setTransform(origAt);
        }
    }

    @Override
    public void renderMarker(ListItemBox elem) {
        elem.drawMarker(this.g);
    }

    @Override
    public void renderTextContent(TextBox text) {
        text.drawContent(this.g);
    }

    @Override
    public void renderReplacedContent(ReplacedBox box) {
        AffineTransform at;
        AffineTransform origAt = null;
        if (box instanceof ElementBox && (at = Transform.createTransform((ElementBox)((Object)box))) != null) {
            origAt = this.g.getTransform();
            this.g.transform(at);
        }
        box.drawContent(this.g);
        if (origAt != null) {
            this.g.setTransform(origAt);
        }
    }

    @Override
    public void close() {
    }
}

