/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.dsl4j;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import tokyo.northside.dsl4j.Visitable;
import tokyo.northside.dsl4j.visitor.DslVisitor;

public class DslArticle
implements Visitable {
    private ElementSequence elements;

    public DslArticle(ElementSequence elements) {
        this.elements = elements;
    }

    @Override
    public void accept(DslVisitor v) {
        v.visit(this);
    }

    private static String dequote(String s) {
        if (s == null) {
            return "";
        }
        if (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public ElementSequence getElements() {
        return this.elements;
    }

    public static class Newline
    extends DslElement {
        private static final String NL = System.getProperty("line.separator");

        @Override
        public void accept(DslVisitor v) {
            v.visit(this);
        }

        @Override
        public String toString() {
            return NL;
        }
    }

    public static class ElementSequence {
        private final List<DslElement> elements = new ArrayList<DslElement>();

        public void addElement(DslElement o) {
            this.elements.add(o);
        }

        public int size() {
            return this.elements.size();
        }

        public Iterator<DslElement> iterator() {
            return this.elements.iterator();
        }

        public void setElements(List<DslElement> collection) {
            this.elements.clear();
            this.elements.addAll(collection);
        }
    }

    public static class Text
    extends DslElement {
        private String text;

        public Text(String t) {
            this.text = t;
        }

        public String getText() {
            return this.text;
        }

        @Override
        public void accept(DslVisitor v) {
            v.visit(this);
        }

        @Override
        public String toString() {
            return this.text;
        }
    }

    public static class LangAttribute
    extends Attribute {
        private String key;

        public LangAttribute(String k, String v) {
            this.key = k;
            this.name = v;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.key + "=" + this.name;
        }
    }

    public static class ColorAttribute
    extends Attribute {
        public ColorAttribute(String v) {
            this.name = v;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getKey() {
            return null;
        }
    }

    public static abstract class Attribute {
        protected String name;

        public String getValue() {
            return DslArticle.dequote(this.name);
        }

        public abstract String getKey();
    }

    public static class EndTag
    extends DslElement {
        private String tagName;

        public EndTag(String t) {
            this.tagName = t;
        }

        public String getTagName() {
            return this.tagName;
        }

        public boolean isTagName(String name) {
            return this.tagName.equals(name);
        }

        @Override
        public void accept(DslVisitor v) {
            v.visit(this);
        }

        @Override
        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("[/");
            s.append(this.tagName);
            s.append("]");
            return s.toString();
        }
    }

    public static class Tag
    extends DslElement {
        private String tagName;
        private Attribute attribute;

        public Tag(String t, Attribute a) {
            this.tagName = t;
            this.attribute = a;
        }

        public String getTagName() {
            return this.tagName;
        }

        public boolean isTagName(String name) {
            return this.tagName.equals(name);
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public boolean hasAttribute() {
            return this.attribute != null;
        }

        @Override
        public void accept(DslVisitor v) {
            v.visit(this);
        }

        @Override
        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("[");
            s.append(this.tagName);
            if (this.attribute != null) {
                s.append(" ");
                s.append(this.attribute);
            }
            s.append("]");
            return s.toString();
        }
    }

    public static abstract class DslElement
    implements Visitable {
        @Override
        public abstract void accept(DslVisitor var1);

        public abstract String toString();
    }
}

