/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.dsl4j;

import com.google.protobuf.ByteString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.dict.zip.DictZipInputStream;
import org.dict.zip.RandomAccessInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tokyo.northside.dsl4j.DslDictionary;
import tokyo.northside.dsl4j.DslFileDictionary;
import tokyo.northside.dsl4j.DslZipDictionary;
import tokyo.northside.dsl4j.data.DictionaryData;
import tokyo.northside.dsl4j.data.DictionaryDataBuilder;
import tokyo.northside.dsl4j.data.DslDictionaryProperty;
import tokyo.northside.dsl4j.data.DslEntry;
import tokyo.northside.dsl4j.impl.EntriesLoaderImpl;
import tokyo.northside.dsl4j.index.DslIndex;

final class DslDictionaryLoader {
    private static final String[] PATTERNS = new String[]{"name", "index", "content", "codepage", "include"};
    private static final Pattern METAPATTERN = Pattern.compile("^(\ufeff)?#(NAME\\s(?<name>.+?)|INDEX_LANGUAGE\\s(?<index>.+?)|CONTENTS_LANGUAGE\\s(?<content>.+?)|SOURCE_CODE_PAGE\\s(?<codepage>.+?))|INCLUDE\\s(?<include>.+?)$");
    private static final String[] ALLOWED_CODE_PAGE = new String[]{"EasternEuropean", "Cyrillic", "Latin", "Greek", "Turkish"};
    private static final int INDEX_VERSION = 2;

    private DslDictionaryLoader() {
    }

    static DslDictionary load(@NotNull Path path, @Nullable Path indexPath, boolean validateIndexAbsPath) throws IOException {
        if (!path.toFile().isFile()) {
            throw new IOException("Target file is not a file.");
        }
        Path filename = path.getFileName();
        if (filename == null) {
            throw new IOException("Error reading target file.");
        }
        boolean isDictzip = filename.toString().endsWith(".dz");
        List<DslIndex.Entry> entries = null;
        DslDictionaryProperty prop = null;
        DslIndex index = DslDictionaryLoader.getIndexFromFileAndValidate(path, indexPath, validateIndexAbsPath);
        if (index != null) {
            prop = new DslDictionaryProperty(index.getDictionaryName(), index.getIndexLanguage(), index.getContentLanguage(), Charset.forName(index.getCharset()), index.getEol().toByteArray());
            entries = index.getEntriesList();
        }
        if (entries == null || entries.isEmpty()) {
            Charset charset = DslDictionaryLoader.detectCharset(path, isDictzip);
            byte[] eol = DslDictionaryLoader.detectEol(path, isDictzip, charset);
            Map<String, String> metadata = DslDictionaryLoader.readMetadata(path, isDictzip, charset);
            try (EntriesLoaderImpl loader = new EntriesLoaderImpl(path, isDictzip, charset, eol);){
                entries = loader.load();
            }
            prop = new DslDictionaryProperty(metadata.get("name"), metadata.get("index"), metadata.get("content"), charset, eol);
            if (!DslDictionaryLoader.validateProp(prop)) {
                throw new IOException("Invalid dictionary file: lack mandatory field.");
            }
            DslDictionaryLoader.buildIndexFile(path, indexPath, entries, prop);
        }
        DictionaryData<DslEntry> data = new DictionaryDataBuilder().build(entries);
        if (isDictzip) {
            return new DslZipDictionary(path, data, prop);
        }
        return new DslFileDictionary(path, data, prop);
    }

    private static boolean validateProp(DslDictionaryProperty prop) {
        return prop.getDictionaryName() != null || prop.getContentLanguage() != null || prop.getIndexLanguage() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DslIndex getIndexFromFileAndValidate(Path path, Path indexPath, boolean validateAbsolutePath) {
        if (indexPath == null) return null;
        if (!indexPath.toFile().canRead()) return null;
        try (GZIPInputStream is = new GZIPInputStream(Files.newInputStream(indexPath, new OpenOption[0]));){
            DslIndex index = DslIndex.parseFrom(is);
            if (2 != index.getIndexVersion()) return null;
            long mtime = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            long expectedMTime = index.getFileLastModifiedTime();
            Path filepath = path.getFileName();
            String filename = filepath != null ? filepath.toString() : "";
            Path parentpath = path.getParent();
            String parent = parentpath != null ? parentpath.toString() : "";
            boolean samePath = filename.equals(index.getFilename()) && (!validateAbsolutePath || parent.equals(index.getParentPath()));
            if (!samePath) return null;
            if (Files.size(path) != index.getFilesize()) return null;
            if (mtime != expectedMTime) return null;
            DslIndex dslIndex = index;
            return dslIndex;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static void buildIndexFile(@NotNull Path path, @Nullable Path indexPath, @NotNull List<DslIndex.Entry> entries, @NotNull DslDictionaryProperty prop) throws IOException {
        if (indexPath == null) {
            return;
        }
        Path filepath = path.getFileName();
        String filename = filepath != null ? filepath.toString() : "";
        Path parentpath = path.getParent();
        String parent = parentpath != null ? parentpath.toString() : "";
        try (GZIPOutputStream os = new GZIPOutputStream(Files.newOutputStream(indexPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE));){
            DslIndex index = DslIndex.newBuilder().setIndexVersion(2).setFilename(filename).setParentPath(parent).setFilesize(Files.size(path)).setFileLastModifiedTime(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()).setDictionaryName(prop.getDictionaryName()).setIndexLanguage(prop.getIndexLanguage()).setContentLanguage(prop.getContentLanguage()).setCharset(prop.getCharset().name()).setEol(ByteString.copyFrom((byte[])prop.getEol())).addAllEntries(entries).build();
            index.writeTo(os);
            ((OutputStream)os).flush();
        }
        catch (IOException e) {
            Files.deleteIfExists(indexPath);
        }
    }

    private static byte[] detectEol(Path path, boolean isDictzip, Charset charset) throws IOException {
        byte[] eol;
        try (DictZipInputStream bis = isDictzip ? new DictZipInputStream(new RandomAccessInputStream(new RandomAccessFile(path.toFile(), "r"))) : new RandomAccessInputStream(new RandomAccessFile(path.toFile(), "r"));){
            eol = "\r\n".getBytes(charset);
            try (InputStreamReader isr = new InputStreamReader((InputStream)bis, charset);
                 BufferedReader reader = new BufferedReader(isr);){
                int c;
                while ((c = reader.read()) != -1) {
                    if (c == 13) {
                        eol = "\r\n".getBytes(charset);
                    } else {
                        if (c != 10) continue;
                        eol = "\n".getBytes(charset);
                    }
                    break;
                }
            }
        }
        return eol;
    }

    private static Charset detectCharset(Path path, boolean isDictzip) throws IOException {
        Charset charset;
        try (BOMInputStream bis = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream((InputStream)(isDictzip ? new DictZipInputStream(new RandomAccessInputStream(new RandomAccessFile(path.toFile(), "r"))) : new RandomAccessInputStream(new RandomAccessFile(path.toFile(), "r"))))).setByteOrderMarks(new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE}).setInclude(false).get();){
            if (!bis.hasBOM()) {
                byte[] buf = new byte[4];
                if (bis.read(buf, 0, 4) == -1) {
                    throw new IOException("Unexpected end of file.");
                }
                charset = buf[1] == 0 ? StandardCharsets.UTF_16LE : StandardCharsets.ISO_8859_1;
            } else {
                charset = bis.hasBOM(ByteOrderMark.UTF_16LE) ? StandardCharsets.UTF_16LE : (bis.hasBOM(ByteOrderMark.UTF_16BE) ? StandardCharsets.UTF_16BE : StandardCharsets.UTF_8);
            }
        }
        if (charset == StandardCharsets.ISO_8859_1) {
            Map<String, String> metadata = DslDictionaryLoader.readMetadata(path, isDictzip, charset);
            if (metadata.containsKey("codepage")) {
                String codepageName = metadata.get("codepage");
                for (int i = 0; i < ALLOWED_CODE_PAGE.length; ++i) {
                    String name = ALLOWED_CODE_PAGE[i];
                    if (!name.equals(codepageName)) continue;
                    charset = Charset.forName(String.format("Cp%4d", 1250 + i));
                    break;
                }
            }
            if (charset == StandardCharsets.ISO_8859_1) {
                charset = StandardCharsets.UTF_8;
            }
        }
        return charset;
    }

    private static Map<String, String> readMetadata(Path path, boolean isDictzip, Charset charset) throws IOException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try (DictZipInputStream bis = isDictzip ? new DictZipInputStream(new RandomAccessInputStream(new RandomAccessFile(path.toFile(), "r"))) : new RandomAccessInputStream(new RandomAccessFile(path.toFile(), "r"));
             InputStreamReader isr = new InputStreamReader((InputStream)bis, charset);
             BufferedReader reader = new BufferedReader(isr);){
            Matcher m;
            String l;
            block15: while ((l = reader.readLine()) != null && !l.isEmpty() && (m = METAPATTERN.matcher(l)).matches()) {
                for (String pattern : PATTERNS) {
                    String s = m.group(pattern);
                    if (s == null) continue;
                    if (s.startsWith("\"") && s.endsWith("\"")) {
                        metadata.put(pattern, s.substring(1, s.length() - 1));
                        continue block15;
                    }
                    metadata.put(pattern, m.group(pattern));
                    continue block15;
                }
            }
        }
        return metadata;
    }
}

