/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.dsl4j;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import org.dict.zip.RandomAccessInputStream;
import tokyo.northside.dsl4j.DslDictionary;
import tokyo.northside.dsl4j.data.DictionaryData;
import tokyo.northside.dsl4j.data.DslDictionaryProperty;
import tokyo.northside.dsl4j.data.DslEntry;

public class DslFileDictionary
extends DslDictionary {
    private final RandomAccessInputStream ras;

    public DslFileDictionary(Path path, DictionaryData<DslEntry> dictionaryData, DslDictionaryProperty prop) throws IOException {
        super(dictionaryData, prop);
        this.ras = new RandomAccessInputStream(new RandomAccessFile(path.toFile(), "r"));
    }

    @Override
    String getRecord(long offset, int size) throws IOException {
        byte[] buf = new byte[size];
        this.ras.seek(offset);
        this.ras.readFully(buf);
        return new String(buf, this.prop.getCharset());
    }
}

