/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.dsl4j.data;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.trie4j.MapTrie;
import org.trie4j.doublearray.MapDoubleArray;

public final class DictionaryData<T> {
    private final MapDoubleArray<Object> data;

    public DictionaryData(MapTrie<Object> trie) {
        this.data = new MapDoubleArray(trie);
    }

    public List<Map.Entry<String, T>> lookUp(String word) throws IllegalStateException {
        return this.doLookUpWithLowerCase(word, false);
    }

    public List<Map.Entry<String, T>> lookUpPredictive(String word) throws IllegalStateException {
        return this.doLookUpWithLowerCase(word, true);
    }

    private List<Map.Entry<String, T>> doLookUpWithLowerCase(String word, boolean predictive) {
        List<Map.Entry<String, T>> result = this.doLookUp(word, predictive);
        if (result.isEmpty()) {
            String lowerWord = word.toLowerCase();
            result = this.doLookUp(lowerWord, predictive);
        }
        return result;
    }

    private List<Map.Entry<String, T>> doLookUp(String word, boolean predictive) throws IllegalStateException {
        if (this.data == null) {
            throw new IllegalStateException("Object has not been finalized! You must call done() before doing any lookups.");
        }
        ArrayList<Map.Entry<String, T>> result = new ArrayList<Map.Entry<String, T>>();
        if (predictive) {
            this.data.predictiveSearch(word).forEach(w -> this.get(w, this.data.get(w), result));
        } else {
            this.get(word, this.data.get(word), result);
        }
        return result;
    }

    private <U> void get(U key, Object value, Collection<Map.Entry<U, T>> into) {
        if (value == null) {
            return;
        }
        if (value instanceof Object[]) {
            for (Object o : (Object[])value) {
                into.add(new AbstractMap.SimpleImmutableEntry<U, Object>(key, o));
            }
        } else {
            into.add(new AbstractMap.SimpleImmutableEntry<U, Object>(key, value));
        }
    }

    public int size() {
        return this.data.size();
    }
}

