/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.dsl4j.visitor;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import tokyo.northside.dsl4j.DslArticle;
import tokyo.northside.dsl4j.visitor.DslVisitor;

public class DumpDslVisitor
extends DslVisitor<String> {
    protected PrintWriter out;
    protected ByteArrayOutputStream baos = new ByteArrayOutputStream();
    protected Charset charset = StandardCharsets.UTF_8;

    public DumpDslVisitor() {
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)this.baos, this.charset));
    }

    @Override
    public void start() {
        this.baos.reset();
    }

    @Override
    public void finish() {
        this.out.flush();
    }

    @Override
    public void visit(DslArticle.Tag tag) {
        this.out.print(tag);
    }

    @Override
    public void visit(DslArticle.Text t) {
        String result = t.getText();
        if (result.equals("[")) {
            result = "\\[";
        }
        if (result.equals("]")) {
            result = "\\]";
        }
        this.out.print(result);
    }

    @Override
    public void visit(DslArticle.Attribute a) {
        this.out.print(a);
    }

    @Override
    public void visit(DslArticle.Newline n) {
        this.out.println();
    }

    @Override
    public void visit(DslArticle.EndTag endTag) {
        this.out.print(endTag);
    }

    @Override
    public String getObject() {
        try {
            return this.baos.toString(this.charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

