/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign.decode;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.RuleFactory;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermFactory;
import cz.vutbr.web.css.TermFloatValue;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermNumber;
import cz.vutbr.web.css.TermNumeric;
import cz.vutbr.web.css.TermPercent;
import cz.vutbr.web.css.TermTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Decoder {
    public static final boolean AVOID_INH = true;
    public static final boolean ALLOW_INH = false;
    public static final RuleFactory rf = CSSFactory.getRuleFactory();
    public static final TermFactory tf = CSSFactory.getTermFactory();

    public static <T extends CSSProperty> T genericPropertyRaw(Class<T> type, Set<T> intersection, TermIdent term) {
        try {
            String name = ((String)term.getValue()).replace("-", "_").toUpperCase();
            T property = CSSProperty.Translator.valueOf(type, name);
            if (intersection != null && intersection.contains(property)) {
                return property;
            }
            return property;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T extends CSSProperty> boolean genericProperty(Class<T> type, TermIdent term, boolean avoidInherit, Map<String, CSSProperty> properties, String propertyName) {
        T property = Decoder.genericPropertyRaw(type, null, term);
        if (property == null || avoidInherit && property.equalsInherit()) {
            return false;
        }
        properties.put(propertyName, (CSSProperty)property);
        return true;
    }

    public static <T extends CSSProperty> boolean genericTermIdent(Class<T> type, Term<?> term, boolean avoidInherit, String propertyName, Map<String, CSSProperty> properties) {
        if (term instanceof TermIdent) {
            return Decoder.genericProperty(type, (TermIdent)term, avoidInherit, properties, propertyName);
        }
        return false;
    }

    public static <T extends CSSProperty> boolean genericTermColor(Term<?> term, String propertyName, T colorIdentification, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (term instanceof TermColor) {
            properties.put(propertyName, colorIdentification);
            values.put(propertyName, term);
            return true;
        }
        return false;
    }

    public static <T extends CSSProperty> boolean genericTermLength(Term<?> term, String propertyName, T lengthIdentification, ValueRange range, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (term instanceof TermInteger && ((TermInteger)term).getUnit().equals((Object)TermNumeric.Unit.none)) {
            if (CSSFactory.getImplyPixelLength() || ((Float)((TermInteger)term).getValue()).floatValue() == 0.0f) {
                TermLength tl = tf.createLength((Float)((TermInteger)term).getValue(), TermNumeric.Unit.px);
                return Decoder.genericTerm(TermLength.class, tl, propertyName, lengthIdentification, range, properties, values);
            }
            return false;
        }
        if (term instanceof TermLength) {
            return Decoder.genericTerm(TermLength.class, term, propertyName, lengthIdentification, range, properties, values);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends CSSProperty> boolean genericTerm(Class<? extends Term<?>> termType, Term<?> term, String propertyName, T typeIdentification, ValueRange range, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (!termType.isInstance(term)) return false;
        if (range != ValueRange.ALLOW_ALL) {
            if (term.getValue() instanceof Integer) {
                Integer zero = 0;
                int result = zero.compareTo((Integer)term.getValue());
                if (result > 0) {
                    if (range != ValueRange.TRUNCATE_NEGATIVE) return false;
                    ((TermInteger)term).setZero();
                } else if (result == 0 && range == ValueRange.DISALLOW_ZERO) {
                    return false;
                }
            } else if (term.getValue() instanceof Float) {
                Float zero = Float.valueOf(0.0f);
                int result = zero.compareTo((Float)term.getValue());
                if (result > 0) {
                    if (range != ValueRange.TRUNCATE_NEGATIVE) return false;
                    ((TermFloatValue)term).setZero();
                } else if (result == 0 && range == ValueRange.DISALLOW_ZERO) {
                    return false;
                }
            }
        }
        properties.put(propertyName, typeIdentification);
        values.put(propertyName, term);
        return true;
    }

    public static <T extends CSSProperty> boolean genericOneIdent(Class<T> type, Declaration d, Map<String, CSSProperty> properties) {
        if (d.size() != 1) {
            return false;
        }
        return Decoder.genericTermIdent(type, (Term)d.get(0), false, d.getProperty(), properties);
    }

    public static <T extends CSSProperty> boolean genericOneIdentOrColor(Class<T> type, T colorIdentification, Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() != 1) {
            return false;
        }
        return Decoder.genericTermIdent(type, (Term)d.get(0), false, d.getProperty(), properties) || Decoder.genericTermColor((Term)d.get(0), d.getProperty(), colorIdentification, properties, values);
    }

    public static <T extends CSSProperty> boolean genericOneIdentOrInteger(Class<T> type, T integerIdentification, ValueRange range, Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() != 1) {
            return false;
        }
        return Decoder.genericTermIdent(type, (Term)d.get(0), false, d.getProperty(), properties) || Decoder.genericTerm(TermInteger.class, (Term)d.get(0), d.getProperty(), integerIdentification, range, properties, values);
    }

    public static <T extends CSSProperty> boolean genericOneIdentOrIntegerOrNumber(Class<T> type, T integerIdentification, T numberIdentification, ValueRange range, Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() != 1) {
            return false;
        }
        return Decoder.genericTermIdent(type, (Term)d.get(0), false, d.getProperty(), properties) || Decoder.genericTerm(TermInteger.class, (Term)d.get(0), d.getProperty(), integerIdentification, range, properties, values) || Decoder.genericTerm(TermNumber.class, (Term)d.get(0), d.getProperty(), numberIdentification, range, properties, values);
    }

    public static <T extends CSSProperty> boolean genericOneIdentOrLength(Class<T> type, T lengthIdentification, ValueRange range, Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() != 1) {
            return false;
        }
        return Decoder.genericTermIdent(type, (Term)d.get(0), false, d.getProperty(), properties) || Decoder.genericTermLength((Term)d.get(0), d.getProperty(), lengthIdentification, range, properties, values);
    }

    public static <T extends CSSProperty> boolean genericTime(Class<T> type, T integerIdentification, ValueRange range, Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() != 1) {
            return false;
        }
        Term term = (Term)d.get(0);
        if (term instanceof TermIdent) {
            T property = Decoder.genericPropertyRaw(type, null, (TermIdent)term);
            if (property == null || !property.equalsInherit()) {
                return false;
            }
            properties.put(d.getProperty(), (CSSProperty)property);
            return true;
        }
        return Decoder.genericTerm(TermTime.class, term, d.getProperty(), integerIdentification, range, properties, values);
    }

    public static <T extends CSSProperty> boolean genericInteger(Class<T> type, T integerIdentification, ValueRange range, Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() != 1) {
            return false;
        }
        Term term = (Term)d.get(0);
        if (term instanceof TermIdent) {
            T property = Decoder.genericPropertyRaw(type, null, (TermIdent)term);
            if (!property.equalsInherit()) {
                return false;
            }
            properties.put(d.getProperty(), (CSSProperty)property);
            return true;
        }
        return Decoder.genericTerm(TermInteger.class, term, d.getProperty(), integerIdentification, range, properties, values);
    }

    public static <T extends CSSProperty> boolean genericIntegerOrLength(Class<T> type, T integerIdentification, T lengthIdentification, ValueRange range, Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() != 1) {
            return false;
        }
        Term term = (Term)d.get(0);
        if (term instanceof TermIdent) {
            T property = Decoder.genericPropertyRaw(type, null, (TermIdent)term);
            if (!property.equalsInherit()) {
                return false;
            }
            properties.put(d.getProperty(), (CSSProperty)property);
            return true;
        }
        return Decoder.genericTerm(TermInteger.class, term, d.getProperty(), integerIdentification, range, properties, values) || Decoder.genericTermLength(term, d.getProperty(), lengthIdentification, range, properties, values);
    }

    public static <T extends Enum<T>> boolean genericOneIdentOrLengthOrPercent(Class<T> type, T lengthIdentification, T percentIdentification, ValueRange range, Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() != 1) {
            return false;
        }
        return Decoder.genericTermIdent(type, (Term)d.get(0), false, d.getProperty(), properties) || Decoder.genericTermLength((Term)d.get(0), d.getProperty(), lengthIdentification, range, properties, values) || Decoder.genericTerm(TermPercent.class, (Term)d.get(0), d.getProperty(), percentIdentification, range, properties, values);
    }

    public static <T extends Enum<T>> boolean genericTwoIdentsOrLengthsOrPercents(Class<T> type, T listIdentification, ValueRange range, Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() == 1) {
            String propertyName;
            Term term = (Term)d.get(0);
            if (Decoder.genericTermIdent(type, term, false, propertyName = d.getProperty(), properties) || Decoder.genericTermLength(term, propertyName, listIdentification, range, properties, values) || Decoder.genericTerm(TermPercent.class, term, propertyName, listIdentification, range, properties, values)) {
                if (properties.get(propertyName) == listIdentification) {
                    TermList terms = tf.createList(2);
                    terms.add(term);
                    terms.add(term);
                    values.put(propertyName, terms);
                }
                return true;
            }
            return false;
        }
        if (d.size() == 2) {
            Term term1 = (Term)d.get(0);
            Term term2 = (Term)d.get(1);
            String propertyName = d.getProperty();
            if ((Decoder.genericTermLength(term1, propertyName, listIdentification, range, properties, values) || Decoder.genericTerm(TermPercent.class, term1, propertyName, listIdentification, range, properties, values)) && (Decoder.genericTermLength(term2, propertyName, listIdentification, range, properties, values) || Decoder.genericTerm(TermPercent.class, term2, propertyName, listIdentification, range, properties, values))) {
                TermList terms = tf.createList(2);
                terms.add(term1);
                terms.add(term2);
                values.put(propertyName, terms);
                return true;
            }
            return false;
        }
        return false;
    }

    public static List<Declaration> splitDeclarations(Declaration src, Term.Operator sepOperator) {
        ArrayList<Declaration> ret = new ArrayList<Declaration>();
        Declaration current = rf.createDeclaration();
        current.unlock();
        for (Term t : src.asList()) {
            if (t.getOperator() == sepOperator) {
                ret.add(current);
                current = rf.createDeclaration();
                current.unlock();
            }
            current.add(t);
        }
        ret.add(current);
        return ret;
    }

    public static enum ValueRange {
        ALLOW_ALL,
        DISALLOW_NEGATIVE,
        TRUNCATE_NEGATIVE,
        DISALLOW_ZERO;

    }
}

