/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign.decode;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermNumber;
import cz.vutbr.web.css.TermPercent;
import cz.vutbr.web.css.TermString;
import cz.vutbr.web.domassign.decode.Decoder;
import cz.vutbr.web.domassign.decode.Variator;
import java.util.EnumSet;
import java.util.Map;

public class FontVariator
extends Variator {
    public static final int STYLE = 0;
    public static final int VARIANT = 1;
    public static final int WEIGHT = 2;
    public static final int SIZE = 3;
    public static final int LINE_HEIGHT = 4;
    public static final int FAMILY = 5;

    public FontVariator() {
        super(6);
        this.names.add("font-style");
        this.types.add(CSSProperty.FontStyle.class);
        this.names.add("font-variant");
        this.types.add(CSSProperty.FontVariant.class);
        this.names.add("font-weight");
        this.types.add(CSSProperty.FontWeight.class);
        this.names.add("font-size");
        this.types.add(CSSProperty.FontSize.class);
        this.names.add("line-height");
        this.types.add(CSSProperty.LineHeight.class);
        this.names.add("font-family");
        this.types.add(CSSProperty.FontFamily.class);
    }

    @Override
    protected boolean variant(int v, Variator.IntegerRef iteration, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        int i = iteration.get();
        switch (v) {
            case 0: {
                return FontVariator.genericTermIdent((Class)this.types.get(0), (Term)this.terms.get(i), true, (String)this.names.get(0), properties);
            }
            case 1: {
                return FontVariator.genericTermIdent((Class)this.types.get(1), (Term)this.terms.get(i), true, (String)this.names.get(1), properties);
            }
            case 2: {
                Integer[] fontWeight = new Integer[]{100, 200, 300, 400, 500, 600, 700, 800, 900};
                Term term = (Term)this.terms.get(i);
                if (term instanceof TermIdent) {
                    return FontVariator.genericProperty((Class)this.types.get(2), (TermIdent)term, true, properties, (String)this.names.get(2));
                }
                if (term instanceof TermInteger) {
                    Integer test;
                    int result;
                    Integer value = ((TermInteger)term).getIntValue();
                    Integer[] integerArray = fontWeight;
                    int n = integerArray.length;
                    for (int j = 0; j < n && (result = value.compareTo(test = integerArray[j])) >= 0; ++j) {
                        if (result != 0) continue;
                        Object property = CSSProperty.Translator.valueOf((Class)this.types.get(2), "numeric_" + value);
                        if (property == null) {
                            return false;
                        }
                        properties.put((String)this.names.get(2), (CSSProperty)property);
                        return true;
                    }
                }
                return false;
            }
            case 3: {
                return FontVariator.genericTermIdent((Class)this.types.get(3), (Term)this.terms.get(i), true, (String)this.names.get(3), properties) || FontVariator.genericTermLength((Term)this.terms.get(i), (String)this.names.get(3), CSSProperty.FontSize.length, Decoder.ValueRange.DISALLOW_NEGATIVE, properties, values) || FontVariator.genericTerm(TermPercent.class, (Term)this.terms.get(i), (String)this.names.get(3), CSSProperty.FontSize.percentage, Decoder.ValueRange.DISALLOW_NEGATIVE, properties, values);
            }
            case 4: {
                return FontVariator.genericTermIdent((Class)this.types.get(4), (Term)this.terms.get(i), true, (String)this.names.get(4), properties) || FontVariator.genericTerm(TermNumber.class, (Term)this.terms.get(i), (String)this.names.get(4), CSSProperty.LineHeight.number, Decoder.ValueRange.DISALLOW_NEGATIVE, properties, values) || FontVariator.genericTerm(TermInteger.class, (Term)this.terms.get(i), (String)this.names.get(4), CSSProperty.LineHeight.number, Decoder.ValueRange.DISALLOW_NEGATIVE, properties, values) || FontVariator.genericTerm(TermPercent.class, (Term)this.terms.get(i), (String)this.names.get(4), CSSProperty.LineHeight.percentage, Decoder.ValueRange.DISALLOW_NEGATIVE, properties, values) || FontVariator.genericTerm(TermLength.class, (Term)this.terms.get(i), (String)this.names.get(4), CSSProperty.LineHeight.length, Decoder.ValueRange.DISALLOW_NEGATIVE, properties, values);
            }
            case 5: {
                TermList list = tf.createList();
                StringBuffer sb = new StringBuffer();
                boolean composed = false;
                for (Term t : this.terms.subList(i, this.terms.size())) {
                    if (t instanceof TermIdent && sb.length() == 0) {
                        sb.append(t.getValue());
                        composed = false;
                        continue;
                    }
                    if (t instanceof TermIdent && sb.length() != 0 && t.getOperator() != Term.Operator.COMMA && t.getOperator() != Term.Operator.SLASH) {
                        sb.append(" ").append(t.getValue());
                        composed = true;
                        continue;
                    }
                    if (t instanceof TermString || t instanceof TermIdent && t.getOperator() == Term.Operator.COMMA) {
                        this.storeFamilyName(list, sb.toString(), composed);
                        sb = new StringBuffer();
                        composed = false;
                        if (t instanceof TermString) {
                            this.storeFamilyName(list, (String)t.getValue(), true);
                            continue;
                        }
                        sb.append(t.getValue());
                        continue;
                    }
                    return false;
                }
                this.storeFamilyName(list, sb.toString(), composed);
                if (list.isEmpty()) {
                    return false;
                }
                if (list.size() == 1 && !(list.toArray(new Term[0])[0] instanceof TermString)) {
                    properties.put((String)this.names.get(5), (CSSProperty.FontFamily)list.toArray(new Term[0])[0].getValue());
                    return true;
                }
                properties.put((String)this.names.get(5), CSSProperty.FontFamily.list_values);
                values.put((String)this.names.get(5), list);
                iteration.set(this.terms.size());
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean variantCondition(int variant, Variator.IntegerRef iteration) {
        switch (variant) {
            case 0: 
            case 1: 
            case 2: {
                return iteration.get() < 3;
            }
            case 3: {
                return true;
            }
            case 4: {
                if (!this.variantPassed[3]) {
                    return false;
                }
                return ((Term)this.terms.get(iteration.get())).getOperator() == Term.Operator.SLASH;
            }
            case 5: {
                return this.variantPassed[3];
            }
        }
        return false;
    }

    @Override
    public boolean vary(Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (this.terms.size() == 1 && this.terms.get(0) instanceof TermIdent) {
            if (this.checkInherit(-1, (Term)this.terms.get(0), properties)) {
                return true;
            }
            return FontVariator.genericTermIdent(CSSProperty.Font.class, (Term)this.terms.get(0), true, "font", properties);
        }
        return super.vary(properties, values);
    }

    private void storeFamilyName(TermList storage, String name, boolean composed) {
        EnumSet<CSSProperty.FontFamily> allowedFamilies = EnumSet.complementOf(EnumSet.of(CSSProperty.FontFamily.INHERIT, CSSProperty.FontFamily.list_values));
        if (name == null || "".equals(name) || name.length() == 0) {
            return;
        }
        name = name.trim();
        if (composed) {
            TermString term = tf.createString(name);
            if (!storage.isEmpty()) {
                term.setOperator(Term.Operator.COMMA);
            }
            storage.add(term);
        } else {
            CSSProperty.FontFamily generic = FontVariator.genericPropertyRaw(CSSProperty.FontFamily.class, allowedFamilies, tf.createIdent(name));
            if (generic != null) {
                Term<CSSProperty.FontFamily> term = tf.createTerm(generic);
                if (!storage.isEmpty()) {
                    term.setOperator(Term.Operator.COMMA);
                }
                storage.add(term);
            } else {
                TermString term = tf.createString(name);
                if (!storage.isEmpty()) {
                    term.setOperator(Term.Operator.COMMA);
                }
                storage.add(term);
            }
        }
    }
}

