/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.logging;

import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.slf4j.spi.DefaultLoggingEventBuilder;
import org.slf4j.spi.LoggingEventBuilder;
import tokyo.northside.logging.LoggerDecorator;
import tokyo.northside.logging.LoggingEventDecorator;
import tokyo.northside.logging.LoggingEventDecoratorPassive;

public interface ILogger
extends Logger {
    default public LoggingEventDecorator makeLoggingEventBuilder(Level level) {
        return LoggerDecorator.deco((LoggingEventBuilder)new DefaultLoggingEventBuilder((Logger)this, level));
    }

    default public LoggingEventDecorator atLevel(Level level) {
        if (this.isEnabledForLevel(level)) {
            return this.makeLoggingEventBuilder(level);
        }
        return new LoggingEventDecoratorPassive();
    }

    default public LoggingEventDecorator atTrace() {
        if (this.isTraceEnabled()) {
            return this.makeLoggingEventBuilder(Level.TRACE);
        }
        return new LoggingEventDecoratorPassive();
    }

    default public LoggingEventDecorator atDebug() {
        if (this.isDebugEnabled()) {
            return this.makeLoggingEventBuilder(Level.DEBUG);
        }
        return new LoggingEventDecoratorPassive();
    }

    default public LoggingEventDecorator atInfo() {
        if (this.isInfoEnabled()) {
            return this.makeLoggingEventBuilder(Level.INFO);
        }
        return new LoggingEventDecoratorPassive();
    }

    default public LoggingEventDecorator atWarn() {
        if (this.isWarnEnabled()) {
            return this.makeLoggingEventBuilder(Level.WARN);
        }
        return new LoggingEventDecoratorPassive();
    }

    default public LoggingEventDecorator atError() {
        if (this.isErrorEnabled()) {
            return this.makeLoggingEventBuilder(Level.ERROR);
        }
        return new LoggingEventDecoratorPassive();
    }
}

