/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.logging;

import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.spi.LoggingEventBuilder;
import org.slf4j.spi.NOPLoggingEventBuilder;
import tokyo.northside.logging.ILogger;
import tokyo.northside.logging.LoggingEventDecorator;
import tokyo.northside.logging.LoggingEventDecoratorActive;
import tokyo.northside.logging.LoggingEventDecoratorPassive;

public class LoggerDecorator
implements ILogger {
    private final Logger logger;
    private final ResourceBundle bundle;
    public static final String LOCALISATION_MDC_KEY = "slf4j.localisation.bundle.key";
    public static final String LOCALISATION_KEY_APPENDER = "slf4j.localisation.bundle.key.appender";

    public static ILogger deco(Logger logger) {
        return new LoggerDecorator(logger, null);
    }

    public static ILogger deco(Logger logger, ResourceBundle bundle) {
        return new LoggerDecorator(logger, bundle);
    }

    public static LoggingEventDecorator deco(LoggingEventBuilder builder) {
        if (builder instanceof NOPLoggingEventBuilder) {
            return LoggingEventDecoratorPassive.INSTANCE;
        }
        return new LoggingEventDecoratorActive(builder);
    }

    public static LoggingEventDecorator deco(LoggingEventBuilder builder, ResourceBundle bundle) {
        if (builder instanceof NOPLoggingEventBuilder) {
            return LoggingEventDecoratorPassive.INSTANCE;
        }
        return new LoggingEventDecoratorActive(builder, bundle);
    }

    public LoggerDecorator(Logger logger, ResourceBundle bundle) {
        this.logger = logger;
        this.bundle = bundle;
    }

    public String getName() {
        return this.logger.getName();
    }

    @Override
    public LoggingEventDecorator makeLoggingEventBuilder(Level level) {
        if (this.bundle != null) {
            return LoggerDecorator.deco(this.logger.atLevel(level), this.bundle);
        }
        return LoggerDecorator.deco(this.logger.atLevel(level));
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String msg) {
        this.logger.trace(msg);
    }

    public void trace(String format, Object arg) {
        this.makeLoggingEventBuilder(Level.TRACE).log(format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.makeLoggingEventBuilder(Level.TRACE).log(format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.makeLoggingEventBuilder(Level.TRACE).log(format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.makeLoggingEventBuilder(Level.TRACE).setCause(t).setMessage(msg).log();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        this.makeLoggingEventBuilder(Level.TRACE).addMarker(marker).setMessage(msg).log();
    }

    public void trace(Marker marker, String format, Object arg) {
        this.makeLoggingEventBuilder(Level.TRACE).addMarker(marker).setMessage(format).addArgument(arg).log();
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.makeLoggingEventBuilder(Level.TRACE).addMarker(marker).setMessage(format).addArgument(arg1).addArgument(arg2).log();
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.makeLoggingEventBuilder(Level.TRACE).addMarker(marker).log(format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.makeLoggingEventBuilder(Level.TRACE).addMarker(marker).setCause(t).setMessage(msg).log();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg) {
        this.logger.debug(msg);
    }

    public void debug(String format, Object arg) {
        this.makeLoggingEventBuilder(Level.DEBUG).log(format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.makeLoggingEventBuilder(Level.DEBUG).log(format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.makeLoggingEventBuilder(Level.DEBUG).log(format, arguments);
    }

    public void debug(String msg, Throwable t) {
        this.makeLoggingEventBuilder(Level.DEBUG).setCause(t).setMessage(msg).log();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        this.makeLoggingEventBuilder(Level.DEBUG).addMarker(marker).setMessage(msg).log();
    }

    public void debug(Marker marker, String format, Object arg) {
        this.makeLoggingEventBuilder(Level.DEBUG).addMarker(marker).setMessage(format).addArgument(arg).log();
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.makeLoggingEventBuilder(Level.DEBUG).addMarker(marker).setMessage(format).addArgument(arg1).addArgument(arg2).log();
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.makeLoggingEventBuilder(Level.DEBUG).addMarker(marker).log(format, arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.makeLoggingEventBuilder(Level.DEBUG).addMarker(marker).setCause(t).setMessage(msg).log();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    public void info(String format, Object arg) {
        this.makeLoggingEventBuilder(Level.INFO).log(format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.makeLoggingEventBuilder(Level.INFO).log(format, arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        this.makeLoggingEventBuilder(Level.INFO).log(format, arguments);
    }

    public void info(String msg, Throwable t) {
        this.makeLoggingEventBuilder(Level.INFO).setCause(t).setMessage(msg).log();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        this.makeLoggingEventBuilder(Level.INFO).addMarker(marker).log(msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.makeLoggingEventBuilder(Level.INFO).addMarker(marker).log(format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.makeLoggingEventBuilder(Level.INFO).addMarker(marker).log(format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.makeLoggingEventBuilder(Level.INFO).addMarker(marker).log(format, arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.makeLoggingEventBuilder(Level.INFO).addMarker(marker).setCause(t).setMessage(msg).log();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String msg) {
        this.makeLoggingEventBuilder(Level.WARN).log(msg);
    }

    public void warn(String format, Object arg) {
        this.makeLoggingEventBuilder(Level.WARN).log(format, arg);
    }

    public void warn(String format, Object ... arguments) {
        this.makeLoggingEventBuilder(Level.WARN).log(format, arguments);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.makeLoggingEventBuilder(Level.WARN).log(format, arg1, arg2);
    }

    public void warn(String msg, Throwable t) {
        this.makeLoggingEventBuilder(Level.WARN).setCause(t).setMessage(msg).log();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        this.makeLoggingEventBuilder(Level.WARN).addMarker(marker).log(msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.makeLoggingEventBuilder(Level.WARN).addMarker(marker).log(format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.makeLoggingEventBuilder(Level.WARN).addMarker(marker).log(format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.makeLoggingEventBuilder(Level.WARN).addMarker(marker).log(format, arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.makeLoggingEventBuilder(Level.WARN).addMarker(marker).setCause(t).setMessage(msg).log();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String msg) {
        this.logger.error(msg);
    }

    public void error(String format, Object arg) {
        this.makeLoggingEventBuilder(Level.ERROR).log(format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.makeLoggingEventBuilder(Level.ERROR).log(format, arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        this.makeLoggingEventBuilder(Level.ERROR).log(format, arguments);
    }

    public void error(String msg, Throwable t) {
        this.makeLoggingEventBuilder(Level.ERROR).setCause(t).setMessage(msg).log();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        this.makeLoggingEventBuilder(Level.ERROR).addMarker(marker).log(msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.makeLoggingEventBuilder(Level.ERROR).addMarker(marker).log(format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.makeLoggingEventBuilder(Level.ERROR).addMarker(marker).log(format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.makeLoggingEventBuilder(Level.ERROR).addMarker(marker).log(format, arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.makeLoggingEventBuilder(Level.ERROR).addMarker(marker).setCause(t).setMessage(msg).log();
    }
}

