/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.logging;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;
import org.slf4j.spi.CallerBoundaryAware;
import org.slf4j.spi.LoggingEventBuilder;
import tokyo.northside.logging.LoggingEventDecorator;

class LoggingEventDecoratorActive
implements LoggingEventDecorator,
CallerBoundaryAware {
    private String message;
    private final ResourceBundle bundle;
    private String key;
    private Supplier<String> messageSupplier;
    private Throwable exception;
    private List<Object> arguments;
    private List<Marker> markers;
    private List<KeyValuePair> keyValuePairs;
    private final LoggingEventBuilder loggingEventBuilder;
    private final boolean appender;
    private static final String FQCN = LoggingEventDecoratorActive.class.getName();
    protected String fqcn = FQCN;

    public LoggingEventDecoratorActive(LoggingEventBuilder builder, ResourceBundle bundle, boolean appender) {
        this.loggingEventBuilder = builder;
        this.bundle = bundle;
        this.appender = appender;
    }

    public LoggingEventDecoratorActive(LoggingEventBuilder builder, ResourceBundle bundle) {
        this(builder, bundle, LoggingEventDecoratorActive.isAppender());
    }

    public LoggingEventDecoratorActive(LoggingEventBuilder builder) {
        this(builder, null, false);
    }

    private static boolean isAppender() {
        return "true".equalsIgnoreCase(System.getProperty("slf4j.localisation.bundle.key.appender"));
    }

    @Override
    public LoggingEventDecorator setMessage(String message) {
        this.message = message;
        this.key = null;
        this.messageSupplier = null;
        return this;
    }

    @Override
    public LoggingEventDecorator setMessageRB(String key) {
        this.key = key;
        this.messageSupplier = null;
        return this;
    }

    @Override
    public LoggingEventDecorator setCause(Throwable cause) {
        this.exception = cause;
        return this;
    }

    @Override
    public LoggingEventDecorator addMarker(Marker marker) {
        if (this.markers == null) {
            this.markers = new ArrayList<Marker>(2);
        }
        this.markers.add(marker);
        return this;
    }

    @Override
    public LoggingEventDecorator addArgument(Object p) {
        this.getNonNullArguments().add(p);
        return this;
    }

    @Override
    public LoggingEventDecorator addArgument(Supplier<?> objectSupplier) {
        this.addArgument(objectSupplier.get());
        return this;
    }

    @Override
    public LoggingEventDecorator addKeyValue(String key, Object value) {
        this.getNonnullKeyValuePairs().add(new KeyValuePair(key, value));
        return this;
    }

    @Override
    public LoggingEventDecorator addKeyValue(String key, Supplier<Object> valueSupplier) {
        this.getNonnullKeyValuePairs().add(new KeyValuePair(key, valueSupplier));
        return this;
    }

    @Override
    public LoggingEventDecorator setMessage(Supplier<String> messageSupplier) {
        this.messageSupplier = messageSupplier;
        this.key = null;
        return this;
    }

    public void log() {
        this.performLog();
    }

    private void performLog() {
        LoggingEventBuilder leb = this.loggingEventBuilder;
        if (this.key != null && this.bundle != null) {
            MDC.put((String)"slf4j.localisation.bundle.key", (String)this.key);
            String msg = this.format(LoggingEventDecoratorActive.getResourceStringOrKey(this.bundle, this.key), this.getArgumentArray());
            leb = this.appender ? leb.setMessage(msg + " (" + this.key + ")") : leb.setMessage(msg);
        } else if (this.messageSupplier != null) {
            leb = leb.setMessage(this.format(this.messageSupplier.get(), this.getArgumentArray()));
        } else if (this.message != null) {
            leb = leb.setMessage(this.format(this.message, this.getArgumentArray()));
        }
        if (this.exception != null) {
            leb = leb.setCause(this.exception);
        }
        if (this.markers != null) {
            for (Marker m : this.markers) {
                leb = leb.addMarker(m);
            }
        }
        if (this.keyValuePairs != null) {
            for (KeyValuePair p : this.keyValuePairs) {
                leb = leb.addKeyValue(p.key, p.value);
            }
        }
        if (leb instanceof CallerBoundaryAware) {
            ((CallerBoundaryAware)leb).setCallerBoundary(this.fqcn);
        }
        leb.log();
        if (MDC.get((String)"slf4j.localisation.bundle.key") != null) {
            MDC.remove((String)"slf4j.localisation.bundle.key");
        }
    }

    public void log(String message) {
        this.setMessage(message).log();
    }

    public void log(String message, Object arg) {
        this.setMessage(message).addArgument(arg).log();
    }

    public void log(String message, Object arg0, Object arg1) {
        this.setMessage(message).addArgument(arg0).addArgument(arg1).log();
    }

    public void log(String message, Object ... args) {
        this.getNonNullArguments().addAll(Arrays.asList(args));
        this.setMessage(message);
        this.performLog();
    }

    public void log(Supplier<String> messageSupplier) {
        this.setMessage((Supplier)messageSupplier).log();
    }

    @Override
    public void logRB(String key) {
        this.setMessageRB(key).log();
    }

    @Override
    public void logRB(String key, Object arg) {
        this.setMessageRB(key).addArgument(arg).log();
    }

    @Override
    public void logRB(String key, Object arg0, Object arg1) {
        this.setMessageRB(key).addArgument(arg0).addArgument(arg1).log();
    }

    @Override
    public void logRB(String key, Object ... args) {
        this.getNonNullArguments().addAll(Arrays.asList(args));
        this.setMessageRB(key);
        this.performLog();
    }

    private List<Object> getNonNullArguments() {
        if (this.arguments == null) {
            this.arguments = new ArrayList<Object>(3);
        }
        return this.arguments;
    }

    private List<KeyValuePair> getNonnullKeyValuePairs() {
        if (this.keyValuePairs == null) {
            this.keyValuePairs = new ArrayList<KeyValuePair>(4);
        }
        return this.keyValuePairs;
    }

    private Object[] getArgumentArray() {
        if (this.arguments == null) {
            return null;
        }
        return this.arguments.toArray();
    }

    private String format(String str, Object ... arguments) {
        if (arguments != null && arguments.length > 0) {
            String format = str.replaceAll("'", "''");
            try {
                return MessageFormat.format(format, arguments);
            }
            catch (IllegalArgumentException iae) {
                return str;
            }
        }
        return str;
    }

    private static String getResourceStringOrKey(ResourceBundle bundle, String key) {
        if (bundle == null || key == null) {
            return key;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
        catch (ClassCastException ex) {
            return bundle.getObject(key).toString();
        }
    }

    public void setCallerBoundary(String fqcn) {
        this.fqcn = fqcn;
    }
}

