/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.io;

public class XByteBuffer {
    public static final byte[] START_DATA = new byte[]{70, 76, 84, 50, 48, 48, 50};
    public static final byte[] END_DATA = new byte[]{84, 76, 70, 50, 48, 48, 51};
    static final int DEF_SIZE = 1024;
    static final int DEF_EXT = 1024;
    protected byte[] buf = null;
    protected int bufSize = 0;

    public XByteBuffer(int size) {
        this.buf = new byte[size];
    }

    public XByteBuffer() {
        this(1024);
    }

    public synchronized byte[] getBytes() {
        byte[] b = new byte[this.bufSize];
        System.arraycopy(this.buf, 0, b, 0, this.bufSize);
        return b;
    }

    public synchronized void clear() {
        this.bufSize = 0;
    }

    public synchronized boolean append(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return false;
        }
        int newcount = this.bufSize + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.bufSize);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.bufSize, len);
        this.bufSize = newcount;
        if (this.bufSize > START_DATA.length && XByteBuffer.firstIndexOf(this.buf, 0, START_DATA) == -1) {
            this.bufSize = 0;
            System.out.println("Discarded the package, invalid header");
            return false;
        }
        return true;
    }

    protected synchronized int packageExists() {
        int pos = START_DATA.length;
        int index = XByteBuffer.firstIndexOf(this.buf, 0, START_DATA);
        if (index != 0 || this.bufSize < 10) {
            return 0;
        }
        int size = XByteBuffer.toInt(this.buf, pos);
        if ((pos = START_DATA.length + 4 + size) + END_DATA.length > this.bufSize) {
            return 0;
        }
        int newpos = XByteBuffer.firstIndexOf(this.buf, pos, END_DATA);
        if (newpos != pos) {
            return 0;
        }
        return size;
    }

    public synchronized boolean doesPackageExist() {
        return this.packageExists() > 0;
    }

    public synchronized byte[] extractPackage(boolean clearFromBuffer) {
        int size = this.packageExists();
        if (size == 0) {
            throw new IllegalStateException("No package exists in XByteBuffer");
        }
        byte[] result = new byte[size];
        System.arraycopy(this.buf, START_DATA.length + 4, result, 0, size);
        if (clearFromBuffer) {
            int totalsize = START_DATA.length + 4 + size + END_DATA.length;
            this.bufSize -= totalsize;
            System.arraycopy(this.buf, totalsize, this.buf, 0, this.bufSize);
        }
        return result;
    }

    public static int toInt(byte[] b, int off) {
        return (b[off + 3] & 0xFF) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off + 0] & 0xFF) << 24);
    }

    public static long toLong(byte[] b, int off) {
        return ((long)b[off + 7] & 0xFFL) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 0] & 0xFFL) << 56);
    }

    public static byte[] toBytes(int n) {
        byte[] b = new byte[4];
        b[3] = (byte)n;
        b[2] = (byte)(n >>>= 8);
        b[1] = (byte)(n >>>= 8);
        b[0] = (byte)(n >>>= 8);
        return b;
    }

    public static byte[] toBytes(long n) {
        byte[] b = new byte[8];
        b[7] = (byte)n;
        b[6] = (byte)(n >>>= 8);
        b[5] = (byte)(n >>>= 8);
        b[4] = (byte)(n >>>= 8);
        b[3] = (byte)(n >>>= 8);
        b[2] = (byte)(n >>>= 8);
        b[1] = (byte)(n >>>= 8);
        b[0] = (byte)(n >>>= 8);
        return b;
    }

    public static int firstIndexOf(byte[] src, int srcOff, byte[] find) {
        int result = -1;
        if (find.length > src.length) {
            return result;
        }
        if (find.length == 0 || src.length == 0) {
            return result;
        }
        if (srcOff >= src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        boolean found = false;
        int srclen = src.length;
        int findlen = find.length;
        byte first = find[0];
        int pos = srcOff;
        while (!found) {
            while (pos < srclen && first != src[pos]) {
                ++pos;
            }
            if (pos >= srclen) {
                return -1;
            }
            if (srclen - pos < findlen) {
                return -1;
            }
            found = true;
            for (int i = 1; i < findlen && found; ++i) {
                found = found && find[i] == src[pos + i];
            }
            if (found) {
                result = pos;
                continue;
            }
            if (srclen - pos < findlen) {
                return -1;
            }
            ++pos;
        }
        return result;
    }

    public static byte[] createDataPackage(byte[] data) {
        byte[] result = new byte[START_DATA.length + 4 + data.length + END_DATA.length];
        System.arraycopy(START_DATA, 0, result, 0, START_DATA.length);
        System.arraycopy(XByteBuffer.toBytes(data.length), 0, result, START_DATA.length, 4);
        System.arraycopy(data, 0, result, START_DATA.length + 4, data.length);
        System.arraycopy(END_DATA, 0, result, START_DATA.length + 4 + data.length, END_DATA.length);
        return result;
    }

    public static void main(String[] args) {
        System.out.println("Before=2147483647");
        byte[] d = XByteBuffer.toBytes(Integer.MAX_VALUE);
        System.out.println("After=" + XByteBuffer.toInt(d, 0));
        System.out.println("Before=9223372036854775807");
        d = XByteBuffer.toBytes(Long.MAX_VALUE);
        System.out.println("After=" + XByteBuffer.toLong(d, 0));
        System.out.println("Before=4564564");
        d = XByteBuffer.toBytes(4564564L);
        System.out.println("After=" + XByteBuffer.toLong(d, 0));
    }
}

