/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.mcast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.catalina.cluster.mcast.McastMember;

public class McastMembership {
    protected String name;
    protected HashMap map = new HashMap();

    public McastMembership(String myName) {
        this.name = myName;
    }

    public synchronized void reset() {
        this.map.clear();
    }

    public synchronized boolean memberAlive(McastMember m) {
        boolean result = false;
        if (m.getName().equals(this.name)) {
            return result;
        }
        MbrEntry entry = (MbrEntry)this.map.get(m.getName());
        if (entry == null) {
            entry = new MbrEntry(m);
            this.map.put(m.getName(), entry);
            result = true;
        }
        entry.accessed();
        return result;
    }

    public synchronized McastMember[] expire(long maxtime) {
        MbrEntry[] members = this.getMemberEntries();
        ArrayList<McastMember> list = new ArrayList<McastMember>();
        for (int i = 0; i < members.length; ++i) {
            MbrEntry entry = members[i];
            if (!entry.hasExpired(maxtime)) continue;
            list.add(entry.getMember());
        }
        McastMember[] result = new McastMember[list.size()];
        list.toArray(result);
        for (int j = 0; j < result.length; ++j) {
            this.map.remove(result[j].getName());
        }
        return result;
    }

    public synchronized McastMember[] getMembers() {
        McastMember[] result = new McastMember[this.map.size()];
        Iterator i = this.map.entrySet().iterator();
        int pos = 0;
        while (i.hasNext()) {
            result[pos++] = ((MbrEntry)i.next().getValue()).getMember();
        }
        return result;
    }

    protected synchronized MbrEntry[] getMemberEntries() {
        MbrEntry[] result = new MbrEntry[this.map.size()];
        Iterator i = this.map.entrySet().iterator();
        int pos = 0;
        while (i.hasNext()) {
            result[pos++] = (MbrEntry)i.next().getValue();
        }
        return result;
    }

    protected static class MbrEntry {
        protected McastMember mbr;
        protected long lastHeardFrom;

        public MbrEntry(McastMember mbr) {
            this.mbr = mbr;
        }

        public void accessed() {
            this.lastHeardFrom = System.currentTimeMillis();
        }

        public McastMember getMember() {
            return this.mbr;
        }

        public boolean hasExpired(long maxtime) {
            long delta = System.currentTimeMillis() - this.lastHeardFrom;
            return delta > maxtime;
        }
    }
}

