/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.mcast;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import org.apache.catalina.cluster.MembershipListener;
import org.apache.catalina.cluster.mcast.McastMember;
import org.apache.catalina.cluster.mcast.McastMembership;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class McastServiceImpl {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$mcast$McastService == null ? (class$org$apache$catalina$cluster$mcast$McastService = McastServiceImpl.class$("org.apache.catalina.cluster.mcast.McastService")) : class$org$apache$catalina$cluster$mcast$McastService));
    protected boolean doRun = false;
    protected MulticastSocket socket;
    protected McastMember member;
    protected InetAddress address;
    protected int port;
    protected long timeToExpiration;
    protected long sendFrequency;
    protected DatagramPacket sendPacket;
    protected DatagramPacket receivePacket;
    protected McastMembership membership;
    protected MembershipListener service;
    protected ReceiverThread receiver;
    protected SenderThread sender;
    protected long serviceStartTime = 0L;
    static /* synthetic */ Class class$org$apache$catalina$cluster$mcast$McastService;

    public McastServiceImpl(McastMember member, long sendFrequency, long expireTime, int port, InetAddress bind, InetAddress mcastAddress, MembershipListener service) throws IOException {
        this.socket = bind != null ? new MulticastSocket(new InetSocketAddress(bind, port)) : new MulticastSocket(port);
        this.member = member;
        this.address = mcastAddress;
        this.port = port;
        this.sendPacket = new DatagramPacket(new byte[1000], 1000);
        this.sendPacket.setAddress(this.address);
        this.sendPacket.setPort(port);
        this.receivePacket = new DatagramPacket(new byte[1000], 1000);
        this.receivePacket.setAddress(this.address);
        this.receivePacket.setPort(port);
        this.membership = new McastMembership(member.getName());
        this.timeToExpiration = expireTime;
        this.service = service;
        this.sendFrequency = sendFrequency;
    }

    public synchronized void start() throws IOException {
        if (this.doRun) {
            throw new IllegalStateException("Service already running.");
        }
        this.socket.joinGroup(this.address);
        this.doRun = true;
        this.sender = new SenderThread(this.sendFrequency);
        this.sender.setDaemon(true);
        this.receiver = new ReceiverThread();
        this.receiver.setDaemon(true);
        this.receiver.start();
        this.sender.start();
        this.serviceStartTime = System.currentTimeMillis();
    }

    public synchronized void stop() throws IOException {
        this.socket.leaveGroup(this.address);
        this.doRun = false;
        this.sender = null;
        this.receiver = null;
        this.serviceStartTime = Long.MAX_VALUE;
    }

    public void receive() throws IOException {
        this.socket.receive(this.receivePacket);
        byte[] data = new byte[this.receivePacket.getLength()];
        System.arraycopy(this.receivePacket.getData(), this.receivePacket.getOffset(), data, 0, data.length);
        McastMember m = McastMember.getMember(data);
        if (this.membership.memberAlive(m)) {
            this.service.memberAdded(m);
        }
        McastMember[] expired = this.membership.expire(this.timeToExpiration);
        for (int i = 0; i < expired.length; ++i) {
            this.service.memberDisappeared(expired[i]);
        }
    }

    public void send() throws Exception {
        this.member.inc();
        byte[] data = this.member.getData(this.serviceStartTime);
        DatagramPacket p = new DatagramPacket(data, data.length);
        p.setAddress(this.address);
        p.setPort(this.port);
        this.socket.send(p);
    }

    public long getServiceStartTime() {
        return this.serviceStartTime;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SenderThread
    extends Thread {
        long time;

        public SenderThread(long time) {
            this.time = time;
        }

        public void run() {
            while (McastServiceImpl.this.doRun) {
                try {
                    McastServiceImpl.this.send();
                    SenderThread.sleep(this.time);
                }
                catch (Exception x) {
                    log.warn((Object)"Unable to send mcast message.", (Throwable)x);
                }
            }
        }
    }

    public class ReceiverThread
    extends Thread {
        public void run() {
            while (McastServiceImpl.this.doRun) {
                try {
                    McastServiceImpl.this.receive();
                }
                catch (Exception x) {
                    log.warn((Object)"Error receiving mcast package.", (Throwable)x);
                }
            }
        }
    }
}

