/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.tcp.AsyncSocketSender;
import org.apache.catalina.cluster.tcp.IDataSender;
import org.apache.catalina.cluster.tcp.SocketSender;

public class IDataSenderFactory {
    public static final String SYNC_MODE = "synchronous";
    public static final String ASYNC_MODE = "asynchronous";

    private IDataSenderFactory() {
    }

    public static synchronized IDataSender getIDataSender(String mode, Member mbr) throws IOException {
        if (SYNC_MODE.equals(mode)) {
            return new SocketSender(InetAddress.getByName(mbr.getHost()), mbr.getPort());
        }
        if (ASYNC_MODE.equals(mode)) {
            return new AsyncSocketSender(InetAddress.getByName(mbr.getHost()), mbr.getPort());
        }
        throw new IOException("Invalid replication mode=" + mode);
    }
}

