/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.catalina.cluster.io.ObjectReader;
import org.apache.catalina.cluster.tcp.WorkerThread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpReplicationThread
extends WorkerThread {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$SimpleTcpCluster == null ? (class$org$apache$catalina$cluster$tcp$SimpleTcpCluster = TcpReplicationThread.class$("org.apache.catalina.cluster.tcp.SimpleTcpCluster")) : class$org$apache$catalina$cluster$tcp$SimpleTcpCluster));
    private ByteBuffer buffer = ByteBuffer.allocate(1024);
    private SelectionKey key;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$SimpleTcpCluster;

    TcpReplicationThread() {
    }

    public synchronized void run() {
        while (this.doRun) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                log.info((Object)"TCP worker thread interrupted in cluster", (Throwable)e);
                this.interrupted();
            }
            if (this.key == null) continue;
            try {
                this.drainChannel(this.key);
            }
            catch (Exception e) {
                log.info((Object)("TCP Worker thread in cluster caught '" + e + "' closing channel"));
                try {
                    this.key.channel().close();
                }
                catch (IOException ex) {
                    log.error((Object)"Unable to close channel.", (Throwable)ex);
                }
                this.key.selector().wakeup();
            }
            this.key = null;
            this.pool.returnWorker(this);
        }
    }

    synchronized void serviceChannel(SelectionKey key) {
        this.key = key;
        key.interestOps(key.interestOps() & 0xFFFFFFFE);
        this.notify();
    }

    void drainChannel(SelectionKey key) throws Exception {
        int count;
        SocketChannel channel = (SocketChannel)key.channel();
        this.buffer.clear();
        ObjectReader reader = (ObjectReader)key.attachment();
        while ((count = channel.read(this.buffer)) > 0) {
            this.buffer.flip();
            reader.append(this.buffer.array(), 0, count);
            this.buffer.clear();
        }
        reader.execute();
        if (count < 0) {
            channel.close();
            return;
        }
        key.interestOps(key.interestOps() | 1);
        key.selector().wakeup();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

