/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster;

import java.io.Serializable;
import org.apache.catalina.cluster.Member;

public class SessionMessage
implements Serializable {
    public static final int EVT_SESSION_CREATED = 1;
    public static final int EVT_SESSION_EXPIRED = 2;
    public static final int EVT_SESSION_ACCESSED = 3;
    public static final int EVT_GET_ALL_SESSIONS = 4;
    public static final int EVT_SESSION_DELTA = 13;
    public static final int EVT_ALL_SESSION_DATA = 12;
    private int mEvtType = -1;
    private byte[] mSession;
    private String mSessionID;
    private Member mSrc;
    private String mContextName;
    private long serializationTimestamp;

    public SessionMessage(String contextName, int eventtype, byte[] session, String sessionID) {
        this.mEvtType = eventtype;
        this.mSession = session;
        this.mSessionID = sessionID;
        this.mContextName = contextName;
    }

    public int getEventType() {
        return this.mEvtType;
    }

    public byte[] getSession() {
        return this.mSession;
    }

    public String getSessionID() {
        return this.mSessionID;
    }

    public void setTimestamp(long time) {
        this.serializationTimestamp = time;
    }

    public long getTimestamp() {
        return this.serializationTimestamp;
    }

    public String getEventTypeString() {
        switch (this.mEvtType) {
            case 1: {
                return "SESSION-MODIFIED";
            }
            case 2: {
                return "SESSION-EXPIRED";
            }
            case 3: {
                return "SESSION-ACCESSED";
            }
            case 4: {
                return "SESSION-GET-ALL";
            }
            case 13: {
                return "SESSION-DELTA";
            }
            case 12: {
                return "ALL-SESSION-DATA";
            }
        }
        return "UNKNOWN-EVENT-TYPE";
    }

    public Member getAddress() {
        return this.mSrc;
    }

    public void setAddress(Member src) {
        this.mSrc = src;
    }

    public String getContextName() {
        return this.mContextName;
    }
}

