/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.apache.catalina.cluster.io.ListenCallback;
import org.apache.catalina.cluster.io.ObjectReader;
import org.apache.catalina.cluster.tcp.TcpReplicationThread;
import org.apache.catalina.cluster.tcp.ThreadPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplicationListener
extends Thread {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$SimpleTcpCluster == null ? (class$org$apache$catalina$cluster$tcp$SimpleTcpCluster = ReplicationListener.class$("org.apache.catalina.cluster.tcp.SimpleTcpCluster")) : class$org$apache$catalina$cluster$tcp$SimpleTcpCluster));
    private ThreadPool pool = null;
    private boolean doListen = false;
    private ListenCallback callback;
    private InetAddress bind;
    private int port;
    private long timeout = 0L;
    private boolean synchronous = false;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$SimpleTcpCluster;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$TcpReplicationThread;

    public ReplicationListener(ListenCallback callback, int poolSize, InetAddress bind, int port, long timeout, boolean synchronous) {
        try {
            this.synchronous = synchronous;
            this.pool = new ThreadPool(poolSize, class$org$apache$catalina$cluster$tcp$TcpReplicationThread == null ? (class$org$apache$catalina$cluster$tcp$TcpReplicationThread = ReplicationListener.class$("org.apache.catalina.cluster.tcp.TcpReplicationThread")) : class$org$apache$catalina$cluster$tcp$TcpReplicationThread);
        }
        catch (Exception x) {
            log.fatal((Object)("Unable to start thread pool for TCP listeners, session replication will fail! msg=" + x.getMessage()));
        }
        this.callback = callback;
        this.bind = bind;
        this.port = port;
        this.timeout = timeout;
    }

    public void run() {
        try {
            this.listen();
        }
        catch (Exception x) {
            log.error((Object)"Unable to start cluster listener.", (Throwable)x);
        }
    }

    public void listen() throws Exception {
        this.doListen = true;
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        ServerSocket serverSocket = serverChannel.socket();
        Selector selector = Selector.open();
        serverSocket.bind(new InetSocketAddress(this.bind, this.port));
        serverChannel.configureBlocking(false);
        serverChannel.register(selector, 16);
        while (this.doListen) {
            try {
                int n = selector.select(this.timeout);
                if (n == 0) continue;
                Iterator<SelectionKey> it = selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    if (key.isAcceptable()) {
                        ServerSocketChannel server = (ServerSocketChannel)key.channel();
                        SocketChannel channel = server.accept();
                        this.registerChannel(selector, channel, 1, new ObjectReader(channel, selector, this.callback));
                    }
                    if (key.isReadable()) {
                        this.readDataFromSocket(key);
                    } else {
                        key.interestOps(key.interestOps() & ~4);
                    }
                    it.remove();
                }
            }
            catch (CancelledKeyException nx) {
                log.warn((Object)"Replication client disconnected, error when polling key. Ignoring client.");
            }
            catch (Exception x) {
                log.error((Object)"Unable to process request in ReplicationListener", (Throwable)x);
            }
        }
        serverChannel.close();
        selector.close();
    }

    public void stopListening() {
        this.doListen = false;
    }

    protected void registerChannel(Selector selector, SelectableChannel channel, int ops, Object attach) throws Exception {
        if (channel == null) {
            return;
        }
        channel.configureBlocking(false);
        channel.register(selector, ops, attach);
    }

    protected void readDataFromSocket(SelectionKey key) throws Exception {
        TcpReplicationThread worker = (TcpReplicationThread)this.pool.getWorker();
        if (worker == null) {
            return;
        }
        worker.serviceChannel(key, this.synchronous);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

