/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.catalina.cluster.io.XByteBuffer;
import org.apache.catalina.cluster.tcp.IDataSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplicationTransmitter {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$SimpleTcpCluster == null ? (class$org$apache$catalina$cluster$tcp$SimpleTcpCluster = ReplicationTransmitter.class$("org.apache.catalina.cluster.tcp.SimpleTcpCluster")) : class$org$apache$catalina$cluster$tcp$SimpleTcpCluster));
    private HashMap map = new HashMap();
    private static long nrOfRequests = 0L;
    private static long totalBytes = 0L;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$SimpleTcpCluster;

    public ReplicationTransmitter(IDataSender[] senders) {
        for (int i = 0; i < senders.length; ++i) {
            this.map.put(senders[i].getAddress().getHostAddress() + ":" + senders[i].getPort(), senders[i]);
        }
    }

    private static synchronized void addStats(int length) {
        totalBytes += (long)length;
        if (++nrOfRequests % 100L == 0L) {
            log.info((Object)("Nr of bytes sent=" + totalBytes + " over " + nrOfRequests + " ==" + totalBytes / nrOfRequests + " bytes/request"));
        }
    }

    public synchronized void add(IDataSender sender) {
        String key = sender.getAddress().getHostAddress() + ":" + sender.getPort();
        if (!this.map.containsKey(key)) {
            this.map.put(sender.getAddress().getHostAddress() + ":" + sender.getPort(), sender);
        }
    }

    public synchronized void remove(InetAddress addr, int port) {
        String key = addr.getHostAddress() + ":" + port;
        IDataSender sender = (IDataSender)this.map.get(key);
        if (sender == null) {
            return;
        }
        sender.disconnect();
        this.map.remove(key);
    }

    public void start() throws IOException {
    }

    public synchronized void stop() {
        Iterator i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            IDataSender sender = (IDataSender)i.next().getValue();
            if (!sender.isConnected()) continue;
            try {
                sender.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    public IDataSender[] getSenders() {
        Iterator i = this.map.entrySet().iterator();
        Vector<IDataSender> v = new Vector<IDataSender>();
        while (i.hasNext()) {
            IDataSender sender = (IDataSender)i.next().getValue();
            if (sender == null) continue;
            v.addElement(sender);
        }
        Object[] result = new IDataSender[v.size()];
        v.copyInto(result);
        return result;
    }

    protected void sendMessageData(String sessionId, byte[] data, IDataSender sender) throws IOException {
        if (sender == null) {
            throw new IOException("Sender not available. Make sure sender information is available to the ReplicationTransmitter.");
        }
        try {
            if (!sender.isConnected()) {
                sender.connect();
            }
            sender.sendMessage(sessionId, data);
            sender.setSuspect(false);
            ReplicationTransmitter.addStats(data.length);
        }
        catch (Exception x) {
            if (!sender.getSuspect()) {
                log.warn((Object)"Unable to send replicated message, is server down?", (Throwable)x);
            }
            sender.setSuspect(true);
        }
    }

    public void sendMessage(String sessionId, byte[] indata, InetAddress addr, int port) throws IOException {
        byte[] data = XByteBuffer.createDataPackage(indata);
        String key = addr.getHostAddress() + ":" + port;
        IDataSender sender = (IDataSender)this.map.get(key);
        this.sendMessageData(sessionId, data, sender);
    }

    public void sendMessage(String sessionId, byte[] indata) throws IOException {
        IDataSender[] senders = this.getSenders();
        byte[] data = XByteBuffer.createDataPackage(indata);
        for (int i = 0; i < senders.length; ++i) {
            IDataSender sender = senders[i];
            try {
                this.sendMessageData(sessionId, data, sender);
                continue;
            }
            catch (Exception x) {
                if (!sender.getSuspect()) {
                    log.warn((Object)("Unable to send replicated message to " + sender + ", is server down?"), (Throwable)x);
                }
                sender.setSuspect(true);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

